# Spellcasting

## Sources of Magic

### Arcane Source

A spell might be Arcane if it:

- Detects, suppresses, ends, or otherwise interacts with mechanical aspects of spellcasting.
- Harnesses elemental energy (acid, cold, fire, lightning, or thunder).
- Interacts with a creature's senses, whether to fool them or to extend their capabilities.

### Divine Source

A spell might be Divine if it:

- Specifically interacts with another creature's life force, whether to heal or harm.
- Harnesses radiant or necrotic energy.
- Specifies interaction with a deity or includes the word "faith" in the description.

### Primordial Source

A Spell Might Be Primordial If It:

- Alters or enhances a creature's biological characteristics.
- Specifically interacts with plants or animals.
- Replicates an effect that could possibly occur as a natural phenomenon.

### Wyrd Source

A spell might be Wyrd if it:

- Summons a creature from a different plane or realm of existence.
- Harnesses energy that isn't elemental in nature.
- Allows travel between different planes of existence.

## Spell Circles

Every spell has a circle, ranked from 1st to 9th. The higher a spell's circle, the more energy it requires to cast and the stronger its effect.

Like the rings within a tree trunk, circles of magic encircle one another. A novice spellcaster starts at the center of the circle with access only to the 1st circle. As a spellcaster grows in ability, their power expands outward, giving them access to higher circles. The further a circle is from the center, the higher level a spellcaster must be to use that circle's spells.

Each class provides a table of what spellcaster level you must achieve before you gain access to new spell circles. Typically, a spellcaster must be at least 17th level before they can cast spells from the 9th-and final-circle.

## Spell Slots

Spell slots are a measure of the reserves that a caster has to hold spell energy, like the reservoir behind a dam. Check the progression table for your spellcasting class to see how many spell slots your character has at a given level. As you gain levels, you gain new slots to cast spells from higher circles and additional slots to cast spells from lower circles.

A caster who has used all their spell slots is spent physically and mentally. They're out of reserves for further spellcasting. To replenish spell slots, you must complete a short or long rest. Each class specifies which type of rest is required and how many slots you regain when you complete one. This rest represents the time needed to recover from the toll spellcasting takes on the body and mind.

### Casting At Higher Circles

Some Spell Descriptions End With An At Higher Circles Section. Casting a spell at a higher circle uses a higher spell slot and increases the spell's power.

When you cast a spell at a higher circle, the spell assumes all aspects of the higher circle for that casting. For instance, if a wizard casts _magic missile_ using a 2nd-circle spell slot, that magic missile is considered a 2nd-circle spell. Effectively, the spell expands to fill the slot into which it is put.

## Schools of Magic

### Abjuration

Abjuration spells use wards, shields, and other means of deflection to defend a target. Such spells might look like creating a force shield to block incoming missiles or imbuing a homestead with a ward to deter unwanted pests.

### Conjuration

Conjuration spells restructure space, enabling objects, creatures, and other targets to be transported from place to place. Such spells might look like causing a lost key to appear in your hand or creating a portal that allows for instantaneous travel to another plane of existence.

### Divination

Divination spells collect information, allowing a user to glean locations, outcomes, or sensory feedback beyond the limitations of standard perception. Such spells might look like sensing the location of a hidden entrance or predicting the outcome of future events.

### Enchantment

Enchantment spells influence the minds of creatures, allowing a user to manipulate emotions or behavior.

Such spells might compel a creature to behave erratically or convince a former enemy to perceive you as a trusted friend.

### Evocation

Evocation spells amplify and focus energy, allowing a user to create awesome-and often destructive-unnatural effects. Such spells might look like causing an object to emit light, causing the air to explode into flames, or stirring the skies into a raging storm.

### Illusion

Illusion spells deceive the senses, allowing a user to mask or alter the truth and create objects that seem real.

Such spells might allow a caster to completely alter their appearance or torment enemies with nightmarish visions.

### Necromancy

Necromancy spells manipulate the forces of life and death, allowing a user to heal, harm, or even raise creatures from the dead. Such spells might cause a missing limb to regrow or cause living flesh to instantly rot.

### Transmutation

Transmutation spells alter the forms of creatures or objects, allowing a user to change or enhance them. Such spells might change lead into gold or transform an enemy into a toad.

## Known Spells

A spellcaster must be extremely familiar with a spell or possess a magic item imbued with the spell to cast it. Each spellcasting class solves this familiarity issue differently.

For example, a wizard catalogs their known spells in a spellbook and can add to it when they discover a new spell. Your character class defines how many spells you know and can potentially learn as you gain more class levels.

## Prepared Spells

A prepared spell is ready to cast quickly, in the heat of battle-all the reading and setup is done beforehand. Due to the intense mental fortitude necessary, the number of spells a caster can prepare at one time is generally limited.

Some spellcasters, such as clerics and wizards, must prepare all their spells ahead of time through study or meditation. Different spellcasting classes with shorter known spell lists can automatically prepare all their known spells.

Your character class defines what you must do to prepare spells and how many spells you can have prepared at any given level.

## Cantrips

Some spellcasters can cast a simple type of spell called a cantrip. A caster can cast a cantrip without using a spell slot and without preparing it. Repeated practice has fixed the spell in the caster's mind and infused the caster with the energy needed to produce the effect on demand. A cantrip's spell circle is 0.

Your character class typically defines whether you can access cantrips and how many cantrips you know at each class level. Many cantrips increase in power as you do. **Regardless of how you have the cantrip (such as from a class or a talent), you use your character level, not your level in a spellcasting class, to determine the cantrip's power.**

## Rituals

Ritual spells are uniquely powerful magic that take 1 minute or longer to cast and often require costly material components. A caster can only learn ritual spells associated with their source spell list. Your character class defines whether you can access ritual spells and how many rituals you know at each class level.

Ritual spells don't use spell slots and therefore can't be cast at higher circles in the way standard spells can. However, certain ritual spells automatically increase in power as a caster gains access to higher circle spell slots. This represents how casters channel greater amounts of magic as they advance in level. For example, a 3rd-level cleric can cast the base version of the 2nd-circle ritual spell _prayer of healing_ to heal up to 2d8 + WIS modifier hit points.

When that same cleric gets access to 3rd-circle spell slots at 5th level, their _prayer of healing_ spell automatically becomes more powerful, allowing them to heal up to 3d8 + WIS modifier hit points.

For the purposes of setting DCs for effects like dispel magic, ritual spells that scale are always assumed to be cast at the highest circle the caster has access to or the spell's listed circle, whichever is higher.

Otherwise, ritual spells follow normal spellcasting rules.

## Casting In Armor

Because of the mental focus and precise gestures required for spellcasting, you must be proficient with any armor you are wearing to cast a spell. You are otherwise too distracted and hampered for spellcasting.

## Combining Magical Effects

The effects of different spells combine while the durations of those spells overlap. The effects of the same spell cast multiple times don't combine, however. Instead, the most potent effect, such as the highest bonus from multiple castings, applies while their durations overlap.

For example, if two wizards cast mage armor on the same target, that target gains the spell's benefit only once; they don't get multiple AC bonuses.

## Elements of a Spell

### Casting Time

Most spells require a single action to cast, but some can be accomplished in a shorter or longer span.

#### Bonus Action

A spell cast with a bonus action is fast. You must use a bonus action on your turn to cast the spell, provided you haven't already taken a bonus action this turn. If you use your bonus action to cast a spell from the 1st circle or higher on your turn, you can't also use your action to cast a spell from the 1st circle or higher during the same turn.

#### Reaction

Some spells can be cast as reactions. These spells take a fraction of a second to bring about and are cast in response to specific triggering events. If a spell can be cast as a reaction, the spell description specifies the trigger condition that must be met before the spell can be cast.

#### Longer Casting Times

Certain spells (particularly rituals) require more time to cast, often minutes or even hours. When you cast a spell with a casting time longer than a single action, bonus action, or reaction, you must spend your action each turn casting, and you must maintain concentration while you do so. If your concentration is broken, the spell fails, but the attempt doesn't expend a spell slot or material components unless the spell states otherwise. To try casting the spell again, you must start over.

### Range

The target of a spell must be within the spell's range. For a spell like magic missile, the target is a creature. For a spell like fireball, the target is a point in space where the ball of fire erupts.

Most spells have ranges expressed in feet. Some spells can target only a creature (including you) that you touch. Other spells, such as the shield spell, affect only you. These spells have a range of self.

Spells that appear in cones or lines that originate from you also have a range of self, indicating that the origin point must be you.

Once a spell is cast, its effects aren't limited by its range unless the spell's description says otherwise.

### Area Of Effect

Spells such as burning hands and cone of cold cover an area, allowing them to affect multiple creatures at once.

A spell's description specifies its area of effect, which typically has one of five different shapes: cone, cube, cylinder, line, or sphere. Every area of effect has a point of origin, a location from which the spell's energy erupts. The rules for each shape specify how you position its point of origin. Usually, it is a point in space that you choose within the spell's range, though some spells originate from a creature or an object.

A spell's effect expands in straight lines from its point of origin. If no unblocked straight line extends from the point of origin to a location within the area of effect, that location isn't included in the spell's area. To block one of these straight lines, an obstruction must provide total cover.

#### Cone

A cone extends in a direction you choose from its point of origin (typically the spellcaster). A cone's width at a given point along its length is equal to that point's distance from the point of origin. A cone's area of effect specifies its maximum length.

A cone's point of origin isn't included in the cone's area of effect unless you decide otherwise.

#### Cube

You select a cube's point of origin, which lies anywhere on one face of the cubic effect. The cube's size is expressed as the length of each side.

A cube's point of origin isn't included in the cube's area of effect unless you decide otherwise.

#### Cylinder

A cylinder's point of origin is the center of a circle of a particular radius, as given in the spell description. The circle with the point of origin must either be on the ground or at the height of the spell effect. The energy in a cylinder expands in straight lines from the point of origin to the perimeter of the circle, forming the base of the cylinder. The spell's effect then shoots up from the base or down from the top to a distance equal to the height of the cylinder.

A cylinder's point of origin is included in the cylinder's area of effect.

#### Line

A line extends from its point of origin in a straight path up to its length and covers an area defined by its width.

A line's point of origin isn't included in the line's area of effect unless you decide otherwise.

#### Sphere

You select a sphere's point of origin, and the sphere extends outward from that point. The sphere's size is expressed as a radius in feet that extends from the point.

A sphere's point of origin is included in the sphere's area of effect.

### Components

A spell's components are the physical requirements you must provide to cast it. Each spell's description indicates whether it requires verbal (V), somatic (S), or material (M) components. If you can't provide one or more of a spell's components, you can't cast the spell.

#### Verbal (V)

Most spells require the chanting of mystic words. The combination of sounds, with specific pitch and resonance, sets the magic in motion. Thus, a character who is gagged, affected by the deafened condition, or in an area of silence, such as one created by the silence spell, can't cast a spell with a verbal component.

#### Somatic (S)

Spellcasting might include a forceful gesticulation or an intricate set of motions. If a spell requires a somatic component, the caster must have free use of at least one hand to perform these gestures. Note this means spells with somatic components typically can't be cast while holding a weapon in one hand and a shield in the other.

#### Material (M)

Casting some spells requires specific objects detailed in parentheses in the component entry. A character can typically use a component pouch or a spellcasting focus in place of material components specified for a spell. However, if a specific cost is indicated for a material component, a pouch or focus can't substitute for it. The character must have that specific component to cast the spell. If a spell specifies a cost for a material component, the component provided must be worth at least the listed amount, but a suitable component worth more than the specified amount can be used.

If a spell states that a material component is consumed by the spell, the caster must provide this component for each casting of the spell.

A spellcaster must have a hand free to access a spell's material components-or to hold a spellcasting focus- but it can be the same hand that they use to perform somatic components.

### Duration

#### Instantaneous

Many spells are instantaneous. The spell harms, heals, creates, or alters a creature or an object in a way that can't be dispelled, because its magic exists only for an instant. Some spells list an instantaneous duration but create longlasting effects described in detail in the spell description.

#### Concentration

Some spells require concentration to keep the magic active. If you lose concentration on a spell that requires it, the spell ends.

If a spell must be maintained with concentration, it will say so in its duration entry, and it specifies how long you can concentrate on it. You can end concentration at any time (no action required).

Normal activity, such as moving and attacking, doesn't interfere with concentration. The following factors can break concentration:

- **Casting another spell that requires concentration.** You immediately lose concentration on the first spell if you cast another spell that requires concentration. You can't concentrate on two spells at once.
- **Taking damage.** When you take damage while you are concentrating on a spell, you must make a CON save to maintain your concentration. The DC of this save equals 10 or half the damage you take, whichever number is higher. If you take damage from multiple sources, such as an arrow and a dragon's breath, make a separate save for each source of damage.
- **Being incapacitated or killed.** You lose concentration on a spell if you are incapacitated or if you die.

The GM might also decide that certain environmental phenomena, such as a wave crashing over you while you're on a storm-tossed ship, require you to succeed on a CON save to maintain concentration on a spell.

Most spells that require attack rolls involve ranged attacks. Remember that you have disadvantage on a ranged attack roll if you are within 5 feet of a hostile creature that can see you and isn't incapacitated.

### Description

These spells are available to casters who draw power from the Arcane source.

#### Target

A typical spell requires you to pick one or more targets to be affected by the spell's magic. A spell tells you whether the spell targets creatures, objects, or a point of origin for an area of effect.

Unless a spell has a perceptible effect, a creature might not know it was targeted by a spell at all. An effect like crackling lightning is obvious, but a more subtle effect, such as an attempt to read a creature's thoughts, typically goes unnoticed unless a spell says otherwise.

##### A Clear Path To The Target

To target something, you must have a clear path to it, so it can't be behind total cover.

If you place an area of effect at a point that you can't see and an obstruction, such as a wall, is between you and the point, the point of origin appears on the side of that obstruction nearest to you.

##### Targeting Yourself

If a spell targets a creature of your choice, you can choose yourself unless the spell says otherwise. For example, some spells specify that the target must be hostile to you or specifically a creature other than you. If you are in the area of effect of a spell you cast, you can target yourself.

#### Spell Saves

Many spells specify that a target can make a save to avoid some or all of a spell's effects. The spell specifies the ability the target uses for the save, such as DEX or WIS, and what happens on a success or failure.

The DC to resist a spell equals 8 + your spellcasting ability modifier + your PB + any special modifiers. Your spellcasting class typically dictates which spellcasting ability modifier you use.

#### Spell Attack Rolls

Some spells require the caster to make an attack roll to determine whether the spell effect hits the intended target. Your attack bonus for a spell attack equals your spellcasting ability modifier + your PB. Your spellcasting class typically dictates which spellcasting ability modifier you use.

## Spell Lists

### Arcane Spell List

#### Cantrips

_Acid Splash_ (Conjuration)
_Dancing Lights_ (Evocation)
_Fire Bolt_ (Evocation)
_Grave Touch_ (Necromancy)
_Light_ (Evocation)
_Mage Hand_ (Conjuration)
_Mending_ (Transmutation)
_Message_ (Enchantment)
_Minor Illusion_ (Illusion)
_Poison Spray_ (Conjuration)
_Prestidigitation_ (Transmutation)
_Ray of Frost_ (Evocation)
_Shocking Grasp_ (Evocation)
_Vicious Mockery_ (Enchantment)

#### 1st Circle

_Burning Hands_ (Evocation)
_Charm_ (Enchantment)
_Color Spray_ (Illusion)
_Comprehend Languages_ (Divination)
_Detect Magic_ (Divination)
_Disguise Self_ (Illusion)
_Expeditious Retreat_ (Transmutation)
_False Life_ (Necromancy)
_Feather Fall_ (Transmutation)
_Floating Disk_ (Conjuration)
_Fog Cloud_ (Conjuration)
_Grease_ (Conjuration)
_Hideous Laughter_ (Enchantment)
_Longstrider_ (Transmutation)
_Mage Armor_ (Abjuration)
_Magic Missile_ (Evocation)
_Shield_ (Abjuration)
_Silent Image_ (Illusion)
_Sleep_ (Enchantment)
_Thunderwave_ (Evocation)

#### 2nd Circle

_Acid Arrow_ (Evocation)
_Blindness/Deafness_ (Necromancy)
_Blur_ (Illusion)
_Continual Flame_ (Evocation)
_Darkness_ (Evocation)
_Darkvision_ (Transmutation)
_Detect Thoughts_ (Divination)
_Elemental Blade_ (Evocation)
_Enlarge/Reduce_ (Transmutation)
_Flaming Sphere_ (Evocation)
_Gust of Wind_ (Evocation)
_Heat Metal_ (Transmutation)
_Hold_ (Enchantment)
_Invisibility_ (Illusion)
_Knock_ (Transmutation)
_Levitate_ (Transmutation)
_Magic Weapon_ (Transmutation)
_Mirror Image_ (Illusion)
_Misty Step_ (Conjuration)
_Ray of Enfeeblement_ (Necromancy)
_Rope Trick_ (Conjuration)
_Scorching Ray_ (Evocation)
_See Invisibility_ (Divination)
_Shatter_ (Evocation)
_Spider Climb_ (Transmutation)
_Suggestion_ (Enchantment)
_Web_ (Conjuration)

#### 3rd Circle

_Blink_ (Transmutation)
_Counterspell_ (Abjuration)
_Dispel Magic_ (Abjuration)
_Fear_ (Illusion)
_Fireball_ (Evocation)
_Fly_ (Transmutation)
_Gaseous Form_ (Transmutation)
_Haste_ (Transmutation)
_Hypnotic Pattern_ (Illusion)
_Lightning Bolt_ (Evocation)
_Major Image_ (Illusion)
_Nondetection_ (Abjuration)
_Protection from Energy_ (Abjuration)
_Sending_ (Enchantment)
_Slow_ (Transmutation)
_Stinking Cloud_ (Conjuration)
_Tongues_ (Divination)
_Vampiric Touch_ (Necromancy)
_Water Breathing_ (Transmutation)
_Wind Wall_ (Evocation)

#### 4th Circle

_Arcane Eye_ (Divination)
_Banishment_ (Abjuration)
_Compulsion_ (Enchantment)
_Confusion_ (Enchantment)
_Conjure Minor Elementals_ (Conjuration)
_Dimension Door_ (Conjuration)
_Elemental Shield_ (Evocation)
_Freedom of Movement_ (Abjuration)
_Greater Invisibility_ (Illusion)
_Ice Storm_ (Evocation)
_Phantasmal Killer_ (Illusion)
_Polymorph_ (Transmutation)
_Resilient Sphere_ (Evocation)
_Wall of Fire_ (Evocation)

#### 5th Circle

_Animate Objects_ (Transmutation)
_Arcane Hand_ (Evocation)
_Cloudkill_ (Conjuration)
_Cone of Cold_ (Evocation)
_Conjure Elemental_ (Conjuration)
_Dominate_ (Enchantment)
_Greater Hold_ (Enchantment)
_Legend Lore_ (Divination)
_Mislead_ (Illusion)
_Modify Memory_ (Enchantment)
_Passwall_ (Transmutation)
_Seeming_ (Illusion)
_Telekinesis_ (Transmutation)
_Telepathic Bond_ (Divination)
_Wall of Force_ (Evocation)
_Wall of Stone_ (Evocation)

#### 6th Circle

_Blade Barrier_ (Evocation)
_Chain Lightning_ (Evocation)
_Circle of Death_ (Necromancy)
_Disintegrate_ (Transmutation)
_Freezing Sphere_ (Evocation)
_Globe of Invulnerability_ (Abjuration)
_Irresistible Dance_ (Enchantment)
_Mass Suggestion_ (Enchantment)
_Programmed Illusion_ (Illusion)
_True Seeing_ (Divination)
_Wall of Ice_ (Evocation)

#### 7th Circle

_Arcane Sword_ (Evocation)
_Delayed Blast Fireball_ (Evocation)
_Etherealness_ (Transmutation)
_Finger of Death_ (Necromancy)
_Fire Storm_ (Evocation)
_Forcecage_ (Evocation)
_Prismatic Spray_ (Evocation)
_Project Image_ (Illusion)
_Reverse Gravity_ (Transmutation)
_Sequester_ (Transmutation)
_Teleport_ (Conjuration)

#### 8th Circle

_Antimagic Field_ (Abjuration)
_Demiplane_ (Conjuration)
_Feeblemind_ (Enchantment)
_Glibness_ (Transmutation)
_Greater Dominate_ (Enchantment)
_Incendiary Cloud_ (Conjuration)
_Maze_ (Conjuration)
_Mind Blank_ (Abjuration)
_Power Word Stun_ (Enchantment)

#### 9th Circle

_Gate_ (Conjuration)
_Meteor Swarm_ (Evocation)
_Power Word Kill_ (Enchantment)
_Prismatic Wall_ (Abjuration)
_Time Stop_ (Transmutation)
_True Polymorph_ (Transmutation)
_Weird_ (Illusion)
_Wish_ (Conjuration)

### Arcane Ritual List

These rituals are available to casters who draw power from the Arcane source.

#### 1st Circle

_Alarm_ (Abjuration)
_Create Familiar_ (Transmutation)
_Identify_ (Divination)
_Illusory Script_ (Illusion)
_Unseen Servant_ (Conjuration)

#### 2nd Circle

_Arcane Lock_ (Abjuration)
_Arcanist's Magic Aura_ (Illusion)
_Locate_ (Divination)
_Magic Mouth_ (Illusion)

#### 3rd Circle

_Animate Dead_ (Necromancy)
_Clairvoyance_ (Divination)
_Glyph of Warding_ (Abjuration)
_Magic Circle_ (Abjuration)
_Tiny Hut_ (Evocation)

#### 4th Circle

_Fabricate_ (Transmutation)
_Hallucinatory Terrain_ (Illusion)
_Private Sanctum_ (Abjuration)
_Secret Chest_ (Abjuration)

#### 5th Circle

_Contact Other Plane_ (Divination)
_Creation_ (Illusion)
_Dream_ (Illusion)
_Geas_ (Enchantment)
_Planar Binding_ (Abjuration)
_Scrying_ (Divination)
_Teleportation Circle_ (Conjuration)

#### 6th Circle

_Contingency_ (Evocation)
_Create Undead_ (Necromancy)
_Guards and Wards_ (Abjuration)
_Instant Summons_ (Conjuration)

#### 7th Circle

_Magnificent Mansion_ (Conjuration)
_Mirage Arcane_ (Illusion)
_Simulacrum_ (Illusion)
_Symbol_ (Abjuration)

#### 8th Circle

_Antipathy/Sympathy_ (Enchantment)
_Clone_ (Necromancy)

#### 9th Circle

_Astral Projection_ (Necromancy)
_Foresight_ (Divination)
_Imprisonment_ (Abjuration)

### Divine Spell List

These spells are available to casters who draw power from the Divine source.

#### Cantrips

_Guidance_ (Divination)
_Light_ (Evocation)
_Mending_ (Transmutation)
_Resistance_ (Abjuration)
_Sacred Flame_ (Evocation)
_Spare the Dying_ (Necromancy)
_Thaumaturgy_ (Transmutation)

#### 1st Circle

_Bane_ (Enchantment)
_Bless_ (Enchantment)
_Command_ (Enchantment)
_Cure Wounds_ (Necromancy)
_Detect Evil and Good_ (Divination)
_Divine Favor_ (Evocation)
_Guiding Bolt_ (Evocation)
_Healing Word_ (Necromancy)
_Heroism_ (Enchantment)
_Inflict Wounds_ (Necromancy)
Protection from Evil and Good
(Abjuration)
_Sanctuary_ (Abjuration)
_Shield of Faith_ (Abjuration)

#### 2nd Circle

_Aid_ (Abjuration)
_Blindness/Deafness_ (Necromancy)
_Branding Smite_ (Evocation)
_Calm Emotions_ (Enchantment)
_Gentle Repose_ (Necromancy)
_Hold_ (Enchantment)
_Protection from Poison_ (Abjuration)
_Ray of Enfeeblement_ (Necromancy)
_Restoration_ (Abjuration)
_See Invisibility_ (Divination)
_Silence_ (Illusion)
_Spiritual Weapon_ (Evocation)
_Suggestion_ (Enchantment)
_Warding Bond_ (Abjuration)
_Zone of Truth_ (Enchantment)

#### 3rd Circle

_Beacon of Hope_ (Abjuration)
_Bestow Curse_ (Necromancy)
_Create Food and Water_ (Conjuration)
_Daylight_ (Evocation)
_Dispel Magic_ (Abjuration)
_Mass Healing Word_ (Necromancy)
_Protection from Energy_ (Abjuration)
_Remove Curse_ (Abjuration)
_Revivify_ (Necromancy)
_Sending_ (Enchantment)
_Spirit Guardians_ (Conjuration)
_Tongues_ (Divination)
_Vampiric Touch_ (Necromancy)

#### 4th Circle

_Banishment_ (Abjuration)
_Blight_ (Necromancy)
_Compulsion_ (Enchantment)
_Confusion_ (Enchantment)
_Control Water_ (Transmutation)
_Death Ward_ (Abjuration)
_Faithful Hound_ (Conjuration)
_Freedom of Movement_ (Abjuration)
_Guardian of Faith_ (Conjuration)

#### 5th Circle

_Antilife Shell_ (Abjuration)
_Contagion_ (Necromancy)
_Dispel Evil and Good_ (Abjuration)
_Flame Strike_ (Evocation)
_Greater Hold_ (Enchantment)
_Greater Restoration_ (Abjuration)
_Legend Lore_ (Divination)
_Mass Cure Wounds_ (Necromancy)

#### 6th Circle

_Circle of Death_ (Necromancy)
_Flesh to Stone_ (Transmutation)
_Harm_ (Necromancy)
_Heal_ (Necromancy)
_Sunbeam_ (Evocation)
_True Seeing_ (Divination)
_Word of Recall_ (Conjuration)

#### 7th Circle

_Divine Word_ (Evocation)
_Finger of Death_ (Necromancy)
_Plane Shift_ (Conjuration)
_Sequester_ (Transmutation)

#### 8th Circle

_Glibness_ (Transmutation)
_Holy Aura_ (Abjuration)
_Power Word Stun_ (Enchantment)
_Sunburst_ (Evocation)

#### 9th Circle

_Mass Heal_ (Necromancy)
_Power Word Kill_ (Enchantment)
_Power Word Recover_ (Enchantment)
_Storm of Vengeance_ (Conjuration)

### Divine Ritual List

These rituals are available to casters who draw power from the Divine source.

#### 1st Circle

_Detect Poison and Disease_ (Divination)
_Purify Food and Drink_ (Transmutation)

#### 2nd Circle

_Augury_ (Divination)
_Find Steed_ (Conjuration)
_Locate_ (Divination)
_Prayer of Healing_ (Evocation)

#### 3rd Circle

_Animate Dead_ (Necromancy)
_Clairvoyance_ (Divination)
_Magic Circle_ (Abjuration)
_Speak with Dead_ (Necromancy)

#### 4th Circle

_Divination_ (Divination)
_Private Sanctum_ (Abjuration)

#### 5th Circle

_Geas_ (Enchantment)
_Hallow_ (Abjuration)
_Planar Binding_ (Abjuration)
_Raise Dead_ (Necromancy)
_Scrying_ (Divination)

#### 6th Circle

_Create Undead_ (Necromancy)
_Forbiddance_ (Abjuration)
_Heroes' Feast_ (Conjuration)
_Planar Ally_ (Conjuration)

#### 7th Circle

_Regenerate_ (Transmutation)
_Resurrection_ (Necromancy)

#### 8th Circle

_Antipathy/Sympathy_ (Enchantment)
_Control Weather_ (Transmutation)

#### 9th Circle

_Foresight_ (Divination)
_True Resurrection_ (Necromancy)

### Primordial Spell List

These spells are available to casters who draw power from the Primordial source.

#### Cantrips

_Dancing Lights_ (Evocation)
_Druidcraft_ (Transmutation)
_Poison Spray_ (Conjuration)
_Produce Flame_ (Conjuration)
_Resistance_ (Abjuration)
_Shillelagh_ (Transmutation)
_Shocking Grasp_ (Evocation)

#### 1st Circle

_Animal Friendship_ (Enchantment)
_Burning Hands_ (Evocation)
_Create or Destroy Water_ (Transmutation)
_Cure Wounds_ (Necromancy)
_Entangle_ (Conjuration)
_Expeditious Retreat_ (Transmutation)
_Feather Fall_ (Transmutation)
_Fog Cloud_ (Conjuration)
_Goodberry_ (Transmutation)
_Longstrider_ (Transmutation)
_Speak with Animals_ (Divination)
_Thunderwave_ (Evocation)

#### 2nd Circle

_Alter Self_ (Transmutation)
_Barkskin_ (Transmutation)
_Darkvision_ (Transmutation)
_Enhance Ability_ (Transmutation)
_Enlarge/Reduce_ (Transmutation)
_Flaming Sphere_ (Evocation)
_Gust of Wind_ (Evocation)
_Heat Metal_ (Transmutation)
_Moonbeam_ (Evocation)
_Pass Without Trace_ (Abjuration)
_Protection from Poison_ (Abjuration)
_Restoration_ (Abjuration)
_Spider Climb_ (Transmutation)
_Spike Growth_ (Transmutation)

#### 3rd Circle

_Call Lightning_ (Conjuration)
_Conjure Animals_ (Conjuration)
_Create Food and Water_ (Conjuration)
_Daylight_ (Evocation)
_Fly_ (Transmutation)
_Gaseous Form_ (Transmutation)
_Meld into Stone_ (Transmutation)
_Plant Growth_ (Transmutation)
_Protection from Energy_ (Abjuration)
_Sleet Storm_ (Conjuration)
_Speak with Plants_ (Transmutation)
_Water Breathing_ (Transmutation)
_Wind Wall_ (Evocation)

#### 4th Circle

_Blight_ (Necromancy)
_Conjure Woodland Beings_ (Conjuration)
_Control Water_ (Transmutation)
_Giant Insect_ (Transmutation)
_Ice Storm_ (Evocation)
_Polymorph_ (Transmutation)
_Stone Shape_ (Transmutation)
_Stoneskin_ (Abjuration)
_Wall of Fire_ (Evocation)

#### 5th Circle

_Antilife Shell_ (Abjuration)
_Cone of Cold_ (Evocation)
_Contagion_ (Necromancy)
_Greater Restoration_ (Abjuration)
_Insect Plague_ (Conjuration)
_Mass Cure Wounds_ (Necromancy)
_Tree Stride_ (Conjuration)
_Wall of Stone_ (Evocation)

#### 6th Circle

_Heal_ (Necromancy)
_Move Earth_ (Transmutation)
_Sunbeam_ (Evocation)
_Transport via Plants_ (Conjuration)
_Wall of Ice_ (Evocation)
_Wall of Thorns_ (Evocation)
_Wind Walk_ (Transmutation)

#### 7th Circle

_Fire Storm_ (Evocation)
_Four Winds_ (Transmutation)
_Reverse Gravity_ (Transmutation)
_Transmogrification_ (Transmutation)

#### 8th Circle

_Animal Shapes_ (Transmutation)
_Earthquake_ (Evocation)
_Sunburst_ (Evocation)

#### 9th Circle

_Mass Heal_ (Necromancy)
_Meteor Swarm_ (Evocation)
_Shapechange_ (Transmutation)
_Storm of Vengeance_ (Conjuration)
_True Polymorph_ (Transmutation)

### Primordial Ritual List

These rituals are available to casters who draw power from the Primordial source.

#### 1st Circle

_Detect Poison and Disease_ (Divination)
_Purify Food and Drink_ (Transmutation)

#### 2nd Circle

_Animal Messenger_ (Enchantment)
_Find Steed_ (Conjuration)
_Locate_ (Divination)

#### 3rd Circle

_Water Walk_ (Transmutation)

#### 4th Circle

_Song of the Forest_ (Transmutation)

#### 5th Circle

_Awaken_ (Transmutation)
_Commune with Nature_ (Divination)
_Reincarnate_ (Transmutation)

#### 6th Circle

_Find the Path_ (Divination)
_Heroes' Feast_ (Conjuration)

#### 7th Circle

_Oculus Blossoms_ (Divination)
_Regenerate_ (Transmutation)

#### 8th Circle

_Antipathy/Sympathy_ (Enchantment)
_Control Weather_ (Transmutation)

#### 9th Circle

_Metamorphosis_ (Transmutation)

### Wyrd Spell List

These spells are available to casters who draw power from the Wyrd source.

#### Cantrips

_Dancing Lights_ (Evocation)
_Grave Touch_ (Necromancy)
_Guidance_ (Divination)
_Mage Hand_ (Conjuration)
_Message_ (Enchantment)
_Minor Illusion_ (Illusion)
_Thaumaturgy_ (Transmutation)
_Vicious Mockery_ (Enchantment)

#### 1st Circle

_Bane_ (Enchantment)
_Charm_ (Enchantment)
_Command_ (Enchantment)
_Detect Evil and Good_ (Divination)
_Detect Magic_ (Divination)
_Disguise Self_ (Illusion)
_Faerie Fire_ (Evocation)
_Guiding Bolt_ (Evocation)
_Hellish Rebuke_ (Evocation)
_Hideous Laughter_ (Enchantment)
_Inflict Wounds_ (Necromancy)
_Protection from Evil and Good_ (Abjuration)
_Sleep_ (Enchantment)

#### 2nd Circle

_Blindness/Deafness_ (Necromancy)
_Darkness_ (Evocation)
_Detect Thoughts_ (Divination)
_Enthrall_ (Enchantment)
_Hold_ (Enchantment)
_Invisibility_ (Illusion)
_Magic Weapon_ (Transmutation)
_Mirror Image_ (Illusion)
_Misty Step_ (Conjuration)
_Ray of Enfeeblement_ (Necromancy)
_Rope Trick_ (Conjuration)
_See Invisibility_ (Divination)
_Silence_ (Illusion)
_Spiritual Weapon_ (Evocation)
_Suggestion_ (Enchantment)

#### 3rd Circle

_Bestow Curse_ (Necromancy)
_Blink_ (Transmutation)
_Conjure Animals_ (Conjuration)
_Fear_ (Illusion)
_Hypnotic Pattern_ (Illusion)
_Major Image_ (Illusion)
_Nondetection_ (Abjuration)
_Remove Curse_ (Abjuration)
_Revivify_ (Necromancy)
_Sending_ (Enchantment)
_Spirit Guardians_ (Conjuration)
_Stinking Cloud_ (Conjuration)
_Vampiric Touch_ (Necromancy)

#### 4th Circle

_Banishment_ (Abjuration)
_Black Tentacles_ (Conjuration)
_Compulsion_ (Enchantment)
_Confusion_ (Enchantment)
_Conjure Minor Elementals_ (Conjuration)
_Dimension Door_ (Conjuration)
_Faithful Hound_ (Conjuration)
_Greater Invisibility_ (Illusion)
_Mass Faerie Fire_ (Evocation)
_Phantasmal Killer_ (Illusion)

#### 5th Circle

_Cloudkill_ (Conjuration)
_Conjure Elemental_ (Conjuration)
_Dispel Evil and Good_ (Abjuration)
_Dominate_ (Enchantment)
_Greater Hold_ (Enchantment)
_Seeming_ (Illusion)
_Telekinesis_ (Transmutation)
_Telepathic Bond_ (Divination)
_Wall of Force_ (Evocation)

#### 6th Circle

_Circle of Death_ (Necromancy)
_Disintegrate_ (Transmutation)
_Eyebite_ (Transmutation)
_Harm_ (Necromancy)
_Irresistible Dance_ (Enchantment)
_Mass Suggestion_ (Enchantment)
_True Seeing_ (Divination)

#### 7th Circle

_Etherealness_ (Transmutation)
_Finger of Death_ (Necromancy)
_Forcecage_ (Evocation)
_Plane Shift_ (Conjuration)

#### 8th Circle

_Demiplane_ (Conjuration)
_Greater Dominate_ (Enchantment)
_Maze_ (Conjuration)
_Power Word Stun_ (Enchantment)

#### 9th Circle

_Gate_ (Conjuration)
_Power Word Kill_ (Enchantment)
_Weird_ (Illusion)
_Wish_ (Conjuration)

### Wyrd Ritual List

These rituals are available to casters who draw power from the Wyrd source.

#### 1st Circle

_Find Familiar_ (Conjuration)
_Illusory Script_ (Illusion)
_Unseen Servant_ (Conjuration)

#### 2nd Circle

_Augury_ (Divination)
_Locate_ (Divination)
_Magic Mouth_ (Illusion)

#### 3rd Circle

_Clairvoyance_ (Divination)
_Magic Circle_ (Abjuration)
_Phantom Steed_ (Illusion)
_Speak with Dead_ (Necromancy)

#### 4th Circle

_Hallucinatory Terrain_ (Illusion)
_Secret Chest_ (Abjuration)

#### 5th Circle

_Contact Other Plane_ (Divination)
_Dream_ (Illusion)
_Geas_ (Enchantment)
_Planar Binding_ (Abjuration)

#### 6th Circle

_Magic Jar_ (Necromancy)
_Planar Ally_ (Conjuration)

#### 7th Circle

_Magnificent Mansion_ (Conjuration)
_Mirage Arcane_ (Illusion)

#### 8th Circle

_Antipathy/Sympathy_ (Enchantment)

#### 9th Circle

_Astral Projection_ (Necromancy)
_Imprisonment_ (Abjuration)

## Spell Descriptions

### A

#### Acid Arrow

_2nd-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V, S, M (powdered rhubarb leaf and an adder's stomach)
**Duration:** Instantaneous

A shimmering green arrow streaks toward a target within range and bursts in a spray of acid. Make a ranged spell attack against the target. On a hit, the target takes 4d4 acid damage immediately and 2d4 acid damage at the end of its next turn. On a miss, the arrow splashes the target with acid for half as much of the initial damage and no damage at the end of its next turn.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, the damage (both initial and later) increases by 1d4 for each slot above 2nd.

#### Acid Splash

_Arcane Cantrip (Conjuration)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

Choose one creature within range, or choose two creatures within range that are within 5 feet of each other. A target must succeed on a DEX save or take 1d6 acid damage.

This spell's damage increases by 1d6 when you reach 5th level (2d6), 11th level (3d6), and 17th level (4d6).

#### Aid

_2nd-Circle Divine (Abjuration)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a tiny strip of white cloth)
**Duration:** 8 hours

Your spell bolsters your allies with toughness and resolve.

Choose up to three creatures within range. Each target's hit point maximum and current hit points increase by 5 for the duration.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, a target's hit points increase by an additional 5 for each slot above 2nd.

#### Alter Self

_2nd-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 1 hour

You magically alter your form. When you cast the spell, choose one of the following options, the effects of which last for the duration of the spell. While the spell lasts, you can end one option as an action to gain the benefits of a different one.

Aquatic Adaptation. You adapt your body to an aquatic environment, sprouting gills and growing webbing between your fingers. You can breathe underwater and gain a swimming speed equal to your walking speed.

Change Appearance. You transform your appearance.

You decide what you look like, including your height, weight, facial features, the sound of your voice, hair length, coloration, and distinguishing characteristics, if any. You can make yourself appear as a member of another lineage, though none of your statistics change. You can't appear as a creature of a different size than you, and your basic shape stays the same; if you're bipedal, you can't use this spell to become quadrupedal, for instance. At any time for the duration of the spell, you can use your action to change your appearance in this way again.

Natural Weapons. You grow a natural weapon of your choice, such as claws, fangs, spines, or horns. Your unarmed strikes deal 1d6 bludgeoning, piercing, or slashing damage as appropriate to the natural weapon you chose, and you are proficient with your unarmed strikes.

Finally, the natural weapon is magic, and you have a +1 bonus to attack and damage rolls you make using it.

#### Animal Friendship

_1st-Circle Primordial (Enchantment)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a morsel of food)
**Duration:** 24 hours

This spell lets you convince an animal that you mean it no harm. Choose a Beast or creature with the Animal tag that you can see within range. It must see and hear you. If the creature's INT is 4 (-3) or higher, the spell fails. Otherwise, the creature must succeed on a WIS save or be charmed by you for the spell's duration. If you or one of your companions harms the target, the spell ends.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, you can affect one additional creature for each slot above 1st.

#### Animal Shapes

_8th-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S
**Duration:** Concentration, up to 24 hours

Your magic turns others into animals. Choose any number of willing creatures that you can see within range. You transform each target into the form of a Large or smaller Beast or creature with the Animal tag with a CR 4 or lower.

On subsequent turns, you can use your action to transform affected creatures into new forms.

The transformation lasts for the duration for each target or until the target drops to 0 HP or dies. You can choose a different form for each target. A target's game statistics are replaced by the statistics of the chosen form, though the target retains its personality and INT, WIS, and CHA scores. The target assumes the hit points of its new form, and when it reverts to its normal form, it returns to the number of hit points it had before it transformed. If it reverts as a result of dropping to 0 HP, any excess damage carries over to its normal form. As long as the excess damage doesn't reduce the creature's normal form to 0 HP, it isn't knocked unconscious. The creature is limited in the actions it can perform by the nature of its new form, and it can't speak or cast spells.

The target's gear melds into the new form. The target can't activate, wield, or otherwise benefit from any of its equipment.

#### Animate Objects

_5th-Circle Arcane (Transmutation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

Objects come to life at your command. Choose up to ten nonmagical objects within range that aren't being worn or carried. Medium targets count as two objects, Large targets count as four objects, and Huge targets count as eight objects. You can't animate any object larger than Huge. Each target animates and becomes a creature under your control until the spell ends or until reduced to 0 HP.

As a bonus action, you can mentally command any creature you made with this spell if the creature is within 500 feet of you (if you control multiple creatures, you can command any or all of them at the same time, issuing the same command to each one). You decide what action the creature will take and where it will move during its next turn, or you can issue a general command, such as to guard a particular chamber or corridor. If you issue no commands, the creature only defends itself against hostile creatures. Once given an order, the creature continues to follow it until its task is complete.

An animated object is a Construct with AC, hit points, attacks, STR, and DEX determined by its size. Its CON is 10 (+0), its INT and WIS are 3 (-4), and its CHA is 1 (-5). Its speed is 30 feet; if the object lacks legs or other appendages it can use for locomotion, it instead has a flying speed of 30 feet and can hover. If the object is securely attached to a surface or a larger object, such as a chain bolted to a wall, its speed is 0. It has tremorsense with a radius of 30 feet and is blind beyond that radius. When the animated object drops to 0 HP, it reverts to its original object form, and any remaining damage carries over to its original object form.

If you command an object to attack, it can make a single melee attack against a creature within 5 feet of it. It makes a Slam attack with an attack bonus and bludgeoning damage determined by its size. The GM might rule that a specific object inflicts slashing or piercing damage based on its form.

_At Higher Circles._ If you cast this spell using a spell slot of 6th circle or higher, you can animate two additional objects for each slot above 5th.

##### Table: Animated Object Statistics

| SIZE   | EXAMPLE OBJECT                          |  HP |  AC |     STR |     DEX | ATTACK                     |
| ------ | --------------------------------------- | --: | --: | ------: | ------: | -------------------------- |
| Tiny   | Inkpot, ladle, throwing dart            |  20 |  18 |  4 (-3) | 18 (+4) | +8 to hit, 1d4 + 4 damage  |
| Small  | Book, chair, stew pot                   |  25 |  16 |  6 (-2) | 14 (+2) | +6 to hit, 1d8 + 2 damage  |
| Medium | Handcart, saddle, table                 |  40 |  13 | 10 (+0) | 12 (+1) | +5 to hit, 2d6 + 1 damage  |
| Large  | Armoire, memorial statue, kiln          |  50 |  10 | 14 (+2) | 10 (+0) | +6 to hit, 2d10 + 2 damage |
| Huge   | Carriage, dinosaur fossil, granary silo |  80 |  10 | 18 (+4) |  6 (-2) | +8 to hit, d12 + 4 damage  |

#### Antilife Shell

_5th-Circle Divine and Primordial (Abjuration)_

**Casting Time:** 1 action
**Range:** Self (10-foot radius)
**Components:** V, S
**Duration:** Concentration, up to 1 hour

A shimmering barrier extends out from you in a 10-foot radius and moves with you. It remains centered on you, hedging out creatures other than Undead and Constructs. The barrier lasts for the duration.

The barrier prevents an affected creature from passing or reaching through. An affected creature can cast spells or make attacks with ranged or reach weapons through the barrier.

If you move so that an affected creature is forced to pass through the barrier, the spell ends.

#### Antimagic Field

_8th-Circle Arcane (Abjuration)_

**Casting Time:** 1 action
**Range:** Self (10-foot-radius sphere)
**Components:** V, S, M (powdered iron or iron filings)
**Duration:** Concentration, up to 1 hour

A 10-foot-radius invisible sphere of antimagic surrounds you. This area is divorced from the magical energy that suffuses the multiverse. Within the sphere, spells can't be cast, summoned creatures disappear, and even magic items become mundane. Until the spell ends, the sphere moves with you, centered on you.

Spells and other magical effects, except those created by an artifact or a deity, are suppressed in the sphere and can't protrude into it. A slot expended to cast a suppressed spell is consumed. While an effect is suppressed, it doesn't function, but the time it spends suppressed counts against its duration.

**Targeted Effects.** Spells and other magical effects, such as magic missile and charm, that target a creature or an object in the sphere have no effect on that target.

**Areas of Magic.** The area of another spell or magical effect, such as fireball, can't extend into the sphere. If the sphere overlaps an area of magic, the part of the area that is covered by the sphere is suppressed. For example, the flames created by a wall of fire are suppressed within the sphere, creating a gap in the wall if the overlap is large enough.

**Spells.** Any active spell or other magical effect on a creature or an object in the sphere is suppressed while the creature or object is in it.

**Magic Items.** The properties and powers of magic items are suppressed in the sphere. For example, a +1 longsword in the sphere functions as a nonmagical longsword. A magic weapon's properties and powers are suppressed if it is used against a target in the sphere or wielded by an attacker in the sphere. If a magic weapon or a piece of magic ammunition fully leaves the sphere (for example, if you fire a magic arrow or throw a magic spear at a target outside the sphere), the magic of the item ceases to be suppressed as soon as it exits.

**Magical Travel.** Teleportation and planar travel fail to work in the sphere, whether the sphere is the destination or the departure point for such magical travel. A portal to another location, world, or plane of existence, as well as an opening to an extradimensional space such as that created by the rope trick spell, temporarily closes while in the sphere.

**Creatures and Objects.** A creature or object summoned or created by magic temporarily winks out of existence in the sphere. Such a creature instantly reappears once the space the creature occupied is no longer within the sphere.

**Dispel Magic.** Spells and magical effects such as dispel magic have no effect on the sphere. Likewise, the spheres created by different antimagic field spells don't nullify each other.

#### Arcane Eye

_4th-Circle Arcane (Divination)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a bit of bat fur)
**Duration:** Concentration, up to 1 hour

You create an invisible, magical eye within range that hovers in the air for the duration. You mentally receive visual information from the eye, which has normal vision and darkvision to a range of 30 feet. The eye can look in every direction.

As an action, you can move the eye up to 30 feet in any direction. There is no limit to how far away from you the eye can move, but it can't enter another plane of existence.

A solid barrier blocks the eye's movement, but the eye can pass through an opening as small as 1 inch in diameter.

#### Arcane Hand

_5th-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (an eggshell and a snakeskin glove)
**Duration:** Concentration, up to 1 minute

You create a Large hand of shimmering, translucent force in an unoccupied space that you can see within range. The hand lasts for the spell's duration, and it moves at your command, mimicking the movements of your own hand.

The hand is an object that has AC 20 and hit points equal to your hit point maximum. If it drops to 0 HP, the spell ends. It has a STR of 26 (+8) and a DEX of 10 (+0). Creatures can occupy the same space as the hand.

When you cast the spell and as a bonus action on your subsequent turns, you can move the hand up to 60 feet and then cause one of the following effects with it.

**Clenched Fist.** The hand strikes one creature or object within 5 feet of it. Make a melee spell attack for the hand using your own spell attack modifier. On a hit, the target takes 4d8 force damage.

**Forceful Hand.** The hand attempts to push a creature within 5 feet of it in a direction you choose. Make a check with the hand's STR contested by the STR (Athletics) check of the target. If the target is Medium or smaller, you have advantage on the check. If you succeed, the hand pushes the target up to 5 feet plus a number of feet equal to five times your spellcasting ability modifier. The hand moves with the target to remain within 5 feet of it.

**Grasping Hand.** The hand attempts to grapple a Huge or smaller creature within 5 feet of it. You use the hand's STR to resolve the grapple. If the target is Medium or smaller, you have advantage on the check. While the hand is grappling the target, you can use a bonus action to have the hand crush it. When you do so, the target takes bludgeoning damage equal to 2d6 + your spellcasting ability modifier.

**Interposing Hand.** The hand interposes itself between you and a creature you choose until you give the hand a different command. The hand moves to stay between you and the target, providing you with half cover against the target. The target can't move through the hand's space if its STR score is less than or equal to the hand's STR score. If its STR score is higher than the hand's STR score, the target can move toward you through the hand's space, but that space is difficult terrain for the target.

_At Higher Circles._ When you cast this spell using a spell slot of 6th circle or higher, the damage from the Clenched Fist increases by 2d8 and the damage from the grasping hand increases by 2d6 for each slot above 5th.

#### Arcane Sword

_7th-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a miniature platinum sword with a grip and pommel of copper and zinc worth 250 gp)
**Duration:** Concentration, up to 1 minute

When the sword appears, you make two melee spell attacks with the blade, each one against a target of your choice within 5 feet of the sword. On a hit, the target takes 3d10 - your spellcasting modifier force damage. Until the spell ends, you can use a bonus action on each of your turns to move the sword up to 30 feet to an unoccupied spot you can see and repeat these attacks against targets within 5 feet of the blade.

### B

#### Bane

_1st-Circle Divine and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a drop of blood)
**Duration:** Concentration, up to 1 minute

Up to three creatures of your choice that you can see within range must succeed on a CHA save or become cursed.

When a cursed target makes an attack roll or a save before the spell ends, the target must roll a d4 and subtract the number rolled from the attack roll or save.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, you can target one additional creature for each slot above 1st.

#### Banishment

_4th-Circle Arcane, Divine, and Wyrd (Abjuration)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (an item distasteful to the target)
**Duration:** Concentration, up to 1 minute

You attempt to send one creature that you can see within range to another plane of existence. The target must succeed on a CHA save or be banished.

If the target is native to the plane of existence you're on, you banish the target to a harmless demiplane. While there, the target is incapacitated. The target remains there until the spell ends, at which point the target reappears in the space it left or in the nearest unoccupied space if that space is occupied.

If the target is native to a different plane of existence than the one you're on, the target is banished with a faint popping noise, returning to its home plane. If the spell ends before 1 minute has passed, the target reappears in the space it left or in the nearest unoccupied space if that space is occupied. Otherwise, the target doesn't return.

_At Higher Circles._ When you cast this spell using a spell slot of 5th circle or higher, you can target one additional creature for each slot above 4th.

#### Barkskin

_2nd-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a handful of oak bark)
**Duration:** Concentration, up to 1 hour

You touch a willing creature. Until the spell ends, the creature's skin has a rough, bark-like appearance, and its AC can't be less than 16, regardless of the armor it wears.

#### Beacon Of Hope

_3rd-Circle Divine (Abjuration)_

**Casting Time:** 1 action
**Range:** Self (30-foot radius)
**Components:** V, S
**Duration:** Concentration, up to 1 minute

This spell bestows hope and vitality. Choose any number of creatures within range. For the duration, each target has advantage on WIS saves and death saves, and regains the maximum number of hit points possible from any healing.

#### Bestow Curse

_3rd-Circle Divine and Wyrd (Necromancy)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** Concentration, up to 1 minute

You touch a creature, and that creature must succeed on a WIS save or become cursed for the duration of the spell.

When you cast this spell, choose the nature of the curse from the following options:

- Choose one ability. While cursed, the target has disadvantage on ability checks and saves made with that ability.
- While cursed, the target has disadvantage on attack rolls against you.
- While cursed, the target must make a WIS save at the start of each of its turns. If it fails, it wastes its action that turn doing nothing.
- While the target is cursed, your attacks and spells deal an extra 1d8 necrotic damage to the target.

A remove curse spell ends this effect. At the GM's discretion, you may choose an alternative curse effect, but it should be no more powerful than those described above.

_At Higher Circles._ When you cast this spell using a spell slot of 4th circle or higher, the duration becomes concentration, up to 10 minutes. If you use a spell slot of 5th circle or higher, the duration is 8 hours (no concentration). If you use a spell slot of 7th circle or higher, the duration is 24 hours (no concentration). If you use a 9th circle spell slot, the spell lasts until dispelled (no concentration).

#### Black Tentacles

_4th-Circle Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V, S, M (a piece of tentacle from a giant octopus or a giant squid)
**Duration:** Concentration, up to 1 minute

Squirming, ebony tentacles fill a 20-foot square on ground that you can see within range. For the duration, these tentacles turn the ground in the area into difficult terrain.

When a creature enters the affected area for the first time on a turn or starts its turn there, the creature must succeed on a DEX save or take 3d6 bludgeoning damage and be restrained by the tentacles until the spell ends. A creature that starts its turn in the area and is already restrained by the tentacles takes 3d6 bludgeoning damage.

A creature restrained by the tentacles can use its action to make a STR or DEX check (its choice) against your spell save DC. On a success, it frees itself.

#### Blade Barrier

_6th-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You create a vertical wall of whirling, razor-sharp blades made of magical energy within the spell's range. You can make a straight wall up to 100 feet long, 20 feet high, and 5 feet thick, or a ringed wall up to 60 feet in diameter, 20 feet high, and 5 feet thick. The wall provides three-quarters cover to creatures behind it, and its space is difficult terrain.

When a creature enters the wall's area for the first time on a turn or starts its turn there, the creature must make a DEX save. On a failure, the creature takes 6d10 slashing damage or half as much damage on a success.

#### Bless

_1st-Circle Divine (Enchantment)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a sprinkling of holy water)
**Duration:** Concentration, up to 1 minute

You bless up to three creatures of your choice within range. When a target makes an attack roll or a save before the spell ends, the target can roll a d4 and add the number rolled to the attack roll or save.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, you can target one additional creature for each slot above 1st.

#### Blight

_4th-Circle Divine and Primordial (Necromancy)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S
**Duration:** Instantaneous

Necromantic energy washes over a creature of your choice that you can see within range, draining moisture and vitality from it. The target must make a CON save. It takes 8d8 necrotic damage on a failed save, or half as much damage on a successful one. This spell has no effect on Constructs or Undead.

If you target a Plant creature or a magical plant, it makes the save with disadvantage, and the spell deals maximum damage to it.

If you target a nonmagical plant that isn't a creature, such as a tree or shrub, it withers and dies.

_At Higher Circles._ When you cast this spell using a spell slot of 5th circle or higher, the damage increases by 1d8 for each slot above 4th.

#### Blindness/deafness

_2nd-Circle Arcane, Divine, and Wyrd (Necromancy)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V
**Duration:** 1 minute

You can blind or deafen a foe. Choose one creature that you can see within range to make a CON save. If it fails, the target is either blinded or deafened (your choice) for the duration. At the end of each of its turns, the target can make a CON save. On a success, it is no longer affected by the spell.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, you can target one additional creature for each slot above 2nd.

#### Blink

_3rd-Circle Arcane and Wyrd (Transmutation)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** 1 minute

Roll a d20 at the end of each of your turns for the duration of the spell. On a roll of 11 or higher, you vanish from your current plane of existence and appear in the Ethereal Plane (if you were on the Ethereal Plane when you cast the spell, the spell fails and the casting is wasted). At the start of your next turn, and when the spell ends if you are on the Ethereal Plane, you return to an unoccupied space of your choice that you can see within 10 feet of the space you vanished from. If no unoccupied space is available within that range, you appear in the nearest unoccupied space (chosen at random if more than one space is equally near).

You can dismiss this spell as an action.

While on the Ethereal Plane, you can see and hear the plane you began in, which is cast in shades of gray, and you can't see anything there more than 60 feet away. You can only affect and be affected by other creatures on the Ethereal Plane.

Creatures that aren't there can't perceive you or interact with you unless they can see into the Ethereal Plane via the see invisibility spell or similar magic.

#### Blur

_2nd-Circle Arcane (Illusion)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V
**Duration:** Concentration, up to 1 minute

Your body becomes blurred, shifting and wavering to all who can see you. For the duration, creatures have disadvantage on attack rolls against you. An attacker is immune to this effect if it doesn't rely on sight, as with keensense, or can see through illusions, as with truesight.

#### Branding Smite

_2nd-Circle Divine (Evocation)_

**Casting Time:** 1 bonus action
**Range:** Self
**Components:** V
**Duration:** Concentration, up to 1 minute

The next time you hit a creature with a weapon attack before this spell ends, the weapon gleams with astral radiance as you strike. The attack deals an extra 2d6 radiant damage to the target, which becomes visible if it's invisible, and the target sheds dim light in a 5-foot radius and can't become invisible until the spell ends.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, the extra damage increases by 1d6 for each slot above 2nd.

#### Burning Hands

_1st-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** Self (15-foot cone)
**Components:** V, S
**Duration:** Instantaneous

A thin sheet of flames shoots forth from your outstretched fingertips. Each creature in a 15-foot cone must make a DEX save. A creature takes 3d6 fire damage on a failed save, or half as much damage on a successful one.

The fire ignites any flammable objects in the area that aren't being worn or carried.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, the extra damage increases by 1d6 for each circle above 1st.

### C

#### Call Lightning

_3rd-Circle Primordial (Conjuration)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

A storm cloud appears in the shape of a cylinder that is 10 feet tall with a 60-foot radius, centered on a point you can see 100 feet directly above you. The spell fails if you can't see a point in the air where the storm cloud could appear (for example, if you are in a room that can't accommodate the cloud).

When you cast the spell, choose a point you can see within range. A bolt of lightning flashes down from the cloud to that point. Each creature within 5 feet of that point must make a DEX save. A creature takes 3d10 lightning damage on a failed save, or half as much damage on a successful one. On each of your turns until the spell ends, you can use your action to call down lightning in this way again, targeting the same point or a different one.

If you are outdoors in stormy conditions when you cast this spell, the spell gives you control over the existing storm instead of creating a new one. Under such conditions, the spell's damage increases by 1d10.

_At Higher Circles._ When you cast this spell using a spell slot of 4th circle or higher, the damage increases by 1d10 for each slot above 3rd.

#### Calm Emotions

_2nd-Circle Divine (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

You attempt to suppress strong emotions in a group of people. Each Humanoid in a 20-foot-radius sphere centered on a point you choose within range must make a CHA save; a creature can choose to fail this save if it wishes. If a creature fails its save, choose one of the following effects.

- **Suppression.** You can suppress any effect causing a target to be charmed or frightened. When this spell ends, any suppressed effect resumes, provided that its duration has not expired in the meantime.
- **Indifference.** Alternatively, you can make a target indifferent about creatures of your choice that it is hostile toward. This indifference ends if the target is attacked or harmed by a spell or if it witnesses any of its friends being harmed. When the spell ends, the creature becomes hostile again, unless the GM rules otherwise.

#### Chain Lightning

_6th-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 150 feet
**Components:** V, S, M (a bit of fur; a piece of amber, glass, or a crystal rod; and three silver pins)
**Duration:** Instantaneous

You create a bolt of lightning that arcs toward a target of your choice that you can see within range. Three bolts then leap from that target to as many as three other targets, each of which must be within 30 feet of the first target. A target can be a creature or an object and can be targeted by only one of the bolts.

A target must make a DEX save. The target takes 10d8 lightning damage on a failed save, or half as much damage on a successful one.

_At Higher Circles._ When you cast this spell using a spell slot of 7th circle or higher, one additional bolt leaps from the first target to another target for each slot above 6th.

#### Charm

_1st-Circle Arcane and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S
**Duration:** 1 hour

You attempt to charm a creature that you can see within range. To be affected by this spell, the target must be able to understand at least one language, though it need not be a language you speak. The target must make a WIS save and does so with advantage if you or your companions are fighting it. On a failed save, it is charmed by you until the spell ends or until you or your companions do anything harmful to it. The charmed creature regards you as a friendly acquaintance. When the spell ends, the creature knows it was charmed by you.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, you can target one additional creature for each circle slot above 1st. The creatures must be within 30 feet of each other when you target them. In addition, if you cast this spell using a spell slot of 4th circle or higher, targeted creatures don't need to understand any languages to be affected.

#### Circle Of Death

_6th-Circle Arcane, Divine, and Wyrd (Necromancy)_

**Casting Time:** 1 action
**Range:** 150 feet
**Components:** V, S, M (the powder of a crushed black pearl)
**Duration:** Instantaneous

A sphere of negative energy ripples out in a 60-foot-radius sphere from a point within range. Each creature in that area must make a CON save. A target takes 8d6 necrotic damage on a failed save, or half as much damage on a successful one.

_At Higher Circles._ When you cast this spell using a spell slot of 7th circle or higher, the damage increases by 2d6 for each slot above 6th.

#### Cloudkill

_5th-Circle Arcane and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You create a 20-foot-radius sphere of poisonous, yellowgreen fog centered on a point you choose within range.

The fog spreads around corners. It lasts for the duration or until strong wind disperses the fog, ending the spell. Its area is heavily obscured.

When a creature enters the spell's area for the first time on a turn or starts its turn there, that creature must make a CON save. On a failure, the creature takes 5d8 poison damage or half as much damage on a success.

Creatures are affected even if they hold their breath or don't need to breathe.

The fog moves 10 feet away from you at the start of each of your turns, rolling along the surface of the ground. The vapors, being heavier than air, sink to the lowest level of the land, even pouring down openings.

_At Higher Circles._ When you cast this spell using a spell slot of 6th circle or higher, the damage increases by 1d8 for each slot above 5th.

#### Color Spray

_1st-Circle Arcane (Illusion)_

**Casting Time:** 1 action
**Range:** Self (15-foot cone)
**Components:** V, S, M (a pinch of powder or sand that is colored red, yellow, and blue)
**Duration:** 1 round

A dazzling array of flashing, colored light springs from your hand. Roll 8d10 and total the result. This total is how many hit points of creatures this spell can affect. Creatures in a 15-foot cone originating from you are affected in ascending order of their current hit points (ignoring unconscious creatures and creatures that can't see).

Starting with the creature that has the lowest current hit points, each creature affected by this spell is blinded until the spell ends. Subtract each creature's current hit points from the total before moving on to the creature with the next lowest hit points. A creature's hit points must be equal to or less than the remaining total for that creature to be affected.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, roll an additional 2d10 for each slot above 1st.

#### Command

_1st-Circle Divine and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

You speak a one-word command to a creature you can see within range. The target must succeed on a WIS save or follow the command at the start of its next turn. The spell has no effect if the target is Undead, if it doesn't understand your language, or if your command is directly harmful to it.

Some typical commands and their effects follow. You might issue a command other than one described here. If you do so, the GM determines how the target behaves. If the target can't follow your command, the spell ends.

Approach. The target moves toward you by the shortest and most direct route, ending its turn if it moves within 5 feet of you.

Drop. The target drops whatever it is holding and then ends its turn.

Flee. The target spends its turn moving away from you by the fastest available means.

Grovel. The target falls prone and then ends its turn.

Halt. The target doesn't move and takes no actions. A flying creature stays aloft, provided that it is able to do so.

If it must move to stay aloft, it flies the minimum distance needed to remain in the air.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, you can affect one additional creature for each slot above 1st. The creatures must be within 30 feet of each other when you target them.

#### Comprehend Languages

_1st-Circle Arcane (Divination)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S, M (a pinch of soot and salt)
**Duration:** 1 hour

For the duration, you understand the literal meaning of any spoken language that you hear. You also understand any written language that you see, but you must be touching the surface on which the words are written. It takes about 1 minute to read one page of text.

This spell doesn't decode secret messages in a text or a glyph, such as an arcane sigil, that isn't part of a written language.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, you can affect one additional willing creature (besides yourself) for each slot above 1st. The creatures must be within 30 feet of you when you target them.

#### Compulsion

_4th-Circle Arcane, Divine, and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

Creatures of your choice that you can see within range and that can hear you must make a WIS save. A target automatically succeeds on this save if it can't be charmed.

On a failed save, a target is affected by this spell. Until the spell ends, you can use a bonus action on each of your turns to designate a direction that is horizontal to you.

Each affected target must use as much of its movement as possible to move in that direction on its next turn. It can take its action before it moves. After moving in this way, it can make another WIS save to try to end the effect. A target isn't compelled to move into an obviously deadly hazard, such as a fire or pit, but it will provoke opportunity attacks to move in the designated direction.

#### Cone Of Cold

_5th-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** Self (60-foot cone)
**Components:** V, S, M (a small crystal or glass cone)
**Duration:** Instantaneous

A blast of cold air erupts from your hands. Each creature in a 60-foot cone must make a CON save. A creature takes 8d8 cold damage on a failed save, or half as much damage on a successful one.

A creature killed by this spell becomes a frozen statue until it thaws.

_At Higher Circles._ When you cast this spell using a spell slot

#### Confusion

_4th-Circle Arcane, Divine, and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V, S, M (three nut shells)
**Duration:** Concentration, up to 1 minute

This spell assaults and twists creatures' minds, spawning delusions and provoking uncontrolled action. Each creature in a 10-foot-radius sphere centered on a point you choose within range must succeed on a WIS save when you cast this spell or be affected by it.

An affected target can't take reactions and must roll a d10 at the start of each of its turns to determine its behavior for that turn.

At the end of each of its turns, an affected target can make a WIS save, ending the effect on itself on a success.

_At Higher Circles._ When you cast this spell using a spell slot of 5th circle or higher, the radius of the sphere increases by 5 feet for each slot above 4th.

##### Table: Confusion Effects

| d10   | BEHAVIOR                                                                                                                                                                                        |
| ----- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 01    | The creature uses all its movement to move in a random direction. To determine the direction, roll a d8 and assign a direction to each die face. The creature doesn't take an action this turn. |
| 02-06 | The creature doesn't move or take actions this turn.                                                                                                                                            |
| 07-08 | The creature uses its action to make a melee attack against a randomly determined creature within its reach. If there is no creature within reach, the creature does nothing this turn.         |
| 09-10 | The creature can act and move normally. At the end of each of its turns, an affected creature can make a WIS save, ending the effect on itself on a success.                                    |

#### Conjure Animals

_3rd-Circle Primordial and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 1 hour

You summon Fey spirits that take the form of Beasts and appear in unoccupied spaces that you can see within range.

Choose one of the following options for what appears:

- One Beast of CR 2 or lower
- Two Beasts of CR 1 or lower
- Four Beasts of CR 1/2 or lower
- Eight Beasts of CR 1/4 or lower

Each Beast is also considered Fey, and it disappears when it drops to 0 HP or when the spell ends.

The summoned creatures are friendly to you and your companions. The summoned creatures act on your initiative, taking their turns immediately after yours. They obey any verbal commands you issue to them (no action required by you). If you don't give any commands, they defend themselves from hostile creatures but otherwise take no actions. The GM has the creatures' statistics.

_At Higher Circles._ When you cast this spell using certain higher-circle spell slots, you choose one of the summoning options above, and more creatures appear: twice as many with a 5th-circle slot, three times as many with a 7th-circle slot, and four times as many with a 9th-circle slot.

#### Conjure Elemental

_5th-Circle Arcane and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V, S, M (burning incense for air, soft clay for earth, sulfur and phosphorus for fire, or water and sand for water)
**Duration:** Concentration, up to 1 hour

You summon an Elemental servant that appears in an unoccupied space you can see within range. Choose which Elemental appears: an air elemental, earth elemental, a fire elemental, or a water elemental. The GM has the creature's statistics. If your GM allows it, you can use this spell to summon a different Elemental of your choice of CR 5 or lower. This spell can't summon creatures with Legendary Actions. The creature disappears when it drops to 0 hit points or when the spell ends.

The Elemental is friendly to you and your companions for the duration. In combat, the Elemental acts on your initiative and takes its turn immediately after yours. It obeys any verbal commands that you issue to it (no action required by you). If you don't issue any commands to the Elemental, it defends itself from hostile creatures but otherwise takes no actions.

_At Higher Circles._ When you cast this spell using a spell slot of 6th circle or higher, you can choose to summon an Elemental of a CR equal to or below the circle of the expended slot. For example, expending an 8th circle slot allows you to summon an Elemental creature of CR 8 or lower.

#### Conjure Minor Elementals

_4th-Circle Arcane and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V, S
**Duration:** Concentration, up to 1 hour

You summon Elemental creatures that appear in unoccupied spaces that you can see within range. Choose one of the following options for what appears:

- One Elemental creature of CR 2 or lower
- Two Elemental creatures of CR 1 or lower
- Four Elemental creatures of CR 1/2 or lower

A summoned creature disappears when it drops to 0 HP or when the spell ends.

The summoned creatures are friendly to you and your companions. The summoned creatures act on your initiative, taking their turns immediately after yours. They obey any verbal commands you give them (no action required by you). If you don't give any commands, they defend themselves from hostile creatures but otherwise take no actions. The GM has the creatures' statistics.

_At Higher Circles._ When you cast this spell using certain higher-circle spell slots, choose one of the summoning options above, and more creatures appear: twice as many with a 6th-circle slot and three times as many with an 8th-circle slot.

#### Conjure Woodland Beings

_4th-Circle Primordial (Conjuration)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a holly berry for each creature summoned)
**Duration:** Concentration, up to 1 hour

You summon Fey creatures that appear in unoccupied spaces that you can see within range. Choose one of the following options for what appears:

- One Fey creature of CR 2 or lower
- Two Fey creatures of CR 1 or lower
- Four Fey creatures of CR 1/2 or lower

A summoned creature disappears when it drops to 0 HP or when the spell ends.

The summoned creatures are friendly to you and your companions. The summoned creatures act on your initiative, taking their turns immediately after yours.

They obey any verbal commands you give them (no action required by you). If you don't give any commands, they defend themselves from hostile creatures but otherwise take no actions. The GM has the creatures' statistics.

_At Higher Circles._ When you cast this spell using certain higher-circle spell slots, choose one of the summoning options above, and more creatures appear: twice as many with a 6th-circle slot and three times as many with an 8thcircle slot.

#### Contagion

_5th-Circle Divine and Primordial (Necromancy)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** 7 days

Make a melee spell attack against a creature within your reach. On a hit, you afflict the creature with a disease of your choice selected from the options below.

At the end of each of the target's turns, it must make a CON save. After failing three of these saves, the disease's effects last for the duration, and the creature stops making these saves. After succeeding on three of these saves, the creature recovers from the disease and the spell ends.

Since this spell induces a natural disease in its target, any effect that removes or suppresses a disease's effects apply to it.

**Blinding Sickness.** Pain grips the creature's mind, and its eyes turn milky white. The creature has disadvantage on WIS checks and WIS saves and is blinded.

**Filth Fever.** A raging fever sweeps through the creature's body. The creature has disadvantage on STR checks, STR saves, and attack rolls that use STR.

**Flesh Rot.** The creature's flesh decays. The creature has disadvantage on CHA checks and becomes vulnerable to all damage.

**Mindfire.** The creature's mind becomes feverish. The creature has disadvantage on INT checks and INT saves, and the creature behaves as if under the effects of the confusion spell during combat.

**Seizure.** The creature is overcome with shaking. The creature has disadvantage on DEX checks, DEX saves, and attack rolls that use DEX.

**Slimy Doom.** The creature begins to bleed uncontrollably. The creature has disadvantage on CON checks and CON saves. In addition, when the creature takes damage, it is stunned until the end of its next turn.

#### Continual Flame

_2nd-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (ruby dust worth 50 gp, which the spell consumes)
**Duration:** Until dispelled

A flame equivalent in brightness to a torch springs from an object that you touch. The effect looks like a regular flame, but it creates no heat and doesn't use oxygen. The flame can be covered or hidden but not smothered or quenched.

#### Control Water

_4th-Circle Divine and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 300 feet
**Components:** V, S, M (a drop of water and a pinch of dust)
**Duration:** Concentration, up to 10 minutes

Until the spell ends, you control any freestanding water inside an area you choose that is a cube up to 100 feet on a side. You can choose from any of the following effects when you cast this spell. As an action on your turn, you can repeat the same effect or choose a different one.

**Flood.** You cause the level of all standing water in the area to rise by as much as 20 feet. If the area includes a shore, the flooding water spills over onto dry land. If you choose an area in a large body of water, you instead create a 20-foot-tall wave that travels from one side of the area to the other and then crashes down. Any Huge or smaller vehicles in the wave's path are carried with it to the other side. Any Huge or smaller vehicles struck by the wave have a 25 percent chance of capsizing. The water level remains elevated until the spell ends or you choose a different effect. If this effect produced a wave, the wave repeats on the start of your next turn while the flood effect lasts.

**Part Water.** You separate water in the area, creating a trench in the water. The trench extends across the spell's area, and the separated water forms a wall to either side. The trench remains until the spell ends or you choose a different effect. The water then slowly fills in the trench over the course of the next round until the normal water level is restored.

**Redirect Flow.** You cause flowing water in the area to move in a direction you choose, even if the water has to flow over obstacles, up walls, or in other unlikely directions. The water moves as you direct it, but once it moves beyond the spell's area, it resumes its flow based on terrain conditions. The water continues to move in the direction you chose until the spell ends or you choose a different effect.

**Whirlpool.** This effect requires a body of water at least 50 feet square and 25 feet deep. You cause a whirlpool to form in the center of the area. The whirlpool forms a vortex that is 5 feet wide at the base, up to 50 feet wide at the top, and 25 feet tall. Any creature or object in the water and within 25 feet of the vortex is pulled 10 feet toward it. A creature can swim away from the vortex by making a STR (Athletics) check against your spell save DC. When a creature enters the vortex for the first time on a turn or starts its turn there, it must make a STR save. On a failed save, the creature takes 2d8 bludgeoning damage and is caught in the vortex until the spell ends. On a successful save, the creature takes half as much damage and isn't caught in the vortex. A creature caught in the vortex can use its action to try to swim away from the vortex as described above but has disadvantage on the STR (Athletics) check to do so. The first time each turn that an object enters the vortex, the object takes 2d8 bludgeoning damage; this damage occurs each round it remains in the vortex.

#### Counterspell

_3rd-Circle Arcane (Abjuration)_

**Casting Time:** 1 reaction, when you see a creature within 60 feet of you casting a spell
**Range:** 60 feet
**Components:** S
**Duration:** Instantaneous

You attempt to interrupt a creature in the process of casting a spell. If the creature is casting a spell of 3rd circle or lower, its spell automatically fails and has no effect. If it is casting a spell of 4th circle or above, make an ability check using your spellcasting ability. The DC equals 10 + the spell's circle. On a success, the creature's spell fails and has no effect.

_At Higher Circles._ When you cast this spell using a spell slot of 4th circle or higher, the interrupted spell automatically has no effect if its circle is less than or equal to the circle of the spell slot you used.

#### Create Food And Water

_3rd-Circle Divine and Primordial (Conjuration)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S
**Duration:** Instantaneous

You create 45 pounds of food and 30 gallons of water on the ground or in containers within range, enough to sustain up to twenty Large or smaller creatures for 24 hours. The food is bland but nourishing, and it spoils if uneaten after 24 hours. The water is clean and doesn't go bad.

#### Create Or Destroy Water

_1st-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a drop of water if creating water or a few grains of sand if destroying it)
**Duration:** Instantaneous

When you cast this spell, choose which of the following effects to create.

**_Create Water._** You create up to 10 gallons of clean water within range in an open container. Alternatively, the water falls as rain in a 30-foot cube within range, extinguishing exposed flames in the area.

**_Destroy Water._** You destroy up to 10 gallons of water in an open container within range. Alternatively, you destroy fog in a 30-foot cube within range.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, you create or destroy 10 additional gallons of water, or the size of the cube increases by 5 feet, for each slot above 1st.

#### Cure Wounds

_1st-Circle Divine and Primordial (Necromancy)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** Instantaneous

A creature you touch regains a number of hit points equal to 1d8 + your spellcasting ability modifier.

This spell has no effect on Constructs or Undead.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, the healing increases by 1d8 for each slot above 1st.

### D

#### Dancing Lights

_Arcane, Primordial, and Wyrd Cantrip (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (a bit of phosphorus or wychwood, or a glowworm)
**Duration:** Concentration, up to 1 minute

You create up to four torch-sized lights within range, making them appear as torches, lanterns, or glowing orbs that hover in the air for the duration. You can also combine the four lights into one glowing vaguely Humanoid form of Medium size. Whichever form you choose, each light sheds dim light in a 10-foot radius.

As a bonus action on your turn, you can move the lights up to 60 feet to a new spot within range. A light must be within 20 feet of another light created by this spell, and a light winks out if it exceeds the spell's range.

#### Darkness

_2nd-Circle Arcane and Wyrd (Evocation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, M (bat fur and a drop of pitch or piece of coal)
**Duration:** Concentration, up to 10 minutes

Magical darkness spreads from a point you choose within range to fill a 15-foot-radius sphere for the duration. The darkness spreads around corners. A creature with darkvision can't see through this darkness, and nonmagical light can't illuminate it.

If the point you choose is on an object you are holding or one that isn't being worn or carried, the darkness emanates from the object and moves with it. Completely covering the source of the darkness with an opaque object, such as a bowl or a helm, blocks the darkness.

If any of this spell's area overlaps with an area of light created by a 2nd circle spell or lower, the spell that created the light is dispelled.

#### Darkvision

_2nd-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a pinch of dried carrot or an agate)
**Duration:** 8 hours

You touch a willing creature to grant it the ability to see in nonmagical darkness. For the duration, that creature has darkvision to a range of 60 feet.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, you can target one additional creature for each slot above 2nd.

#### Daylight

_3rd-Circle Divine and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** 1 hour

A 60-foot-radius sphere of daylight spreads out from a point you choose within range. The sphere is bright light and sheds dim light for an additional 60 feet.

If you choose a point on an object you are holding or one that isn't being worn or carried, the light shines from the object and moves with it. Completely covering the affected object with an opaque object, such as a bowl or a helm, blocks the light.

If any of this spell's area overlaps with an area of darkness created by a spell of 3rd circle or lower such as that created by the darkness spell, the spell that created the darkness is dispelled.

#### Death Ward

_4th-Circle Divine (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** 8 hours

The first time the target of this spell would drop to 0 HP as a result of taking damage, the target instead drops to 1 HP, and the spell ends.

If the target is subjected to an effect that would kill it instantaneously without dealing damage, that effect is instead negated against the target, and the spell ends.

#### Delayed Blast Fireball

_7th-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 150 feet (20-foot-radius sphere) **Components:** V, S, M (a tiny ball of bat guano and sulfur)
**Duration:** Concentration, up to 1 minute

A beam of yellow light flashes from your pointing finger, then condenses to linger at a chosen point within range as a glowing bead for the duration. When the spell ends, either because your concentration is broken or because you decide to end it, the bead blossoms with a low roar into an explosion of flame that spreads around corners. Each creature in a 20-foot-radius sphere centered on that point must make a DEX save. A creature takes fire damage equal to the total accumulated damage on a failed save, or half as much damage on a successful one.

The spell's base damage is 12d6. If at the end of your turn the bead has not yet detonated, the damage increases by 1d6.

If the glowing bead is touched before the interval has expired, the creature touching it must make a DEX save. On a failed save, the spell ends immediately, causing the bead to erupt in flame.

On a successful save, the creature can throw the bead up to 40 feet. When it strikes a creature or a solid object, the spell ends, and the bead explodes.

The fire damages objects in the area and ignites flammable objects that aren't being worn or carried.

_At Higher Circles._ When you cast this spell using a spell slot of 8th circle or higher, the base damage increases by 1d6 for each slot above 7th.

#### Demiplane

_8th-Circle Arcane and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** S
**Duration:** 1 hour

You create a shadowy door on a flat solid surface that you can see within range. The door is large enough to allow Medium creatures to pass through unhindered. When opened, the door leads to a demiplane that appears to be an empty room 30 feet in each dimension, made of wood or stone. When the spell ends, the door disappears, and any creatures or objects inside the demiplane remain trapped there, as the door also disappears from the other side.

Each time you cast this spell, you can create a new demiplane, or have the shadowy door connect to a demiplane you created with a previous casting of this spell. In addition, if you know the nature and contents of a demiplane created by a casting of this spell by another creature, you can have the shadowy door connect to its demiplane instead.

#### Detect Evil And Good

_1st-Circle Divine and Wyrd (Divination)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

For the duration, you know if there is an Aberration, Celestial, Elemental, Fey, Fiend, or Undead within 30 feet of you, as well as where the creature is located. Similarly, you know if there is a place or object within 30 feet of you that has been magically consecrated or desecrated.

The spell can penetrate most barriers, but it is blocked by 1 foot of stone, 1 inch of common metal, a thin sheet of lead, or 3 feet of wood or dirt.

#### Detect Magic

_1st-Circle Arcane and Wyrd (Divination)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

For the duration, you sense the presence of magic within 30 feet of you. If you sense magic in this way, you can use your action to see a faint aura around any visible creature or object in the area that bears magic, and you learn its school of magic, if any.

The spell can penetrate most barriers, but it is blocked by 1 foot of stone, 1 inch of common metal, a thin sheet of lead, or 3 feet of wood or dirt.

#### Detect Thoughts

_2nd-Circle Arcane and Wyrd (Divination)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S, M (a copper piece)
**Duration:** Concentration, up to 1 minute

For the duration, you can read the thoughts of certain creatures. When you cast the spell and as your action on each turn until the spell ends, you can focus your mind on any one creature that you can see within 30 feet of you. If the creature you choose has an INT of 3 (-4) or lower or doesn't speak any languages, the creature is unaffected.

You initially learn the surface thoughts of the creature - what is most on its mind in that moment. As an action, you can either shift your attention to another creature's thoughts or attempt to probe deeper into the same creature's mind. If you probe deeper, the target must make a WIS save. If it fails, you gain insight into its reasoning (if any), its emotional state, and something that looms large in its mind (such as something it worries over, loves, or hates). If it succeeds, the spell ends. Either way, the target knows that you are probing into its mind, and unless you shift your attention to another creature's thoughts, the creature can use its action on its turn to make an INT check contested by your INT check; if the target succeeds, the spell ends.

Questions verbally directed at the target creature naturally shape the course of its thoughts, so this spell is particularly effective as part of an interrogation.

You can also use this spell to detect the presence of thinking creatures you can't see. When you cast the spell or as your action during the duration, you can search for thoughts within 30 feet of you. The spell can penetrate barriers, but 2 feet of rock, 2 inches of any metal other than lead, or a thin sheet of lead blocks you. You can't detect a creature with an INT of 3 (-4) or lower or one that doesn't speak any languages.

Once you detect the presence of a creature in this way, you can read its thoughts for the rest of the duration as described above, even if you can't see it, but it must still be within range.

#### Dimension Door

_4th-Circle Arcane and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** 500 feet
**Components:** V
**Duration:** Instantaneous

You teleport yourself from your current location to any other spot within range. You arrive at exactly the spot desired. It can be a place you can see, one you can visualize, or one you can describe by stating distance and direction, such as "200 feet straight downward" or "upward to the northwest at a 45-degree angle, 300 feet."

You can bring along objects as long as their weight doesn't exceed what you can carry. You can also bring one willing creature of your size or smaller who is carrying gear up to its carrying capacity. The creature must be within 5 feet of you when you cast this spell.

If you would arrive in a place already occupied by an object or a creature, you and any creature traveling with you each take 4d6 force damage, and the spell fails to teleport you.

#### Disguise Self

_1st-Circle Arcane and Wyrd (Illusion)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** 1 hour

You make yourself - including your clothing, armor, weapons, and other belongings on your person - look different until the spell ends or until you use your action to dismiss it. You can seem 1 foot shorter or taller and can appear thin, fat, or in between. You can't change your body type, so you must adopt a form that has the same basic arrangement of limbs. Otherwise, the extent of the illusion is up to you.

The changes wrought by this spell fail to hold up to physical inspection. For example, if you use this spell to add a hat to your outfit, objects pass through the hat, and anyone who touches it would feel nothing or would feel your head and hair. If you use this spell to appear thinner than you are, the hand of someone who reaches out to touch you would bump into you while it was seemingly still in midair.

To discern that you are disguised, a creature can use its action to inspect your appearance and must succeed on an INT (Investigation) check against your spell save DC.

#### Dispel Magic

_3rd-Circle Arcane and Divine (Abjuration)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** Instantaneous

Choose one creature, object, or magical effect within range. Any spell of 3rd circle or lower on the target ends.

For each spell of 4th circle or higher on the target, make an ability check using your spellcasting ability. The DC equals 10 + the spell's circle. On a successful check, the spell ends.

_At Higher Circles._ When you cast this spell using a spell slot of 4th circle or higher, you automatically end the effects of a spell on the target if the spell's circle is equal to or less than the circle of the spell slot you used.

#### Disintegrate

_6th-Circle Arcane and Wyrd (Transmutation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a lodestone and pinch of dust)
**Duration:** Instantaneous

A thin green ray springs from your pointing finger to a target that you can see within range. The target can be a creature, an object, or a creation of magical force, such as the wall created by a wall of force spell.

A creature targeted by this spell must make a DEX save.

On a failed save, the target takes 10d6 + 40 force damage. If this damage reduces the target to 0 HP, it is disintegrated.

A disintegrated creature and everything it is wearing and carrying, except magic items, are reduced to a pile of fine gray dust. The creature can be restored to life only by means of a true resurrection or a wish spell. If the target is destroyed, any magic items it was wearing or holding drop onto the ground in a space previously occupied by the target.

This spell automatically disintegrates a Large or smaller nonmagical object or a creation of magical force. If the target is a Huge or larger object or creation of force, this spell disintegrates a 10-foot-cube portion of it. A magic item is unaffected by this spell.

_At Higher Circles._ When you cast this spell using a spell slot of 7th circle or higher, the damage increases by 3d6 for each slot above 6th.

#### Dispel Evil And Good

_5th-Circle Divine and Wyrd (Abjuration)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S, M (holy water or powdered silver and iron)
**Duration:** Concentration, up to 1 minute

Shimmering energy surrounds and protects you from certain types of creatures: Celestials, Elementals, Fey, Fiends, Undead, and creatures with the Outsider tag.

Creatures of those types have disadvantage on attack rolls against you.

You can end the spell early by using either of the following special functions.

**Break Enchantment.** As your action, you touch a creature you can reach that is charmed, frightened, or possessed by one of the listed creature types. The creature you touch is no longer charmed, frightened, or possessed by such creatures.

**Dismissal.** As your action, make a melee spell attack against a creature of one of the listed types you can reach. On a hit, you attempt to drive the creature back to its home plane. The creature must succeed on a CHA save or be sent back to its home plane (if it isn't there already) or a different plane deemed appropriate by the GM.

#### Divine Favor

_1st-Circle Divine (Evocation)_

**Casting Time:** 1 bonus action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 1 minute

Your prayer empowers you with divine radiance. Until the spell ends, your weapon attacks deal an extra 1d4 radiant damage on a hit.

#### Divine Word

_7th-Circle Divine (Evocation)_

**Casting Time:** 1 bonus action
**Range:** 30 feet
**Components:** V
**Duration:** Instantaneous

You utter a divine word, imbued with the power that shaped the world at the dawn of creation. Choose any number of creatures you can see within range. Each creature that can hear you must make a CHA save. On a failed save, a creature suffers an effect based on its current hit points:

- 50 HP or fewer: deafened for 1 minute
- 40 HP or fewer: deafened and blinded for 10 minutes
- 30 HP or fewer: blinded, deafened, and stunned for 1 hour
- 20 HP or fewer: killed instantly

Regardless of its current hit points, a Celestial, an Elemental, a Fey, or a Fiend that fails its save is forced back to its plane of origin (if it isn't there already) and can't return to your current plane for 24 hours by any means short of a wish spell.

#### Dominate

_5th-Circle Arcane and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

Choose a Medium or smaller creature that you can see within range. This spell has no effect on creatures immune to the charmed condition. The target must succeed on a WIS save or be charmed by you for the duration. If you or creatures that are friendly to you are fighting it, it has advantage on the save.

While the creature is charmed, you have a telepathic link with it as long as the two of you are on the same plane of existence. You can use this telepathic link to issue commands to the creature while you are conscious (no action required), which it does its best to obey. You can specify a simple and general course of action, such as "attack that creature," "run over there," or "fetch that object." If the creature completes the order and doesn't receive further direction from you, it defends and preserves itself to the best of its ability.

You can use your action to take total and precise control of the target. Until the end of your next turn, the creature takes only the actions you choose and doesn't do anything that you don't allow it to do.

During this time, you can also cause the creature to use a reaction, but this requires you to use your own reaction as well.

Each time the target takes damage, it makes a new WIS save against the spell, ending the spell on a success.

_At Higher Circles._ When you cast this spell using a 6th-circle spell slot, the duration is concentration, up to 10 minutes. When you use a 7th-circle spell slot, the duration is concentration, up to 1 hour. When you use a spell slot of 8th circle or higher, the duration is concentration, up to 8 hours.

#### Druidcraft

_Primordial Cantrip (Transmutation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S
**Duration:** Instantaneous

Whispering to the spirits of nature, you create one of the following effects within range:

- You create a tiny, harmless sensory effect that predicts what the weather will be at your location for the next 24 hours. The effect might manifest as a golden orb for clear skies, a cloud for rain, falling snowflakes for snow, and so on. This effect persists for 1 round.
- You instantly make a flower blossom, a seed pod open, or a leaf bud bloom.
- You create an instantaneous, harmless sensory effect, such as falling leaves, a puff of wind, the sound of a small animal, or the faint odor of skunk. The effect must fit in a 5-foot cube.
- You instantly light or snuff out a candle, torch, or small campfire.

### E

#### Earthquake

_8th-Circle Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 500 feet (100-foot-radius circle) **Components:** V, S, M (a pinch of dirt, a piece of rock, and a lump of clay)
**Duration:** Concentration, up to 1 minute

You create a seismic disturbance at a point on the ground that you can see within range. For the duration, an intense tremor rips through the ground in a 100-foot-radius circle centered on that point and shakes creatures and structures in contact with the ground in that area.

The ground in the area becomes difficult terrain. Each creature on the ground that is concentrating must make a CON save. On a failed save, the creature's concentration is broken.

When you cast this spell and at the end of each turn you spend concentrating on it, each creature on the ground in the area must make a DEX save. On a failed save, the creature is knocked prone.

This spell can have additional effects depending on the terrain in the area, as determined by the GM.

Fissures. Fissures open throughout the spell's area at the start of your next turn after you cast the spell. A total of 1d6 such fissures open in locations chosen by the GM.

Each is 1d10 × 10 feet deep, 10 feet wide, and extends from one edge of the spell's area to the opposite side. A creature standing on a spot where a fissure opens must succeed on a DEX save or fall in. A creature that successfully saves moves with the fissure's edge as it opens. A fissure that opens beneath a structure causes it to automatically collapse (see following section).

Structures. The tremor deals 50 bludgeoning damage to any structure in contact with the ground in the area when you cast the spell and at the start of each of your turns until the spell ends. If a structure drops to 0 HP, it collapses and potentially damages nearby creatures. A creature within half the distance of a structure's height must make a DEX save. On a failed save, the creature takes 5d6 bludgeoning damage, is knocked prone, and is buried in the rubble, requiring a DC 20 STR (Athletics) check as an action to escape. The GM can adjust the DC higher or lower, depending on the nature of the rubble. On a successful save, the creature takes half as much damage and doesn't fall prone or become buried.

#### Elemental Blade

_2nd-Circle Arcane (Evocation)_

**Casting Time:** 1 bonus action
**Range:** Self
**Components:** V, S, M (a leaf of sumac)
**Duration:** Concentration, up to 10 minutes

You evoke an elemental blade in your free hand. The blade is similar in size and shape to a scimitar, and it lasts for the duration. If you let go of the blade, it disappears, but you can evoke the blade again as a bonus action. When the blade first appears, you decide whether it deals acid, cold, fire, lightning, or thunder damage.

You can use your action to make a melee spell attack with the elemental blade. On a hit, the target takes 3d6 damage of the chosen type. The elemental blade sheds bright light in a 10-foot radius and dim light for an additional 10 feet.

_At Higher Circles._ When you cast this spell using a spell slot of 4th circle or higher, the damage increases by 1d6 for every two slots above 2nd.

#### Elemental Shield

_4th-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S, M (a bit of phosphorus or a firefly)
**Duration:** 10 minutes

Elemental energy wreathes your body for the duration, shedding bright light in a 10-foot radius and dim light for an additional 10 feet. You can end the spell early by using an action to dismiss it. When the shield first appears, you decide whether it is made of acid, cold, fire, lightning, or thunder energy.

The shield grants you resistance to the damage of your chosen elemental type.

In addition, when a creature within 5 feet of you hits you with a melee attack, the shield erupts with energy. The attacker takes 2d8 damage of the chosen type.

#### Enhance Ability

_2nd-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (fur or a feather from a beast)
**Duration:** Concentration, up to 1 hour

You touch a creature and bestow one of the following effects upon it. It gains that effect until the spell ends.

Bear's Endurance. The target has advantage on CON checks and gains 2d6 temporary HP, which are lost when the spell ends.

Bull's Strength. The target has advantage on STR checks, and its carrying capacity doubles.

Cat's Grace. The target has advantage on DEX checks.

It also doesn't take damage from falling 20 feet or less if it isn't incapacitated.

Eagle's Splendor. The target has advantage on CHA checks and saves against the charmed condition.

Fox's Cunning. The target has advantage on INT checks and checks made to Hide or otherwise avoid notice.

Owl's Wisdom. The target has advantage on WIS checks and can't be surprised.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, you can target one additional creature for each slot above 2nd.

#### Enlarge/reduce

_2nd-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a pinch of powdered iron)
**Duration:** Concentration, up to 1 minute

You cause a creature or an object you can see within range to grow larger or smaller for the duration. Choose a creature or an object that is neither worn nor carried. If the target is unwilling, it can make a CON save. On a success, the spell has no effect. If the target is a creature, everything it is wearing and carrying changes size with it. Any item dropped by an affected creature returns to normal size at once.

Enlarge. The target's size doubles in all dimensions, and its weight is multiplied by eight. This growth increases its size by one category - from Medium to Large, for example. If there isn't enough room for the target to double its size, the creature or object attains the maximum possible size in the space available. Until the spell ends, the target also has advantage on STR checks and STR saves.

The target's weapons also grow to match its new size.

While these weapons are enlarged, the target's attacks with them deal 1d4 extra damage.

Reduce. The target's size is halved in all dimensions, and its weight is reduced to one-eighth of normal. This reduction decreases its size by one category - from Medium to Small, for example. Until the spell ends, the target also has disadvantage on STR checks and STR saves.

The target's weapons also shrink to match its new size.

While these weapons are reduced, the target's attacks with them deal 1d4 less damage (this can't reduce the damage below 1).

#### Entangle

_1st-Circle Primordial (Conjuration)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

Grasping weeds and vines sprout from the ground in a 20-foot square starting from a point within range. For the duration, these plants turn the ground in the area into difficult terrain. A creature in the area when you cast the spell must succeed on a STR save or be restrained by the entangling plants until the spell ends. A creature restrained by the plants can use its action to make a STR check against your spell save DC. On a success, it frees itself. When the spell ends, the conjured plants wilt away.

#### Enthrall

_2nd-Circle Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** 1 minute

You weave a distracting string of words, causing creatures of your choice that you can see within range and that can hear you to make a WIS save. Any creature that can't be charmed succeeds on this save automatically, and if you or your companions are fighting a creature, it has advantage on the save. On a failed save, the target has disadvantage on WIS (Perception) checks made to perceive any creature other than you until the spell ends or until the target can no longer hear you. The spell ends if you are incapacitated or can no longer speak.

#### Etherealness

_7th-Circle Arcane and Wyrd (Transmutation)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** 8 hours

You step into the border regions of the Ethereal Plane, in the area where it overlaps with your current plane. You remain in the Ethereal Plane for the duration or until you use your action to dismiss the spell. During this time, you can move in any direction. If you move up or down, every foot of movement costs an extra foot. You can see and hear the plane you originated from, but everything there looks gray, and you can't see anything more than 60 feet away.

While on the Ethereal Plane, you can only affect and be affected by other creatures on that plane. Creatures that aren't on the Ethereal Plane can't perceive you and can't interact with you unless a special ability or magic has given them the ability to do so.

You ignore all objects and effects that aren't on the Ethereal Plane, allowing you to move through objects you perceive on the plane you originated from.

When the spell ends, you immediately return to the plane you originated from in the spot you currently occupy. If you occupy the same spot as a solid object or creature when this happens, you are immediately shunted to the nearest unoccupied space that you can occupy and take force damage equal to twice the number of feet you are moved.

This spell has no effect if you cast it while you are on the Ethereal Plane or a plane that doesn't border it.

_At Higher Circles._ When you cast this spell using a spell slot of 8th circle or higher, you can target up to three willing creatures (including you) for each slot above 7th. The creatures must be within 10 feet of you when you cast the spell.

#### Expeditious Retreat

_1st-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 bonus action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 1 minute

This spell allows you to move at an incredible pace. When you first cast this spell, and then as a bonus action on each of your turns until the spell ends, you can take the Dash action.

#### Eyebite

_6th-Circle Wyrd (Transmutation)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 1 minute

For the spell's duration, your eyes become an inky void imbued with dread power. One creature of your choice within 60 feet of you that you can see must succeed on a WIS save or be affected by one of the following effects of your choice for the duration. On each of your turns until the spell ends, you can use your action to target another creature but can't target a creature again if it has succeeded on a save against this casting of eyebite.

Asleep. The target falls unconscious. It wakes up if it takes any damage or if another creature uses its action to shake the sleeper awake.

Panicked. The target is frightened of you. On each of its turns, the frightened creature must take the Dash action and move away from you by the safest and shortest available route, unless there is nowhere to move. If the target moves to a place at least 60 feet away from you where it can no longer see you, this effect ends.

Sickened. The target has disadvantage on attack rolls and ability checks. At the end of each of its turns, it can make another WIS save. If it succeeds, the effect ends.

### F

#### Faerie Fire

_1st-Circle Wyrd (Evocation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V
**Duration:** Concentration, up to 1 minute

Each object in a 20-foot cube within range is outlined in blue, green, or violet light (your choice). Any creature in the area when the spell is cast is also outlined in light if it fails a DEX save. For the duration, objects and affected creatures shed dim light in a 10-foot radius.

Any attack roll against an affected creature or object has advantage if the attacker can see it, and the affected creature or object can't benefit from being invisible.

#### Faithful Hound

_4th-Circle Divine and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a tiny silver whistle, a piece of bone, and a thread)
**Duration:** 8 hours

You conjure a phantom watchdog in an unoccupied space that you can see within range, where it remains for the duration, until you dismiss it as an action, or until you move more than 100 feet away from it.

The hound is invisible to all creatures except you and can't be harmed. When a Small or larger creature comes within 30 feet of it without first speaking the password that you specify when you cast this spell, the hound starts barking loudly. The hound sees invisible creatures and can see into the Ethereal Plane. It ignores illusions.

At the start of each of your turns, the hound attempts to bite one creature within 5 feet of it that is hostile to you. The hound's attack bonus is equal to your spellcasting ability modifier + your PB. On a hit, it deals 4d8 piercing damage.

#### False Life

_1st-Circle Arcane (Necromancy)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S, M (a small amount of alcohol or distilled spirits)
**Duration:** 1 hour

You bolster yourself with a touch of the same necromantic powers used to preserve the dead. You gain 1d4 + 4 temporary hit points for the duration.

_At Higher Circles._ When you cast this spell using a 2ndcircle spell slot or higher, you gain 5 additional temporary hit points for each slot above 1st.

#### Fear

_3rd-Circle Arcane and Wyrd (Illusion)_

**Casting Time:** 1 action
**Range:** Self (30-foot cone)
**Components:** V, S, M (a white feather or the heart of a hen)
**Duration:** Concentration, up to 1 minute

You project a phantasmal image of a creature's worst fears.

Each creature in a 30-foot cone must succeed on a WIS save or drop whatever it is holding and become frightened of you for the duration.

While frightened by this spell, a creature must take the Dash action and move away from you by the safest available route on each of its turns, unless there is nowhere to move.

If the creature ends its turn in a location where it doesn't have line of sight to you, the creature can make a WIS save, ending the effect on itself on a success.

#### Feather Fall

_1st-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 reaction, when you or a creature within 60 feet of you falls
**Range:** 60 feet
**Components:** V, M (a small feather or piece of down)
**Duration:** 1 minute

Choose up to five falling creatures within range. A falling creature's rate of descent slows to 60 feet per round until the spell ends. If the creature lands before the spell ends, it takes no falling damage and can land on its feet, and the spell ends for that creature.

#### Feeblemind

_8th-Circle Arcane (Enchantment)_

**Casting Time:** 1 action
**Range:** 150 feet
**Components:** V, M (a handful of clay, crystal, glass, or mineral spheres)
**Duration:** Instantaneous

You blast the mind of a creature that you can see within range, attempting to shatter its intellect and personality.

The target takes 4d6 psychic damage and must make an INT save.

On a failed save, the creature's INT and CHA become 1 (-5). The creature can't cast spells, activate magic items, understand language, or communicate in any intelligible way. However, the creature can identify its friends, follow them, and even protect them.

At the end of every 30 days, the creature can repeat its save against this spell, ending the spell on a success.

The spell can also be ended by the greater restoration, heal, or wish spells.

#### Finger Of Death

_7th-Circle Arcane, Divine, and Wyrd (Necromancy)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

You send negative energy coursing through a creature that you can see within range, causing it searing pain. The target must make a CON save. It takes 7d8 + 30 necrotic damage on a failed save, or half as much damage on a success.

A Humanoid killed by this spell rises as a zombie at the start of your next turn. The zombie is permanently under your command and follows your verbal orders to the best of its ability.

#### Fire Bolt

_Arcane Cantrip (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** Instantaneous

You hurl a mote of fire at a creature or object within range.

Make a ranged spell attack against the target. On a hit, the target takes 1d10 fire damage. A flammable object hit by this spell ignites if it isn't being worn or carried.

This spell's damage increases by 1d10 when you reach 5th level (2d10), 11th level (3d10), and 17th level (4d10).

#### Fire Storm

_7th-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 150 feet
**Components:** V, S
**Duration:** Instantaneous

A storm made up of sheets of roaring flame appears in a location you choose within range. The area of the storm consists of up to ten 10-foot cubes, which you can arrange as you wish. Each cube must have at least one face adjacent to the face of another cube.

Each creature in the area must make a DEX save. It takes 7d10 fire damage on a failed save, or half as much damage on a successful one.

The fire damages objects in the area and ignites flammable objects that aren't being worn or carried. If you choose, plant life in the area is unaffected by this spell.

#### Fireball

_3rd-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 150 feet
**Components:** V, S, M (a tiny ball of bat guano and sulfur)
**Duration:** Instantaneous

A bright streak flashes from your pointing finger to a point you choose within range and then blossoms with a low roar into an explosion of flame. Each creature in a 20-footradius sphere centered on that point must make a DEX save. A target takes 8d6 fire damage on a failed save, or half as much damage on a success.

The fire spreads around corners. It ignites flammable objects in the area that aren't being worn or carried.

_At Higher Circles._ When you cast this spell using a spell slot of 4th circle or higher, the damage increases by 1d6 for each slot above 3rd.

#### Flame Strike

_5th-Circle Divine (Evocation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a pinch of sulfur)
**Duration:** Instantaneous

A vertical column of divine fire roars down from the heavens in a location you specify. Each creature in a 10-foot-radius, 40-foot-high cylinder centered on a point within range must make a DEX save. A creature takes 4d6 fire damage and 4d6 radiant damage on a failed save, or half as much damage on a success.

_At Higher Circles._ When you cast this spell using a spell slot of 6th circle or higher, the fire damage or the radiant damage (your choice) increases by 1d6 for each slot above 5th.

#### Flaming Sphere

_2nd-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a bit of tallow, a pinch of brimstone, and a dusting of powdered iron)
**Duration:** Concentration, up to 1 minute

A 5-foot-diameter sphere of fire appears in an unoccupied space of your choice within range and lasts for the duration.

Any creature that ends its turn within 5 feet of the sphere must make a DEX save. The creature takes 2d6 fire damage on a failed save, or half as much damage on a successful one.

As a bonus action, you can move the sphere up to 30 feet.

If you ram the sphere into a creature, that creature must make the save against the sphere's damage, and the sphere stops moving this turn.

When you move the sphere, you can direct it over barriers up to 5 feet tall and jump it across pits up to 10 feet wide.

The sphere ignites flammable objects not being worn or carried, and it sheds bright light in a 20-foot radius and dim light for an additional 20 feet.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, the damage increases by 1d6 for each slot above 2nd.

#### Flesh To Stone

_6th-Circle Divine (Transmutation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a pinch of lime, water, and earth)
**Duration:** Concentration, up to 1 minute

You attempt to turn one creature that you can see within range into stone. If the target's body is made of flesh, the creature must make a CON save. On a failed save, it is restrained as its flesh begins to harden. On a successful save, the creature isn't affected.

A creature restrained by this spell must make another CON save at the end of each of its turns. If it successfully saves against this spell three times, the spell ends. If it fails its saves three times, it is turned to stone and subjected to the petrified condition for the duration. The successes and failures don't need to be consecutive; keep track of both until the target collects three of a kind.

If the creature is physically broken while petrified, it suffers from similar damage if it reverts to its original state, automatically dying if it can't survive without the damaged body part (such as the head or other area of the body with vital organs).

If you maintain your concentration on this spell for the entire possible duration, the creature is turned to stone until the effect is removed.

#### Floating Disk

_1st-Circle Arcane (Conjuration)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a drop of mercury)
**Duration:** 1 hour

This spell creates a circular, horizontal plane of force 3 feet in diameter and 1 inch thick that floats 3 feet above the ground in an unoccupied space of your choice that you can see within range. The disk remains for the duration and can hold up to 500 pounds. If more weight is placed on it, the spell ends, and everything on the disk falls to the ground.

The disk is immobile while you are within 20 feet of it. If you move more than 20 feet away from it, the disk follows you so that it remains within 20 feet of you. It can move across uneven terrain, up or down stairs, slopes, and the like, but it can't cross an elevation change of 10 feet or more. For example, the disk can't move across a 10-foot-deep pit, nor could it leave such a pit if it was created at the bottom.

If you move more than 100 feet from the disk (typically because it can't move around an obstacle to follow you), the spell ends.

#### Fly

_3rd-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a wing feather from any bird)
**Duration:** Concentration, up to 10 minutes

You touch a willing creature. The target gains a flying speed of 60 feet for the duration. When the spell ends, the target falls if it is still aloft, unless it can stop the fall.

_At Higher Circles._ When you cast this spell using a 4th-circle spell slot or higher, you can target one additional creature for each slot above 3rd.

#### Fog Cloud

_1st-Circle Arcane and Primordial (Conjuration)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** Concentration, up to 1 hour

You create a 20-foot-radius sphere of fog centered on a point within range. The sphere spreads around corners, and its area is heavily obscured. It lasts for the duration or until a wind of moderate or greater speed (at least 10 miles per hour) disperses it.

_At Higher Circles._ When you cast this spell using a 2ndcircle spell slot or higher, the radius of the fog increases by 20 feet for each slot above 1st.

#### Forcecage

_7th-Circle Arcane and Wyrd (Evocation)_

**Casting Time:** 1 action
**Range:** 100 feet
**Components:** V, S, M (ruby dust worth at least 1,500 gp)
**Duration:** Concentration, up to 1 hour

An immobile, invisible, cube-shaped prison composed of magical force springs into existence around an area you choose within range. The prison can be a cage or a solid box (your choice).

A prison in the shape of a cage can be up to 20 feet on a side and is made from 1/2-inch-diameter bars spaced 1/2 inch apart.

A prison in the shape of a box can be up to 10 feet on a side, creating a solid barrier that prevents any matter from passing through it and blocking any spells cast into or out from the area.

When you cast the spell, any creature that is completely inside the cage's area is trapped. Creatures only partially within the area and those too large to fit inside the area are pushed away from the center of the area until they are completely outside it.

A creature inside the cage can't leave it by nonmagical means. If the creature tries to use a spell or any other magical means of teleportation or interplanar travel to leave the cage, it must first make a CHA save. On a success, the creature can use that magic to exit the cage. On a failure, the creature can't exit the cage and wastes the use of the spell or effect. The cage also extends into the Ethereal Plane, blocking ethereal travel.

This spell can't be dispelled by dispel magic.

#### Four Winds

_7th-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V, S, M (an ivory war horn or set of pipes worth at least 500 gp)
**Duration:** 1 minute

You stir the air to create four whirlwinds on the ground at points you can see within range. Each whirlwind is a 5-footradius, 30-foot-tall cylinder of swirling air centered on that point. The whirlwinds last for the duration of the spell.

Each creature that enters a space occupied by a whirlwind for the first time on a turn (including when the whirlwinds first appear) or starts its turn in a space occupied by a whirlwind must make a STR save. On a failed save, a Large or smaller creature takes 4d10 bludgeoning damage and is thrown up to 60 feet in a random direction and knocked prone. On a failed save, a Huge or larger creature takes the bludgeoning damage and is not thrown but is restrained until the beginning of its next turn. On a successful save, creatures of any size take only half as much damage and are pushed out of the whirlwind into a random unoccupied space within 5 feet of the whirlwind.

If a thrown creature strikes a solid surface, it takes 1d6 bludgeoning damage for every 10 feet it is thrown. If the creature is thrown at another creature, the hit creature must succeed on a DEX save against your spell save DC or take the same damage as the thrown creature and be knocked prone. If a thrown creature is thrown into another whirlwind, it is then thrown from the new whirlwind up to 60 feet again in a random direction.

At the start of each of your turns after the whirlwinds first appear, you can use your action to control them, moving each one up to 30 feet in a direction you choose. If you can't use your action or choose not to use your action to control the whirlwinds, each whirlwind moves up to 30 feet in a random direction, potentially affecting you along with any other creatures it encounters. If multiple whirlwinds would end their turn in the same space or overlapping spaces, one whirlwind moves to the space, and the other moves to the nearest adjacent space not occupied by a whirlwind.

You can use an action to end the spell early, which causes the whirlwinds to disappear. The spell also ends early if you are incapacitated or die.

#### Freedom Of Movement

_4th-Circle Arcane and Divine (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a leather strap, bound around the arm or a similar appendage)
**Duration:** 1 hour

You touch a willing creature. For the duration, the target's movement is unaffected by difficult terrain, and spells and other magical effects can neither reduce the target's speed nor cause the target to be paralyzed or restrained.

The target can also spend 5 feet of movement to automatically escape from nonmagical restraints, such as manacles or a creature that has it grappled. Finally, being underwater imposes no penalties on the target's movement or attacks.

#### Freezing Sphere

_6th-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 300 feet (60-foot-radius sphere) **Components:** V, S, M (a small crystal sphere)
**Duration:** Instantaneous

A frigid globe of cold energy streaks from your fingertips to a point of your choice within range, where it explodes in a 60-foot-radius sphere. Each creature within the area must make a CON save. A creature takes 10d6 cold damage on a failed save, or half as much damage on a successful one.

If the globe strikes a body of water or a liquid that is principally water (not including water-based creatures), it freezes the liquid to a depth of 6 inches over an area 30 feet square. This ice lasts for 1 minute. Creatures that were swimming on the surface of frozen water are trapped in the ice. A trapped creature can use an action to make a STR check against your spell save DC to break free.

You can refrain from firing the globe after completing the spell, if you wish. A small globe about the size of a sling stone, cool to the touch, appears in your hand. At any time, you, or a creature you give the globe to, can throw the globe (to a range of 40 feet) or hurl it with a sling (to the sling's normal range). It shatters on impact, with the same effect as the normal casting of the spell. You can also set the globe down without shattering it. After 1 minute, if the globe hasn't already shattered, it explodes.

_At Higher Circles._ When you cast this spell using a spell slot of 7th circle or higher, the damage increases by 1d6 for each slot above 6th.

### G

#### Gaseous Form

_3rd-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a bit of gauze and a wisp of smoke)
**Duration:** Concentration, up to 1 hour

You transform a willing creature you touch, along with everything it's wearing and carrying, into a misty cloud for the duration. The spell ends if the creature drops to 0 HP.

An incorporeal creature isn't affected.

While in this form, the target's only method of movement is a flying speed of 10 feet. The target can enter and occupy the space of another creature. The target has resistance to damage from nonmagical attacks, and it has advantage on STR, DEX, and CON saves. The target can pass through small holes, narrow openings, and even mere cracks, though it treats liquids as though they were solid surfaces.

The target can't fall and remains hovering in the air even when stunned or otherwise incapacitated.

While in the form of a misty cloud, the target can't talk or manipulate objects, and any objects it was carrying or holding can't be dropped, used, or otherwise interacted with. The target can't attack or cast spells.

#### Gate

_9th-Circle Arcane and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a diamond worth at least 5,000 gp)
**Duration:** Concentration, up to 1 hour

You conjure a portal linking an unoccupied space you can see within range to a precise location on a different plane of existence. The portal is a circular opening, which you can make 5 to 20 feet in diameter. You can orient the portal in any direction you choose. The portal lasts for the duration.

The portal has a front and a back on each plane where it appears. Travel through the portal is possible only by moving through its front. Anything that does so is instantly transported to the other plane, appearing in the unoccupied space nearest to the portal.

Deities and other planar rulers can prevent portals created by this spell from opening in their presence or anywhere within their domains.

When you cast this spell, you can speak the name of a specific creature (a pseudonym, title, or nickname doesn't work). If that creature is on a plane other than the one you are on, the portal opens in the named creature's immediate vicinity and draws the creature through it to the nearest unoccupied space on your side of the portal. You gain no special power over the creature, and it is free to act as the GM deems appropriate. It might leave, attack you, or help you.

#### Gentle Repose

_2nd-Circle Divine (Necromancy)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a pinch of salt and one copper piece placed on each of the corpse's eyes, which must remain there for the duration)
**Duration:** 10 days

You touch a corpse or other remains. For the duration, the target is protected from decay and can't become Undead.

The spell also effectively extends the time limit on raising the target from the dead, since days spent under the influence of this spell don't count against the time limit of spells such as raise dead.

#### Giant Insect

_4th-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You transform up to ten centipedes, three spiders, five wasps, or one scorpion within range into giant versions of their natural forms for the duration. A centipede becomes a giant centipede, a spider becomes a giant spider, a wasp becomes a giant wasp, and a scorpion becomes a giant scorpion.

Each creature obeys your verbal commands, and in combat, they act on your turn each round. The GM has the statistics for these creatures and resolves their actions and movement.

A creature remains in its giant size for the duration, until it drops to 0 HP, or until you use an action to dismiss the effect on it.

The GM might allow you to choose different targets. For example, if you transform a bee, its giant version might have the same statistics as a giant wasp.

#### Glibness

_8th-Circle Arcane and Divine (Transmutation)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V
**Duration:** Concentration, up to 1 hour

Until the spell ends, when you make a CHA ability check or save, you can replace the number you roll with a 15.

In addition, no matter what you say, magic that would determine if you are telling the truth indicates that you are being truthful.

#### Globe Of Invulnerability

_6th-Circle Arcane (Abjuration)_

**Casting Time:** 1 action
**Range:** Self (10-foot radius)
**Components:** V, S, M (a glass or crystal bead that shatters when the spell ends)
**Duration:** Concentration, up to 1 minute

An immobile, faintly shimmering barrier springs into existence in a 10-foot radius around you and remains for the duration.

Spell attacks that originate from a creature outside the barrier or any spell of 5th circle or lower cast from outside the barrier can't affect creatures or objects within it, even if the spell is cast using a higher circle spell slot. Such a spell attack or spell can target creatures and objects within the barrier, but the spell attack or spell has no effect on them.

Similarly, the area within the barrier is excluded from the areas affected by such spells.

_At Higher Circles._ When you cast this spell using a spell slot of 7th circle or higher, the barrier blocks spells of one circle higher for each slot above 6th.

#### Goodberry

_1st-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a handful of berries)
**Duration:** Instantaneous

You transform up to ten berries in your hand, infusing them with magic for up to 24 hours. A creature can use its action to eat one berry. Eating a berry restores 1 HP and provides enough nourishment to sustain a creature for one day, though a creature can't be sustained by eating berries two or more days in a row.

The berries lose their potency if they have not been consumed within 24 hours of the casting of this spell.

#### Grave Touch

_Arcane and Wyrd Cantrip (Necromancy)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** 1 round

You create a ghostly, skeletal hand in the space of a creature within range. Make a ranged spell attack against the creature to assail it with the chill of the grave. On a hit, the target takes 1d8 necrotic damage, and it can't regain hit points until the start of your next turn. Until then, the hand clings to the target.

If you hit an Undead target with this attack, it also has disadvantage on attack rolls against you until the end of your next turn.

This spell's damage increases by 1d8 when you reach 5th level (2d8), 11th level (3d8), and 17th level (4d8).

#### Grease

_1st-Circle Arcane (Conjuration)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a bit of pork rind or butter)
**Duration:** 1 minute

Slick grease covers the ground in a 10-foot square centered on a point within range and turns it into difficult terrain for the duration.

When the grease appears, each creature standing in its area must succeed on a DEX save or fall prone. A creature that enters the area or ends its turn there must also succeed on a DEX save or fall prone.

#### Greater Dominate

_8th-Circle Arcane and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 1 hour

You attempt to beguile any creature that you can see within range. This spell has no effect on creatures immune to the charmed condition. The target must succeed on a WIS save or be charmed by you for the duration. If you or creatures that are friendly to you are fighting it, it has advantage on the save.

While the creature is charmed, you have a telepathic link with it as long as the two of you are on the same plane of existence. You can use this telepathic link to issue commands to the creature while you are conscious (no action required), which it does its best to obey. You can specify a simple and general course of action, such as "attack that creature," "run over there," or "fetch that object." If the creature completes the order and doesn't receive further direction from you, it defends and preserves itself to the best of its ability.

You can use your action to take total and precise control of the target. Until the end of your next turn, the creature takes only the actions you choose and doesn't do anything that you don't allow it to do.

During this time, you can also cause the creature to use a reaction, but this requires you to use your own reaction as well.

Each time the target takes damage, it makes a new WIS save against the spell, ending the spell on a success.

_At Higher Circles._ When you cast this spell with a 9th-circle spell slot, the duration is concentration, up to 8 hours.

#### Greater Hold

_5th-Circle Arcane, Divine, and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V, S, M (a small, straight piece of iron)
**Duration:** Concentration, up to 1 minute

Choose any creature that you can see within range. The target must succeed on a WIS save or be paralyzed for the duration. At the end of each of its turns, an affected target can repeat the WIS save, ending the effect on itself on a success. This spell has no effect on Undead.

_At Higher Circles._ When you cast this spell using a spell slot of 6th circle or higher, you can target one additional creature for each slot above 5th. The creatures must be within 30 feet of each other when you target them.

#### Greater Invisibility

_4th-Circle Arcane and Wyrd (Illusion)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** Concentration, up to 1 minute

You or a creature you touch becomes invisible until the spell ends. Anything the target is wearing or carrying is invisible as long as it is on the target's person.

#### Greater Restoration

_5th-Circle Divine and Primordial (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (diamond dust worth at least 100 gp, which the spell consumes)
**Duration:** Instantaneous

You imbue a creature you touch with positive energy to undo a debilitating effect. You can reduce the target's exhaustion level by one or end one of the following effects on the target:

- One effect that charmed or petrified the target

- One curse, including the target's attunement to a cursed magic item
- Any reduction to one of the target's ability scores

- One effect reducing the target's hit point maximum #### Guardian Of Faith

_4th-Circle Divine (Conjuration)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V
**Duration:** 8 hours

A Large spectral guardian appears and hovers for the duration in an unoccupied space of your choice that you can see within range. The guardian occupies that space and is indistinct except for a gleaming sword and shield emblazoned with the symbol of your faith.

Any creature hostile to you that moves to a space within 10 feet of the guardian for the first time on a turn must succeed on a DEX save. The creature takes 20 radiant damage on a failed save, or half as much damage on a successful one. The guardian vanishes when it has dealt a total of 60 damage.

#### Guidance

_Divine and Wyrd Cantrip (Divination)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** Concentration, up to 1 minute

You touch one willing creature. Once before the spell ends, the target can roll a d4 and add the number rolled to one ability check of its choice. It can roll the die before or after making the ability check. The spell then ends.

#### Guiding Bolt

_1st-Circle Divine and Wyrd (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** 1 round

A flash of light streaks toward a creature of your choice within range. Make a ranged spell attack against the target.

On a hit, the target takes 4d6 radiant damage, and the next attack roll made against this target before the end of your next turn has advantage, thanks to the mystical dim light glittering on the target until then.

_At Higher Circles._ When you cast this spell using a 2nd-circle spell slot or higher, the damage increases by 1d6 for each slot above 1st.

#### Gust Of Wind

_2nd-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** Self (60-foot line)
**Components:** V, S, M (a legume seed)
**Duration:** Concentration, up to 1 minute

A line of strong wind 60 feet long and 10 feet wide blasts from you in a direction you choose for the spell's duration.

Each creature that starts its turn in the line must succeed on a STR save or be pushed 15 feet away from you in a direction following the line.

Any creature in the line must spend 2 feet of movement for every 1 foot it moves when moving closer to you.

The gust disperses gas or vapor, and extinguishes candles, torches, and similar unprotected flames in the area. It causes protected flames, such as those of lanterns, to dance wildly and has a 50 percent chance to extinguish them.

As a bonus action on each of your turns before the spell ends, you can change the direction in which the line blasts from you.

### H

#### Harm

_6th-Circle Divine and Wyrd (Necromancy)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

You unleash a virulent disease on a creature that you can see within range. The target must make a CON save. On a failure, it takes 14d6 necrotic damage, or half as much damage on a success. The damage can't reduce the target's hit points below 1. If the target fails the save, its hit point maximum is reduced for 1 hour by an amount equal to the necrotic damage it took. Any effect that removes a disease allows a creature's hit point maximum to return to normal before that time passes.

#### Haste

_3rd-Circle Arcane (Transmutation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a shaving of licorice root)
**Duration:** Concentration, up to 1 minute

Choose a willing creature that you can see within range.

Until the spell ends, the target's speed is doubled, it gains a +2 bonus to AC, it has advantage on DEX saves, and it gains an additional action on each of its turns. That action can be used only to take the Attack (one weapon attack only), Dash, Disengage, Hide, or Use an Object action.

When the spell ends, the target can't move or take actions until after its next turn, as a wave of lethargy sweeps over it.

#### Heal

_6th-Circle Divine and Primordial (Necromancy)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

Choose a creature that you can see within range. A surge of positive energy washes through the creature, causing it to regain 70 HP. This spell also ends blindness, deafness, and any diseases affecting the target. This spell has no effect on Constructs or Undead.

_At Higher Circles._ When you cast this spell using a spell slot of 7th circle or higher, the amount of healing increases by 10 HP for each slot above 6th.

#### Healing Word

_1st-Circle Divine (Necromancy)_

**Casting Time:** 1 bonus action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

A creature of your choice that you can see within range regains hit points equal to 1d4 + your spellcasting ability modifier. This spell has no effect on Constructs or Undead.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, the healing increases by 1d4 for each slot above 1st.

#### Heat Metal

_2nd-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a piece of iron and a flame)
**Duration:** Concentration, up to 1 minute

Choose a manufactured metal object (not a creature), such as a metal weapon or a suit of armor that lacks the Natural Materials property, that you can see within range. You cause the object to glow red-hot. Any creature in physical contact with the object takes 2d8 fire damage when you cast the spell. Until the spell ends, you can use a bonus action on each of your subsequent turns to cause this damage again.

If a creature is holding or wearing the object and takes damage from it, the creature must succeed on a CON save or drop the object if it can. If it doesn't drop the object, it has disadvantage on attack rolls and ability checks until the start of your next turn.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, the damage increases by 1d8 for each slot above 2nd.

#### Hellish Rebuke

_1st-Circle Wyrd (Evocation)_

**Casting Time:** 1 reaction, when damaged by a creature within 60 feet of you that you can see **Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

You point your finger, and the creature that damaged you is momentarily surrounded by hellish flames. The creature must make a DEX save. It takes 2d10 fire damage on a failed save, or half as much damage on a successful one.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, the damage increases by 1d10 for each slot above 1st.

#### Heroism

_1st-Circle Divine (Enchantment)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** Concentration, up to 1 minute

A willing creature you touch is imbued with bravery. Until the spell ends, the creature is immune to being frightened and gains temporary hit points equal to your spellcasting ability modifier at the start of each of its turns. When the spell ends, the target loses any remaining temporary hit points from this spell.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, you can target one additional creature for each slot above 1st.

#### Hideous Laughter

_1st-Circle Arcane and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (tiny tarts and a feather that is waved in the air)
**Duration:** Concentration, up to 1 minute

A creature of your choice that you can see within range perceives everything as hilariously funny and falls into fits of laughter if this spell affects it. The target must succeed on a WIS save or fall prone, becoming incapacitated and unable to stand up for the duration. A creature with an INT of 3 (-4) or lower isn't affected by this spell.

At the end of each of its turns and each time it takes damage, the target can make another WIS save, ending the spell on a success. The target has advantage on the save if it's triggered by damage.

#### Hold

_2nd-Circle Arcane, Divine, and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a small, straight piece of iron)
**Duration:** Concentration, up to 1 minute

Choose a Medium or smaller creature that you can see within range. The target must succeed on a WIS save or be paralyzed for the duration. At the end of each of its turns, an affected target can repeat the WIS save, ending the effect on itself on a success. This spell has no effect on Undead.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, you can target one additional creature for each slot above 2nd. The creatures must be within 30 feet of each other when you target them.

#### Holy Aura

_8th-Circle Divine (Abjuration)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S, M (a tiny reliquary worth at least 1,000 gp containing a sacred relic, such as a scrap of cloth from a saint's robe)
**Duration:** Concentration, up to 1 minute

Divine light washes out from you and coalesces in a soft radiance in a 30-foot radius around you. Creatures of your choice in that radius when you cast this spell shed dim light in a 5-foot radius and have advantage on all saves, and other creatures have disadvantage on attack rolls against them until the spell ends. In addition, when a Fiend or an Undead hits an affected creature with a melee attack, the aura flashes with brilliant light. The attacker must succeed on a CON save or be blinded until the spell ends.

#### Hypnotic Pattern

_3rd-Circle Arcane and Wyrd (Illusion)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** S, M (a glowing stick of incense or a crystal vial filled with phosphorescent material)
**Duration:** Concentration, up to 1 minute

You create a twisting pattern of colors that weaves through the air inside a 30-foot cube within range. The pattern appears for a moment and vanishes. Each creature in the area who sees the pattern must make a WIS save. On a failure, the creature becomes charmed for the duration.

While charmed by this spell, the creature is incapacitated and has a speed of 0.

The spell ends for an affected creature if it takes any damage or if someone else uses an action to shake the creature out of its stupor.

### I

#### Ice Storm

_4th-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 300 feet
**Components:** S, M (a pinch of dust and a few drops of water)
**Duration:** Instantaneous

A hail of rock-hard ice pounds to the ground in a 20-footradius, 40-foot-high cylinder centered on a point within range. Each creature in the cylinder must make a DEX save. A creature takes 2d8 bludgeoning damage and 4d6 cold damage on a failed save, or half as much damage on a successful one.

Hailstones turn the storm's area of effect into difficult terrain until the end of your next turn.

_At Higher Circles._ When you cast this spell using a spell slot of 5th circle or higher, the bludgeoning damage increases by 1d8 for each slot above 4th.

#### Incendiary Cloud

_8th-Circle Arcane (Conjuration)_

**Casting Time:** 1 action
**Range:** 150 feet (20-foot-radius sphere) **Components:** V, S
**Duration:** Concentration, up to 1 minute

A swirling cloud of smoke shot through with white-hot embers appears in a 20-foot-radius sphere centered on a point within range. The cloud spreads around corners and is heavily obscured. It lasts for the duration or until a wind of moderate or greater speed (at least 10 miles per hour) disperses it.

When the cloud appears, each creature in it must make a DEX save. A creature takes 10d8 fire damage on a failed save, or half as much damage on a successful one. A creature must also make this save when it enters the spell's area for the first time on a turn or ends its turn there.

The cloud moves 10 feet directly away from you in a direction that you choose at the start of each of your turns.

#### Inflict Wounds

_1st-Circle Divine and Wyrd (Necromancy)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** Instantaneous

Make a melee spell attack against a creature you can reach.

On a hit, the target takes 3d10 necrotic damage.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, the damage increases by 1d10 for each slot above 1st.

#### Insect Plague

_5th-Circle Primordial (Conjuration)_

**Casting Time:** 1 action
**Range:** 300 feet
**Components:** V, S, M (a few grains of sugar, some kernels of grain, and a smear of fat)
**Duration:** Concentration, up to 10 minutes

Swarming, biting locusts fill a 20-foot-radius sphere centered on a point you choose within range. The sphere spreads around corners. The sphere remains for the duration, and its area is lightly obscured. The sphere's area is difficult terrain.

When the area appears, each creature in it must make a CON save. A creature takes 4d10 piercing damage on a failed save, or half as much damage on a successful one. A creature must also make this save when it enters the spell's area for the first time on a turn or ends its turn there.

_At Higher Circles._ When you cast this spell using a spell slot of 6th circle or higher, the damage increases by 1d10 for each slot above 5th.

#### Invisibility

_2nd-Circle Arcane and Wyrd (Illusion)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (an eyelash encased in tree sap)
**Duration:** Concentration, up to 1 hour

A creature you touch becomes invisible until the spell ends. Anything the target is wearing or carrying is invisible as long as it is on the target's person. The spell ends for a target that attacks or casts a spell.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, you can target one additional creature for each slot above 2nd.

#### Irresistible Dance

_6th-Circle Arcane and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V
**Duration:** Concentration, up to 1 minute

Choose one creature that you can see within range. The target begins a comic dance in place: shuffling, tapping its feet, and capering for the duration. Creatures that can't be charmed are immune to this spell.

A dancing creature must use all its movement to dance without leaving its space and has disadvantage on DEX saves and attack rolls. While the target is affected by this spell, other creatures have advantage on attack rolls against it. As an action, a dancing creature can make a WIS save to regain control of itself. On a successful save, the spell ends.

### K

#### Knock

_2nd-Circle Arcane (Transmutation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

Choose an object that you can see within range. The object can be a door, a box, a chest, a set of manacles, a padlock, or another object that contains a mundane or magical means that prevents access.

A target that is held shut by a mundane lock or that is stuck or barred becomes unlocked, unstuck, or unbarred. If the object has multiple locks, only one of them is unlocked.

If you choose a target that is held shut with arcane lock, that spell is suppressed for 10 minutes, during which time the target can be opened and shut normally.

When you cast the spell, a loud knock, audible from as far away as 300 feet, emanates from the target object.

### L

#### Legend Lore

_5th-Circle Arcane and Divine (Divination)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S, M (incense worth at least 250 gp, which the spell consumes)
**Duration:** Instantaneous

Name or describe a person, place, or object. The spell brings to your mind a brief summary of the significant lore about the thing you named. The lore might consist of current tales, forgotten stories, or even secret lore that has never been widely known. If the thing you named isn't of legendary importance, you gain no information. The more information you already have about the thing, the more precise and detailed the information you receive is.

The information you learn is accurate but might be couched in figurative language. For example, if you have a mysterious magic axe on hand, the spell might yield this information: "Woe to the evildoer whose hand touches the axe, for even the haft slices the hand of the evil ones. Only a true Child of Stone, lover and beloved of the dwarven gods, may awaken the true powers of the axe, and only with the sacred word Rudnoss on the lips."

#### Levitate

_2nd-Circle Arcane (Transmutation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a small leather loop or a piece of golden wire with a long shank on one end)
**Duration:** Concentration, up to 10 minutes

One creature or object of your choice that you can see within range rises vertically, up to 20 feet, and remains suspended there for the duration. The spell can levitate a target that weighs up to 500 pounds. An unwilling creature that succeeds on a CON save is unaffected.

The target can move only by pushing or pulling against a fixed object or surface within reach (such as a wall or a ceiling), which allows it to move as if it were climbing. You can change the target's altitude by up to 20 feet in either direction on your turn. If you are the target, you can move up or down as part of your move. Otherwise, you can use your action to move the target, which must remain within the spell's range.

When the spell ends, the target floats gently to the ground if it is still aloft.

#### Light

_Arcane and Divine Cantrip (Evocation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a firefly or phosphorescent moss)
**Duration:** 1 hour

You touch one object that is no larger than 10 feet in any dimension. Until the spell ends, the object sheds bright light in a 20-foot radius and dim light for an additional 20 feet. The light can be colored as you like. Completely covering the object with something opaque blocks the light.

The spell ends if you cast it again or dismiss it as an action.

If you target an object held or worn by a hostile creature, that creature must succeed on a DEX save to avoid the spell.

#### Lightning Bolt

_3rd-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** Self (100-foot line)
**Components:** V, S, M (a bit of fur and a rod of amber, crystal, or glass)
**Duration:** Instantaneous

A stroke of lightning forming a line 100 feet long and 5 feet wide blasts out from you in a direction you choose. Each creature in the line must make a DEX save. A creature takes 8d6 lightning damage on a failed save, or half as much damage on a successful one.

The lightning ignites flammable objects in the area that aren't being worn or carried.

_At Higher Circles._ When you cast this spell using a spell slot of 4th circle or higher, the damage increases by 1d6 for each slot above 3rd.

#### Longstrider

_1st-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a pinch of dirt)
**Duration:** 1 hour

You touch a creature. Its speed increases by 10 feet and its jump distance is tripled until the spell ends.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, you can target one additional creature for each slot above 1st.

### M

#### Mage Armor

_1st-Circle Arcane (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a piece of cured leather)
**Duration:** 8 hours

You touch a willing creature who isn't wearing armor, and a protective magical force surrounds it until the spell ends.

The target's base AC becomes 13 + its DEX modifier. The spell ends if the target dons armor or if you dismiss the spell as an action.

#### Mage Hand

_Arcane and Wyrd Cantrip (Conjuration)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S
**Duration:** 1 minute

A spectral, floating hand appears at a point you choose within range. The hand lasts for the duration or until you dismiss it as an action. The hand vanishes if it is ever more than 30 feet away from you or if you cast this spell again.

You can use your action to control the hand. You can use the hand to manipulate an object, open an unlocked door or container, stow or retrieve an item from an open container, or pour the contents out of a vial. You can move the hand up to 30 feet each time you use it.

The hand can't attack, activate magic items, or carry more than 10 pounds.

#### Magic Missile

_1st-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** Instantaneous

You create three darts that each hit a creature of your choice you can see within range. You can choose whether the darts hit the same creature or different creatures. Each dart deals 1d4 + 1 force damage to its target.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, it creates one additional dart for each slot above 1st.

#### Magic Weapon

_2nd-Circle Arcane and Wyrd (Transmutation)_

**Casting Time:** 1 bonus action
**Range:** Touch
**Components:** V, S
**Duration:** Concentration, up to 1 hour

You touch a nonmagical weapon. Until the spell ends, that weapon becomes a magic weapon with a +1 bonus to attack rolls and damage rolls.

_At Higher Circles._ When you cast this spell using a spell slot of 4th circle or higher, the bonus increases to +2. When you use a spell slot of 6th circle or higher, the bonus increases to +3.

#### Major Image

_3rd-Circle Arcane and Wyrd (Illusion)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (a bit of fleece)
**Duration:** Concentration, up to 10 minutes

You create the image of an object, a creature, or some other visible phenomenon that is no larger than a 20-foot cube. The image appears at a spot that you can see within range and lasts for the duration. It seems completely real, including sounds, smells, and temperature appropriate to the thing depicted. You can't create sufficient heat or cold to cause damage, a sound loud enough to deal thunder damage or deafen a creature, or a smell that might sicken a creature (like a troglodyte's stench).

As long as you are within range of the illusion, you can use your action to cause the image to move to any other spot within range. As the image changes location, you can alter its appearance so that its movements appear natural for the image. For example, if you create an image of a creature and move it, you can alter the image so that it appears to be walking. Similarly, you can cause the illusion to make different sounds at different times, even making it carry on a conversation, for example.

Physical interaction with the image reveals it to be an illusion, because things can pass through it. A creature that uses its action to examine the image can determine that it is an illusion with a successful INT (Investigation) check against your spell save DC. If a creature discerns the illusion for what it is, the creature can see through the image, and its other sensory qualities become faint to the creature.

_At Higher Circles._ When you cast this spell using a spell slot of 6th circle or higher, the spell lasts until dispelled, without requiring your concentration.

#### Mass Cure Wounds

_5th-Circle Divine and Primordial (Necromancy)_

**Casting Time:** 1 action
**Range:** 60 feet (30-foot-radius sphere) **Components:** V, S
**Duration:** Instantaneous

A wave of healing energy washes out from a point of your choice within range. Choose up to six creatures in a 30-foot-radius sphere centered on that point. Each target regains hit points equal to 3d8 + your spellcasting ability modifier. This spell has no effect on Constructs or Undead.

_At Higher Circles._ When you cast this spell using a spell slot of 6th circle or higher, the healing increases by 1d8 for each slot above 5th.

#### Mass Faerie Fire

_4th-Circle Wyrd (Evocation)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V
**Duration:** Concentration, up to 1 minute

You can place up to three 20-foot cubes each centered on a point you can see within range. Each object in a cube is outlined in blue, green, or violet light (your choice). Any creature in a cube when the spell is cast is also outlined in light if it fails a DEX save. A creature in the area of more than one cube is affected only once. For the duration, each affected object and creature sheds dim light in a 10-foot radius for the duration.

Any attack roll against an affected creature or object has advantage if the attacker can see it, and the affected creature or object can't benefit from being invisible.

#### Mass Heal

_9th-Circle Divine and Primordial (Necromancy)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

A flood of healing energy flows from you into injured creatures around you. You restore up to 700 HP, divided as you choose among any number of creatures that you can see within range. Creatures healed by this spell are also cured of all diseases and any effect making them blinded or deafened. This spell has no effect on Constructs or Undead.

#### Mass Healing Word

_3rd-Circle Divine (Necromancy)_

**Casting Time:** 1 bonus action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

As you call out words of restoration, up to six creatures of your choice that you can see within range regain hit points equal to 1d4 + your spellcasting ability modifier. This spell has no effect on Constructs or Undead.

_At Higher Circles._ When you cast this spell using a spell slot of 4th circle or higher, the healing increases by 1d4 for each slot above 3rd.

#### Mass Suggestion

_6th-Circle Arcane and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, M (a snake's tongue and either a bit of honeycomb or a drop of sweet oil)
**Duration:** 24 hours

You suggest a course of activity (limited to a sentence or two) and magically influence up to twelve creatures of your choice that you can see within range and that can hear and understand you. Creatures that can't be charmed are immune to this effect. The suggestion must be worded in such a manner as to make the course of action sound reasonable. Asking the creature to stab itself, throw itself onto a spear, immolate itself, or do some other obviously harmful act automatically negates the effect of the spell.

Each target must make a WIS save. On a failed save, it pursues the course of action you described to the best of its ability. The suggested course of action can continue for the entire duration. If the suggested activity can be completed in a shorter time, the spell ends when the subject finishes what it was asked to do.

You can also specify conditions that will trigger a special activity during the duration. For example, you might suggest that a group of soldiers give all their money to the first beggar they meet. If the condition isn't met before the spell ends, the activity isn't performed.

If you or any of your companions damage a creature affected by this spell, the spell ends for that creature.

_At Higher Circles._ When you cast this spell using a 7th-circle spell slot, the duration is 10 days. When you use an 8thcircle spell slot, the duration is 30 days. When you use a 9th-circle spell slot, the duration is a year and a day.

#### Maze

_8th-Circle Arcane and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You banish a creature that you can see within range into a labyrinthine demiplane. The target remains there for the duration or until it escapes the maze. The target can use its action to attempt to escape. When it does so, it makes a DC 20 INT check. If it succeeds, it escapes, and the spell ends.

When the spell ends, the target reappears in the space it left or, if that space is occupied, in the nearest unoccupied space.

#### Meld Into Stone

_3rd-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** 8 hours

You step into a stone object or surface large enough to fully contain your body, melding yourself and all the equipment you carry with it for the duration. Using your movement, you step into the stone at a point you can touch. Nothing of your presence remains visible or otherwise detectable by nonmagical senses.

While merged with the stone, you can't see what occurs outside it, and any WIS (Perception) checks you make to hear sounds outside it are made with disadvantage. You remain aware of the passage of time and can cast spells on yourself while merged in the stone. You can use your movement to leave the stone where you entered it, which ends the spell. Otherwise, you can't move.

Minor physical damage to the stone doesn't harm you, but its partial destruction or a change in its shape (to the extent that you no longer fit within it) expels you and deals 6d6 bludgeoning damage to you. The stone's complete destruction (or transmutation into a different substance) expels you and deals 50 bludgeoning damage to you. If expelled, you fall prone in an unoccupied space closest to where you first entered.

#### Mending

_Arcane and Divine Cantrip (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (two lodestones)
**Duration:** Instantaneous

This spell repairs a single break or tear in an object you touch, such as a broken chain link, two halves of a broken key, a torn cloak, or a leaking wineskin. As long as the break or tear is no larger than 1 foot in any dimension, you mend it, leaving no trace of the former damage. If this spell is used to repair an object with hit points, it can restore up to 1 HP per casting but can't raise an object's hit points to more than half its hit point maximum.

This spell can cosmetically repair a magic item or Construct, but the spell can't restore magic or hit points to such targets.

#### Message

_Arcane and Wyrd Cantrip (Enchantment)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (a short piece of copper wire)
**Duration:** 1 round

You point your finger toward a creature within range and whisper a message. The target (and only the target) hears the message and can reply in a whisper that only you can hear.

You can cast this spell through solid objects if you are familiar with the target and know it is beyond the barrier.

Magical silence, 1 foot of stone, 1 inch of common metal, a thin sheet of lead, or 3 feet of wood blocks the spell. The spell doesn't have to follow a straight line and can travel freely around corners or through openings.

#### Meteor Swarm

_9th-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 1 mile (40-foot-radius sphere) **Components:** V, S
**Duration:** Instantaneous

Blazing orbs of fire plummet to the ground at four different points you can see within range. Each creature in a 40-footradius sphere centered on each point you choose must make a DEX save. The sphere spreads around corners. A creature takes 20d6 fire damage and 20d6 bludgeoning damage on a failed save, or half as much damage on a successful one. A creature in the area of more than one fiery burst is affected only once.

The spell damages objects in the area and ignites flammable objects that aren't being worn or carried.

#### Mind Blank

_8th-Circle Arcane (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** 24 hours

Until the spell ends, one willing creature you touch is immune to psychic damage, any effect that would sense its emotions or read its thoughts, divination spells, and the charmed condition. The spell even foils wish spells and spells or effects of similar power used to affect the target's mind or to gain information about the target.

#### Minor Illusion

_Arcane and Wyrd Cantrip (Illusion)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** S, M (a bit of fleece)
**Duration:** 1 minute

You create a sound or an image of an object within range that lasts for the duration. The illusion also ends if you dismiss it as an action or cast this spell again.

If you create a sound, its volume can range from a whisper to a scream. It can be your voice, someone else's voice, a lion's roar, a beating of drums, or any other sound you choose. The sound continues unabated throughout the duration, or you can make discrete sounds at different times before the spell ends.

If you create an image of an object, such as a chair, muddy footprints, or a small chest, it must be no larger than a 5-foot cube. The image can't create sound, light, smell, or any other sensory effect.

Physical interaction with the image reveals it to be an illusion because things can pass through it.

If a creature uses its action to examine the sound or image, the creature can determine that it is an illusion with a successful INT (Investigation) check against your spell save DC. If a creature discerns the illusion for what it is, the illusion becomes faint to the creature.

#### Mirror Image

_2nd-Circle Arcane and Wyrd (Illusion)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** 1 minute

Three illusory duplicates of yourself appear in your space.

Until the spell ends, the duplicates move with you and mimic your actions, shifting position so it's impossible to track which image is real. You can use your action to dismiss the illusory duplicates.

Each time a creature targets you with an attack during the spell's duration, roll a d20 to determine whether the attack instead targets one of your duplicates.

If you have three duplicates, you must roll a 6 or higher to change the attack's target to a duplicate. With two duplicates, you must roll an 8 or higher. With one duplicate, you must roll an 11 or higher.

A duplicate's AC equals 10 + your DEX modifier. If an attack hits a duplicate, the duplicate is destroyed. A duplicate can be destroyed only by an attack that specifically targeted you (and by extension, the duplicate), not areaof-effect spells such as fireball. It ignores all other damage and effects. The spell ends when all three duplicates are destroyed.

A creature's attacks are unaffected by this spell if the creature can't see, if it relies on senses other than sight, such as keensense, or if it can see through illusions, as with truesight.

#### Mislead

_5th-Circle Arcane (Illusion)_

**Casting Time:** 1 action
**Range:** Self
**Components:** S
**Duration:** Concentration, up to 1 hour

You become invisible at the same time that an illusory double of you appears where you are standing. The double lasts for the duration, but the invisibility ends if you attack or cast a spell.

You can use your action to move your illusory double up to twice your speed and make it gesture, speak, and behave in whatever way you choose.

You can see through its eyes and hear through its ears as if you were located where it is. On each of your turns as a bonus action, you can switch from using its senses to using your own, or back again. While you are using its senses, you are blinded and deafened in regard to your own surroundings.

#### Misty Step

_2nd-Circle Arcane and Wyrd (Conjuration)_

**Casting Time:** 1 bonus action
**Range:** Self
**Components:** V
**Duration:** Instantaneous

Briefly surrounded by silvery mist, you teleport up to 30 feet to an unoccupied space that you can see.

#### Modify Memory

_5th-Circle Arcane (Enchantment)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

One creature that you can see must make a WIS save. If you are fighting the creature, it has advantage on the save. On a failed save, the target becomes charmed by you for the duration. The charmed target is incapacitated and unaware of its surroundings, though it can still hear you. If it takes any damage or is targeted by another spell, this spell ends, and none of the target's memories are modified.

While this charm lasts, you can affect the target's memory of an event that it experienced within the last 24 hours and that lasted no more than 10 minutes. You can permanently eliminate all memory of the event, allow the target to recall the event with perfect clarity and exacting detail, change its memory of the details of the event, or create a memory of some other event.

You must speak to the target to describe how its memories are affected, and it must be able to understand your language for the modified memories to take root. Its mind fills in any gaps in the details of your description. If the spell ends before you have finished describing the modified memories, the creature's memory isn't altered.

Otherwise, the modified memories take hold when the spell ends.

A modified memory doesn't necessarily affect how a creature behaves, particularly if the memory contradicts the creature's natural inclinations or beliefs. An illogical modified memory, such as implanting a memory of how much the creature enjoyed dousing itself in acid, is dismissed, perhaps as a bad dream. The GM might deem a modified memory too nonsensical to affect a creature in a significant manner.

A remove curse or greater restoration spell cast on the target restores the creature's true memory.

_At Higher Circles._ If you cast this spell using a spell slot of 6th circle or higher, you can alter the target's memories of an event that took place up to 7 days ago (6th circle), 30 days ago (7th circle), 1 year ago (8th circle), or any time in the creature's past (9th circle).

#### Moonbeam

_2nd-Circle Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (several seeds of any moonseed plant and a piece of opalescent feldspar)
**Duration:** Concentration, up to 1 minute

A silvery beam of pale, dim light shines down in a 5-foot-radius, 40-foot-high cylinder centered on a point you choose within range. When a creature enters the spell's area for the first time on a turn or starts its turn there, it is engulfed in ghostly flames that cause searing pain, and it must make a CON save. It takes 2d10 radiant damage on a failed save, or half as much damage on a successful one.

A creature with the Shapechanger tag makes this save with disadvantage. If it fails, it also instantly reverts to its true form and can't assume a different form until it leaves the spell's light.

On each of your turns after you cast this spell, you can use an action to move the beam 60 feet in any direction.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, the damage increases by 1d10 for each slot above 2nd.

#### Move Earth

_6th-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (an iron blade and a small bag containing a mixture of soils - clay, loam, and sand)
**Duration:** Concentration, up to 2 hours Choose an area of terrain no larger than 40 feet on a side within range. You can reshape dirt, sand, or clay in the area in any manner you choose for the duration. You can raise or lower the area's elevation, create or fill in a trench, erect or flatten a wall, or form a pillar. The extent of any such changes can't exceed half the area's largest dimension. So, if you affect a 40-foot square, you can create a pillar up to 20 feet high, raise or lower the square's elevation by up to 20 feet, dig a trench up to 20 feet deep, and so on. It takes 10 minutes for these changes to complete.

At the end of every 10 minutes you spend concentrating on the spell, you can choose a new area of terrain to affect. Because the terrain's transformation occurs slowly, creatures in the area can't usually be trapped or injured by the ground's movement. This spell can't manipulate natural stone or stone construction. Rocks and structures shift to accommodate the new terrain. If the way you shape the terrain would make a structure unstable, it might collapse.

Similarly, this spell doesn't directly affect plant growth. The moved earth carries any plants along with it.

### N

#### Nondetection

_3rd-Circle Arcane and Wyrd (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a pinch of diamond dust worth 25 gp sprinkled over the target, which the spell consumes)
**Duration:** 8 hours

For the duration, you hide a target that you touch from divination magic. The target can be a willing creature, place, or object no larger than 10 feet in any dimension.

The target can't be targeted by any divination magic or perceived through magical scrying sensors.

### P

#### Pass Without Trace

_2nd-Circle Primordial (Abjuration)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S, M (ashes from a burned leaf of mistletoe and sprig of spruce)
**Duration:** Concentration, up to 1 hour

A veil of shadows and silence radiates from you, masking you and your companions from detection. For the duration, each creature you choose within 30 feet of you (including you) has a +10 bonus to DEX (Stealth) checks and can't be tracked except by magical means. A creature that receives this bonus leaves behind no tracks or other traces of its passage.

#### Passwall

_5th-Circle Arcane (Transmutation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a pinch of sesame seeds)
**Duration:** 1 hour

A passage appears at a point of your choice that you can see on a wooden, plaster, or stone surface (such as a wall, a ceiling, or a floor) within range, and lasts for the duration.

You choose the opening's dimensions: up to 5 feet wide, 8 feet tall, and 20 feet deep. The passage creates no instability in a structure surrounding it.

When the opening disappears, any creatures or objects still in the passage created by the spell are safely ejected to an unoccupied space nearest to the surface on which you cast the spell.

#### Phantasmal Killer

_4th-Circle Arcane and Wyrd (Illusion)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

You tap into the nightmares of a creature you can see within range and create an illusory manifestation of its deepest fears, visible only to that creature. The target must make a WIS save. On a failed save, the target becomes frightened of you for the duration. At the end of each of the target's turns before the spell ends, the target must succeed on a WIS save or take 4d10 psychic damage. On a successful save, the spell ends.

_At Higher Circles._ When you cast this spell using a spell slot of 5th circle or higher, the damage increases by 1d10 for each slot above 4th.

#### Plane Shift

_7th-Circle Divine and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a forked, metal rod worth at least 250 gp, attuned to a particular plane of existence)
**Duration:** Instantaneous

You and up to eight willing creatures who link hands in a circle are transported to a different plane of existence. You can specify a target destination in general terms, such as the city of Fandeval in the Shadow Realm, and you appear in or near that destination. If you are trying to reach Fandeval, for example, you might arrive in the Old Market Square district at the heart of the city, on the road that leads to the Sleeper's Gate entrance, or looking at the city from across the River Styx, at the GM's discretion.

Alternatively, if you know the sigil sequence of a teleportation circle on another plane of existence, this spell can take you to that circle. If the teleportation circle is too small to hold all the creatures you transported, they appear in the closest unoccupied spaces next to the circle.

You can use this spell to banish an unwilling creature to another plane. Choose a creature within your reach and make a melee spell attack against it. On a hit, the creature must make a CHA save. On a failure, the creature is transported to a random location on the plane of existence you specify. A creature so transported must find its own way back to your current plane of existence.

#### Plant Growth

_3rd-Circle Primordial (Transmutation)_

**Casting Time:** 1 action or 8 hours **Range:** 150 feet
**Components:** V, S
**Duration:** Instantaneous

There are two possible uses for this spell, depending on its casting time, granting either immediate or long-term benefits.

If you cast this spell using 1 action, choose a point within range. All normal plants in a 100-foot radius centered on that point become thick and overgrown. A creature moving through the area must spend 4 feet of movement for every 1 foot it moves. You can exclude one or more areas of any size within the spell's area from being affected.

If you cast this spell over 8 hours, you enrich the land.

All plants in a half-mile radius centered on a point within range become enriched for 1 year. The plants yield twice the normal amount of food when harvested.

#### Poison Spray

_Arcane and Primordial Cantrip (Conjuration)_

**Casting Time:** 1 action
**Range:** 10 feet
**Components:** V, S
**Duration:** Instantaneous

You extend your hand toward a creature you can see within range and project a puff of noxious gas from your palm.

The creature must succeed on a CON save or take 1d12 poison damage.

This spell's damage increases by 1d12 when you reach 5th level (2d12), 11th level (3d12), and 17th level (4d12).

#### Polymorph

_4th-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a caterpillar cocoon)
**Duration:** Concentration, up to 1 hour

This spell transforms a creature that you can see within range into a new form. The new form can be any Beast whose challenge rating is equal to or less than the target's challenge rating (or the target's level, if it doesn't have a challenge rating). The target's game statistics, including INT, WIS, and CHA, are replaced by those of the chosen Beast. It retains its personality.

An unwilling creature must make a WIS save to avoid the effect. The spell has no effect on a creature with the Shapechanger tag or a creature with 0 HP. The transformation lasts for the duration, until the target drops to 0 HP, or until it dies.

The target has the maximum hit points of its new form.

When it reverts to its normal form, the creature returns to the number of hit points it had before it transformed. If it reverts as a result of dropping to 0 HP, any excess damage carries over to its normal form. As long as the excess damage doesn't reduce the creature's normal form to 0 HP, it isn't knocked unconscious.

The creature is limited by the nature of its new form. It can't speak, cast spells, or take any action that requires hands or speech. The target's gear melds into the new form.

The creature can't activate, use, wield, or otherwise benefit from any of its equipment.

#### Power Word Kill

_9th-Circle Arcane, Divine, and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

You utter a word of power that can compel one creature you can see within range to die instantly. If the creature you choose has 100 HP or fewer, it dies. Otherwise, the spell has no effect.

#### Power Word Recover

_9th-Circle Divine (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

You utter a word of power that completely heals one creature you can see within range. The creature is restored to maximum hit points. In addition, any charmed, frightened, paralyzed, or stunned conditions affecting the target immediately end. This spell has no effect on Constructs or Undead.

#### Power Word Stun

_8th-Circle Arcane, Divine, and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

You speak a word of power that can overwhelm the mind of one creature you can see within range, leaving it dazed.

If the target has 150 HP or fewer, it is stunned. Otherwise, the spell has no effect. The stunned target must make a CON save at the end of each of its turns, ending the effect on itself on a success.

#### Prestidigitation

_Arcane Cantrip (Transmutation)_

**Casting Time:** 1 action
**Range:** 10 feet
**Components:** V, S
**Duration:** Up to 1 hour

This spell is a minor trick that novice spellcasters use for practice. You create one of the following magical effects within range:

- You create an instantaneous, harmless sensory effect, such as a shower of sparks, a puff of wind, faint musical notes, or an odd odor.
- You instantaneously light or snuff out a candle, a torch, or a small campfire.
- You instantaneously clean or soil anobject no larger than 1 cubic foot.
- You chill, warm, or flavor up to 1 cubic foot of nonliving material for 1 hour.
- You make a color, a small mark, or a symbol appear on an object or a surface for 1 hour.
- You create a nonmagical trinket or an illusory image that can fit in your hand and that lasts until the end of your next turn.

If you cast this spell multiple times, you can have up to three of its non-instantaneous effects active at a time, and you can dismiss such an effect as an action.

#### Prismatic Spray

_7th-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** Self (60-foot cone)
**Components:** V, S
**Duration:** Instantaneous

Eight multicolored rays of light flash from your hand.

Each ray is a different color and has a different power and purpose. Each creature in a 60-foot cone must make a DEX save. For each target, roll a d8 to determine which color ray affects it.

##### Table: Prismatic Ray

|  d8 | COLOR RAY                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| --: | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|   1 | **Red.** The target takes 10d6 fire damage on a failed save, or half as much damage on a successful one.                                                                                                                                                                                                                                                                                                                                                |
|   2 | **Orange.** The target takes 10d6 acid damage on a failed save, or half as much damage on a successful one.                                                                                                                                                                                                                                                                                                                                             |
|   3 | **Yellow.** The target takes 10d6 lightning damage on a failed save, or half as much damage on a successful one.                                                                                                                                                                                                                                                                                                                                        |
|   4 | **Green.** The target takes 10d6 poison damage on a failed save, or half as much damage on a successful one.                                                                                                                                                                                                                                                                                                                                            |
|   5 | **Blue.** The target takes 10d6 cold damage on a failed save, or half as much damage on a successful one.                                                                                                                                                                                                                                                                                                                                               |
|   6 | **Indigo.** On a failed save, the target is restrained. It must then make a CON save at the end of each of its turns. If it successfully saves three times, the spell ends. If it fails its save three times, it permanently turns to stone and is subjected to the petrified condition. The successes and failures don't need to be consecutive; keep track of both until the target collects three of a kind.                                         |
|   7 | **Violet.** On a failed save, the target is blinded. It must then make a WIS save at the start of your next turn. A successful save ends the blindness. If it fails that save, the creature is transported to another plane of existence of the GM's choosing and is no longer blinded. Typically, a creature that is on a plane that isn't its home plane is banished home, while other creatures are usually cast into the Astral or Ethereal planes. |
|   8 | **Special.** The target is struck by two rays. Roll twice more, rerolling any 8.                                                                                                                                                                                                                                                                                                                                                                        |

#### Prismatic Wall

_9th-Circle Arcane (Abjuration)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** 10 minutes

A shimmering, multicolored plane of light forms a vertical, opaque wall - up to 90 feet long, 30 feet high, and 1 inch thick - centered on a point you can see within range. Alternatively, you can shape the wall into a sphere up to 30 feet in diameter centered on a point you choose within range. The wall remains in place for the duration. If you position the wall so that it passes through a space occupied by a creature, the spell fails, and your action and the spell slot are wasted.

The wall sheds bright light to a range of 100 feet and dim light for an additional 100 feet. You and creatures you designate at the time you cast the spell can pass through and remain near the wall without harm. If another creature that can see the wall moves to within 20 feet of it or starts its turn there, the creature must succeed on a CON save or become blinded for 1 minute.

The wall consists of seven layers, each with a different color. When a creature attempts to reach into or pass through the wall, it does so one layer at a time through all the wall's layers. As it passes or reaches through each layer, the creature must make a DEX save or be affected by that layer's properties as described below.

The wall can be destroyed, also one layer at a time, in order from red to violet, by means specific to each layer. Once a layer is destroyed, it remains so for the duration of the spell. An antimagic field has no effect on the wall.

**Red.** The creature takes 10d6 fire damage on a failed save, or half as much damage on a successful one. While this layer is in place, nonmagical ranged attacks can't pass through the wall. The layer can be destroyed by dealing at least 25 cold damage to it.

**Orange.** The creature takes 10d6 acid damage on a failed save, or half as much damage on a successful one. While this layer is in place, magical ranged attacks can't pass through the wall. The layer is destroyed by a strong wind.

**Yellow.** The creature takes 10d6 lightning damage on a failed save, or half as much damage on a successful one.

This layer can be destroyed by dealing at least 60 force damage to it.

**Green.** The creature takes 10d6 poison damage on a failed save, or half as much damage on a successful one. A passwall spell, or another spell of equal or greater circle that can open a portal on a solid surface, destroys this layer.

**Blue.** The creature takes 10d6 cold damage on a failed save, or half as much damage on a successful one. This layer can be destroyed by dealing at least 25 fire damage to it.

**Indigo.** On a failed save, the creature is restrained. It must then make a CON save at the end of each of its turns. If it successfully saves three times, the spell ends. If it fails its save three times, it permanently turns to stone and is subjected to the petrified condition. The successes and failures don't need to be consecutive; keep track of both until the creature collects three of a kind. While this layer is in place, spells can't be cast through the wall. The layer is destroyed by bright light shed by a daylight spell or a similar spell of equal or higher circle.

**Violet.** On a failed save, the creature is blinded. It must then make a WIS save at the start of your next turn. A successful save ends the blindness. If it fails that save, the creature is transported to another plane of the GM's choosing and is no longer blinded. Typically, a creature that is on a plane that isn't its home plane is banished home, while other creatures are usually cast into the Astral or Ethereal planes. This layer is destroyed by a dispel magic spell or a similar spell of equal or higher circle that can end spells and magical effects.

#### Produce Flame

_Primordial Cantrip (Conjuration)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** 10 minutes

A flickering flame appears in your hand. It remains for the duration and harms neither you nor your equipment. The flame sheds bright light in a 10-foot radius and dim light for an additional 10 feet. The spell ends if you dismiss it as an action or if you cast it again.

You can also attack with the flame, although doing so ends the spell. When you cast this spell, or as an action on a later turn, you can hurl the flame at a creature within 30 feet of you. Make a ranged spell attack. On a hit, the target takes 1d8 fire damage.

This spell's damage increases by 1d8 when you reach 5th level (2d8), 11th level (3d8), and 17th level (4d8).

#### Programmed Illusion

_6th-Circle Arcane (Illusion)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (a bit of fleece and jade worth at least 25 gp)
**Duration:** Until dispelled

You create an illusion of an object, a creature, or some other visible phenomenon within range that activates when a specific condition occurs. The illusion is imperceptible until then. It must be no larger than a 30-foot cube, and you decide when you cast the spell how the illusion behaves and what sounds it makes. This scripted performance can last up to 5 minutes.

When the condition you specify occurs, the illusion springs into existence and performs in the manner you described. Once the illusion finishes performing, it disappears and remains dormant for 10 minutes. After this time, the illusion can be activated again.

The triggering condition can be as general or as detailed as you like, though it must be based on visual or audible conditions that occur within 30 feet of the area. For example, you could create an illusion of yourself to appear and warn off others who attempt to open a trapped door, or you could set the illusion to trigger only when a creature says the correct word or phrase.

Physical interaction with the image reveals it to be an illusion because things can pass through it. A creature that uses its action to examine the image can determine that it is an illusion with a successful INT (Investigation) check against your spell save DC. If a creature discerns the illusion for what it is, the creature can see through the image, and any noise it makes sounds hollow to the creature.

#### Project Image

_7th-Circle Arcane (Illusion)_

**Casting Time:** 1 action
**Range:** 500 feet
**Components:** V, S, M (a small replica of you made from materials worth at least 5 gp)
**Duration:** Concentration, up to 1 day

You create an illusory copy of yourself that lasts for the duration. The copy can appear at any location within range that you have seen before, regardless of intervening obstacles. The illusion looks and sounds like you but is intangible. If the illusion takes any damage, it disappears, and the spell ends.

You can use your action to move this illusion up to twice your speed and make it gesture, speak, and behave in whatever way you choose. It mimics your mannerisms perfectly.

You can see through its eyes and hear through its ears as if you were in its space. On your turn as a bonus action, you can switch from using its senses to using your own, or back again. While you are using its senses, you are blinded and deafened in regard to your own surroundings.

Physical interaction with the image reveals it to be an illusion because things can pass through it. A creature that uses its action to examine the image can determine that it is an illusion with a successful INT (Investigation) check against your spell save DC. If a creature discerns the illusion for what it is, the creature can see through the image, and any noise it makes sounds hollow to the creature.

#### Protection From Energy

_3rd-Circle Arcane, Divine, and Primordial (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** Concentration, up to 1 hour

For the duration, one willing creature you touch has resistance to one damage type of your choice: acid, cold, fire, lightning, or thunder.

#### Protection From Evil And Good

_1st-Circle Divine and Wyrd (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (holy water or powdered silver and iron, which the spell consumes)
**Duration:** Concentration, up to 10 minutes

Until the spell ends, one willing creature you touch is protected against certain types of creatures: Aberrations, Celestials, Elementals, Fey, Fiends, and Undead.

The protection grants several benefits. Creatures of those types have disadvantage on attack rolls against the target.

The target also can't be charmed, frightened, or possessed by them. If the target is already charmed, frightened, or possessed by such a creature, the target has advantage on any new save against the relevant effect.

#### Protection From Poison

_2nd-Circle Divine and Primordial (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** 1 hour

You touch a creature. If it is poisoned, you neutralize the poison. If more than one poison afflicts the target, you neutralize one poison that you know is present, or you neutralize one at random.

For the duration, the target has advantage on saves against being poisoned, and it has resistance to poison damage.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, you can target one additional creature for each slot above 2nd.

### R

#### Ray Of Enfeeblement

_2nd-Circle Arcane, Divine, and Wyrd (Necromancy)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 1 minute

A beam of enervating energy springs from your finger toward a creature within range. Make a ranged spell attack against the target. On a hit, the target deals only half damage with attacks that use STR until the spell ends.

At the end of each of the target's turns, it can make a CON save against the spell. On a success, the spell ends.

#### Ray Of Frost

_Arcane Cantrip (Evocation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

A frigid beam of blue-white light streaks toward a creature within range. Make a ranged spell attack against the target.

On a hit, it takes 1d8 cold damage, and its speed is reduced by 10 feet until the start of your next turn.

The spell's damage increases by 1d8 when you reach 5th level (2d8), 11th level (3d8), and 17th level (4d8).

#### Remove Curse

_3rd-Circle Divine and Wyrd (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** Instantaneous

At your touch, all curses affecting one creature or object end. If the object is a cursed magic item, its curse remains, but the spell breaks its owner's attunement to the object so it can be removed or discarded.

#### Resilient Sphere

_4th-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a hemispherical piece of clear crystal and a matching hemispherical piece of gum arabic)
**Duration:** Concentration, up to 1 minute

A sphere of shimmering force encloses a creature or object of Large size or smaller within range. An unwilling creature must make a DEX save. On a failed save, the creature is enclosed for the duration. Nothing - not physical objects, energy, or other spell effects - can pass through the barrier, in or out, though a creature in the sphere can breathe there. The sphere is immune to all damage, and a creature or object inside can't be damaged by attacks or effects originating from outside, nor can a creature inside the sphere damage anything outside it.

The sphere is weightless and just large enough to contain the creature or object inside. An enclosed creature can use its action to push against the sphere's walls and thus roll the sphere at up to half the creature's speed. Similarly, the globe can be picked up and moved by other creatures.

A disintegrate spell targeting the globe destroys it without harming anything inside it.

#### Resistance

_Divine and Primordial Cantrip (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a miniature cloak)
**Duration:** Concentration, up to 1 minute

You touch one willing creature. Once before the spell ends, the target can roll a d4 and add the number rolled to one save of its choice. It can roll the die before or after making the save. The spell then ends.

#### Restoration

_2nd-Circle Divine and Primordial (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** Instantaneous

You touch a creature and can end one disease or one condition afflicting it. The condition can be blinded, deafened, paralyzed, or poisoned.

#### Reverse Gravity

_7th-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 100 feet
**Components:** V, S, M (a lodestone and iron filings)
**Duration:** Concentration, up to 1 minute

This spell reverses gravity in a 50-foot-radius, 100-foot-high cylinder centered on a point within range.

All creatures and objects that aren't somehow anchored to the ground in the area fall upward and reach the top of the area when you cast this spell. A creature can make a DEX save to grab onto a fixed object it can reach, thus avoiding the fall.

If some solid object (such as a ceiling) is encountered in this fall, falling objects and creatures strike it just as they would during a normal downward fall. If an object or creature reaches the top of the area without striking anything, it remains there, oscillating slightly, for the duration.

At the end of the duration, affected objects and creatures fall back down.

#### Revivify

_3rd-Circle Divine and Wyrd (Necromancy)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (diamonds worth 300 gp, which the spell consumes)
**Duration:** Instantaneous

You touch a creature that has died within the last minute.

That creature returns to life with 1 HP. This spell can't return to life a creature that has died of old age, nor can it restore any missing body parts.

#### Rope Trick

_2nd-Circle Arcane and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a length of rope up to 60 feet long)
**Duration:** 1 hour

You touch a length of rope that is up to 60 feet long. One end of the rope then rises into the air until the whole rope hangs perpendicular to the ground. At the upper end of the rope, an invisible entrance opens to an extradimensional space that lasts until the spell ends.

The extradimensional space can be reached by climbing to the top of the rope. The space can hold as many as eight Medium or smaller creatures. The rope can be pulled into the space, making the rope disappear from view outside the space.

Attacks and spells can't cross through the entrance into or out of the extradimensional space, but those inside can see out of it as if through a 3-foot-by-5-foot window centered on the rope.

Anything inside the extradimensional space falls to the ground when the spell ends.

### S

#### Sacred Flame

_Divine Cantrip (Evocation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

Flame-like radiance descends on a creature that you can see within range. The target must succeed on a DEX save or take 1d8 radiant damage. The target gains no benefit from cover for this save.

The spell's damage increases by 1d8 when you reach 5th level (2d8), 11th level (3d8), and 17th level (4d8).

#### Sanctuary

_1st-Circle Divine (Abjuration)_

**Casting Time:** 1 bonus action
**Range:** 30 feet
**Components:** V, S, M (a small silver mirror)
**Duration:** 1 minute

You ward a creature within range against attack. Until the spell ends, any creature who targets the warded creature with an attack or a harmful spell must first make a WIS save. On a failed save, the creature must choose a new target or lose the attack or spell. This spell doesn't protect the warded creature from area effects, such as the explosion of a fireball.

If the warded creature makes an attack or casts a spell that affects an enemy creature, this spell ends.

#### Scorching Ray

_2nd-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** Instantaneous

You create three rays of fire and hurl them at targets within range. You can hurl them at one target or several. Make a ranged spell attack for each ray. On a hit, the target takes 2d6 fire damage.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, you create one additional ray for each slot above 2nd.

#### See Invisibility

_2nd-Circle Arcane, Divine, and Wyrd (Divination)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S, M (a pinch of talc and a small sprinkling of powdered silver)
**Duration:** 1 hour

For the duration, you see invisible creatures and objects as if they were visible, and you can see into the Ethereal Plane. Ethereal creatures and objects appear ghostly and translucent.

#### Seeming

_5th-Circle Arcane and Wyrd (Illusion)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S
**Duration:** 8 hours

This spell allows you to change the appearance of any number of creatures that you can see within range. You give each target you choose a new, illusory appearance. An unwilling target can make a CHA save, and if it succeeds, it is unaffected by this spell.

The spell disguises physical appearance as well as clothing, armor, weapons, and equipment. You can make each creature seem 1 foot shorter or taller and appear thin, fat, or in between. You can't change a target's body type, so you must choose a form that has the same basic arrangement of limbs. Otherwise, the extent of the illusion is up to you.

The spell lasts for the duration, unless you use your action to dismiss it sooner.

The changes wrought by this spell fail to hold up to physical inspection. For example, if you use this spell to add a hat to a creature's outfit, objects pass through the hat, and anyone who touches it would feel nothing or would feel the creature's head and hair. If you use this spell to appear thinner than you are, the hand of someone who reaches out to touch you would bump into you while it was seemingly still in midair.

A creature can use its action to inspect a target and make an INT (Investigation) check against your spell save DC. If it succeeds, it becomes aware that the target is disguised.

#### Sending

_3rd-Circle Arcane, Divine, and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** Unlimited
**Components:** V, S, M (a short piece of fine copper wire)
**Duration:** 1 round

You send a message of twenty-five words or fewer to a creature with whom you are familiar. Regardless of INT and language, the creature hears the message in its mind, recognizes you as the sender if it knows you, and can answer in a like manner immediately.

You can send the message across any distance and even to other planes of existence, but if the target is on a different plane than you, there is a 5 percent chance that the message doesn't arrive.

#### Sequester

_7th-Circle Arcane and Divine (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a powder composed of gemstone dust worth at least 5,000 gp, which the spell consumes)
**Duration:** Until dispelled

By means of this spell, a willing creature or an object can be hidden away, safe from detection for the duration. When you cast the spell and touch the target, it becomes invisible and can't be targeted by divination spells or perceived through scrying sensors created by divination spells.

If the target is a creature, it falls into a state of suspended animation. Time ceases to flow for it, and it doesn't grow older.

You can set a condition for the spell to end early. The condition can be anything you choose, but it must occur or be visible within 1 mile of the target. Examples include "after 1,000 years" or "when the tarrasque awakens." This spell also ends if the target takes any damage.

#### Shapechange

_9th-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S, M (a jade circlet worth at least 1,500 gp, which you must place on your head before you cast the spell)
**Duration:** Concentration, up to 1 hour

You assume the form of a different creature for the duration. The new form can be of any creature with a challenge rating equal to your level or lower. The creature can't be a Construct or an Undead, and you must have seen the sort of creature at least once.

You transform into an average example of that creature, one without any class levels or the Spellcasting trait.

Your game statistics are replaced by the statistics of the chosen creature, though you retain your INT, WIS, and CHA scores. You also retain all of your skill and save proficiencies. When you make an ability check or save, you can choose to use your modifiers or the creature's (whichever is higher). You can't use any legendary actions or lair actions of the new form.

You assume the hit points and hit dice of the new form.

When you revert to your normal form, you return to the number of hit points you had before you transformed.

If you revert as a result of dropping to 0 HP, any excess damage carries over to your normal form. As long as the excess damage doesn't reduce your normal form to 0 HP, you aren't knocked unconscious.

You retain the benefit of any features from your class, lineage, or other source and can use them, provided that your new form is physically capable of doing so. You can't use any special senses you have (for example, darkvision) unless your new form also has that sense. You can only speak if the creature can normally speak.

When you transform, you choose whether your equipment falls to the ground, merges into the new form, or is worn by it. Worn equipment functions as normal. The GM determines whether it is practical for the new form to wear a piece of equipment based on the creature's shape and size. Your equipment doesn't change shape or size to match the new form, and any equipment that the new form can't wear must either fall to the ground or merge into your new form. Equipment that merges has no effect in that state.

During this spell's duration, you can use your action to assume a different form following the same restrictions and rules for the original form, with one exception: if your new form has more hit points than your current one, your hit points remain at their current value.

#### Shatter

_2nd-Circle Arcane (Evocation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a chip of mica)
**Duration:** Instantaneous

A sudden loud ringing noise, painfully intense, erupts from a point of your choice within range. Each creature in a 10-foot-radius sphere centered on that point must make a CON save. A creature takes 3d8 thunder damage on a failed save, or half as much damage on a success. A creature made of inorganic material such as stone, crystal, or metal has disadvantage on this save.

A nonmagical object that isn't being worn or carried also takes the damage if it's in the spell's area.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, the damage increases by 1d8 for each slot above 2nd.

#### Shield

_1st-Circle Arcane (Abjuration)_

**Casting Time:** 1 reaction, when you are hit by an attack or targeted by the magic missile spell
**Range:** Self
**Components:** V, S
**Duration:** 1 round

An invisible barrier of magical force appears and protects you. Until the start of your next turn, you have a +5 bonus to AC, including against the triggering attack, and you take no damage from darts created by the magic missile spell.

#### Shield Of Faith

_1st-Circle Divine (Abjuration)_

**Casting Time:** 1 bonus action
**Range:** 60 feet
**Components:** V, S, M (a small parchment with a bit of holy text written on it)
**Duration:** Concentration, up to 10 minutes

A shimmering field appears and surrounds a creature of your choice within range, granting it a +2 bonus to AC for the duration.

#### Shillelagh

_Primordial Cantrip (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (mistletoe, a shamrock leaf, and a club or quarterstaff)
**Duration:** 1 minute

The wood of a club or quarterstaff you are holding is imbued with nature's power. For the duration, you can use your spellcasting ability instead of STR for the attack and damage rolls of melee attacks using that weapon, and the weapon's damage die becomes a d8. The weapon also becomes magical if it isn't already. As part of the same action used to cast this spell, you can make a single melee attack with the shillelagh, provided a creature is within the weapon's range.

The spell ends if you cast it again or if you let go of the weapon.

#### Shocking Grasp

_Arcane and Primordial Cantrip (Evocation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S
**Duration:** Instantaneous

Lightning springs from your hand to deliver a shock to a creature you touch. Make a melee spell attack against the target. You have advantage on the attack roll if the target is wearing metal armor or armor that lacks the Natural Materials property. On a hit, the target takes 1d8 lightning damage, and it can't take reactions until the start of its next turn.

The spell's damage increases by 1d8 when you reach 5th level (2d8), 11th level (3d8), and 17th level (4d8).

#### Silence

_2nd-Circle Divine and Wyrd (Illusion)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

For the duration, no sound can be created within or pass through a 20-foot-radius sphere centered on a point you choose within range. Any creature or object entirely inside the sphere is immune to thunder damage, and creatures are deafened while entirely inside it. Casting a spell that includes a verbal component is impossible while inside the sphere.

#### Silent Image

_1st-Circle Arcane (Illusion)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a bit of fleece)
**Duration:** Concentration, up to 10 minutes

You create the image of an object, a creature, or some other visible phenomenon that is no larger than a 15-foot cube.

The image appears at a spot within range and lasts for the duration. The image is purely visual; it isn't accompanied by sound, smell, or other sensory effects.

You can use your action to cause the image to move to any spot within range. As the image changes location, you can alter its appearance so that its movements appear natural for the image. For example, if you create an image of a creature and move it, you can alter the image so that it appears to be walking.

Physical interaction with the image reveals it to be an illusion because things can pass through it. A creature that uses its action to examine the image can determine that it is an illusion with a successful INT (Investigation) check against your spell save DC. If a creature discerns the illusion for what it is, the creature can see through the image.

#### Sleep

_1st-Circle Arcane and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V, S, M (a pinch of fine sand, rose petals, or a cricket)
**Duration:** 1 minute

This spell sends creatures into a magical slumber. Roll 8d8; the result is how many hit points of creatures this spell can affect. Creatures within 20 feet of a point you choose within range are affected in ascending order of their current hit points (ignoring unconscious creatures).

Starting with the creature that has the lowest current hit points, each creature affected by this spell falls unconscious until the spell ends, the sleeper takes damage, or someone uses an action to shake or slap the sleeper awake. Subtract each creature's hit points from the total before moving on to the creature with the next lowest hit points. A creature's hit points must be equal to or less than the remaining total for that creature to be affected.

Undead and creatures immune to being charmed aren't affected by this spell.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, roll an additional 2d8 for each slot above 1st.

#### Sleet Storm

_3rd-Circle Primordial (Conjuration)_

**Casting Time:** 1 action
**Range:** 150 feet
**Components:** V, S, M (a pinch of dust and a few drops of water)
**Duration:** Concentration, up to 1 minute

Until the spell ends, freezing rain and sleet fall in a 20-foottall cylinder with a 40-foot radius centered on a point you choose within range. The area is heavily obscured, and exposed flames are doused.

The ground in the area is covered with slick ice, making it difficult terrain. When a creature enters the spell's area for the first time on a turn or starts its turn there, it must make a DEX save. On a failed save, it falls prone.

If a creature is concentrating in the spell's area, the creature must make a successful CON save against your spell save DC or lose concentration.

#### Slow

_3rd-Circle Arcane (Transmutation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (a drop of molasses)
**Duration:** Concentration, up to 1 minute

You alter time around up to six creatures of your choice in a 40-foot cube within range. Each target must succeed on a WIS save or be affected by this spell for the duration.

An affected target's speed is halved, it takes a -2 penalty to AC and DEX saves, and it can't use reactions. On its turn, it can use either an action or a bonus action, not both.

Regardless of the creature's abilities or magic items, it can't make more than one melee or ranged attack during its turn.

If the creature attempts to cast a spell with a casting time of 1 action, roll a d20. On an 11 or higher, the spell doesn't take effect until the creature's next turn, and the creature must use its action on that turn to complete the spell. If it can't, the spell is wasted.

A creature affected by this spell makes another WIS save at the end of its turn, ending the effect on itself on a success.

#### Spare The Dying

_Divine Cantrip (Necromancy)_

**Casting Time:** 1 action
**Range:** 10 feet
**Components:** V, S
**Duration:** Instantaneous

You touch a living creature that has 0 HP. The creature becomes stable. This spell has no effect on Constructs or Undead.

#### Speak With Animals

_1st-Circle Primordial (Divination)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** 10 minutes

You gain the ability to understand and verbally communicate with Beasts and creatures with the Animal tag for the duration. The knowledge and awareness of such creatures are limited by their INT, but at minimum, targets can give you information about nearby locations and monsters, including whatever they can perceive or have perceived within the past day. You might be able to persuade a target to perform a small favor for you, at the GM's discretion.

#### Speak With Plants

_3rd-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Self (30-foot radius)
**Components:** V, S
**Duration:** 10 minutes

You imbue plants within 30 feet of you with limited sentience and animation, giving them the ability to communicate with you and follow your simple commands.

You can question plants about events in the spell's area within the past day, gaining information about creatures that have passed, weather, and other circumstances.

You can also turn difficult terrain caused by plant growth (such as thickets and undergrowth) into ordinary terrain that lasts for the duration. Or you can turn ordinary terrain where plants are present into difficult terrain that lasts for the duration, causing vines and branches to hinder pursuers, for example.

Plants might be able to perform other tasks on your behalf, at the GM's discretion. The spell doesn't enable plants to uproot themselves and move about, but they can freely move branches, tendrils, and stalks.

If a Plant creature is in the area, you can communicate with it as if you shared a common language, but you gain no magical ability to influence it.

This spell can cause the plants created by the entangle spell to release a restrained creature.

#### Spider Climb

_2nd-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a drop of bitumen and a spider)
**Duration:** Concentration, up to 1 hour

Until the spell ends, one willing creature you touch gains the ability to move up, down, and across vertical surfaces and upside down along ceilings while leaving its hands free. The target also gains a climbing speed equal to its walking speed.

#### Spike Growth

_2nd-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 150 feet
**Components:** V, S, M (seven sharp thorns or seven sharpened twigs)
**Duration:** Concentration, up to 10 minutes

The ground in a 20-foot radius centered on a point within range twists and sprouts hard spikes and thorns. The area becomes difficult terrain for the duration. When a creature moves into or within the area, it takes 2d4 piercing damage for every 5 feet it travels.

The transformation of the ground is camouflaged to look natural. Any creature that can't see the area at the time the spell is cast must make a WIS (Perception) check against your spell save DC to recognize the terrain as hazardous before entering it.

#### Spirit Guardians

_3rd-Circle Divine and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** Self (15-foot radius)
**Components:** V, S, M (a memento from a dead person)
**Duration:** Concentration, up to 10 minutes

You call forth spirits to protect you. They flit around you to a distance of 15 feet for the duration.

When you cast this spell, you can designate any number of creatures you can see to be unaffected by it. An affected creature's speed is halved in the area, and when the creature enters the area for the first time on a turn or starts its turn there, it must make a WIS save. On a failure, the creature takes 3d8 radiant damage or 3d8 necrotic damage, or half as much damage on a success.

_At Higher Circles._ When you cast this spell using a spell slot of 4th circle or higher, the damage increases by 1d8 for each slot above 3rd.

#### Spiritual Weapon

_2nd-Circle Divine and Wyrd (Evocation)_

**Casting Time:** 1 bonus action
**Range:** 60 feet
**Components:** V, S
**Duration:** 1 minute

You create a floating, spectral weapon within range that lasts for the duration or until you cast this spell again. The weapon can take any form you choose. When you cast the spell, you can make a melee spell attack against a creature within 5 feet of the weapon. On a hit, the target takes force damage equal to 1d8 + your spellcasting ability modifier.

As a bonus action on each of your subsequent turns, you can move the weapon up to 20 feet and repeat the attack against a creature within 5 feet of it.

_At Higher Circles._ When you cast this spell using a spell slot of 3rd circle or higher, the damage increases by 1d8 for every two slots above 2nd.

#### Stinking Cloud

_3rd-Circle Arcane and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** 90 feet
**Components:** V, S, M (a rotten egg or several skunk cabbage leaves)
**Duration:** Concentration, up to 1 minute

You create a 20-foot-radius sphere of yellow, nauseating gas centered on a point within range. The cloud spreads around corners, and its area is heavily obscured. The cloud lingers in the air for the duration.

Each creature that is completely within the cloud at the start of its turn must make a CON save against poison. On a failed save, the creature spends its action that turn retching and reeling. Creatures that don't need to breathe or are immune to poison automatically succeed on this save.

A moderate wind (at least 10 miles per hour) disperses the cloud after 4 rounds. A strong wind (at least 20 miles per hour) disperses it after 1 round.

#### Stone Shape

_4th-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (soft clay, which must be worked into roughly the desired shape of the stone object)
**Duration:** Instantaneous

You touch a stone object of Medium size or smaller or a section of stone no more than 5 feet in any dimension and form it into any shape that suits your purpose. For example, you could shape a large rock into a weapon, idol, or coffer, or make a small passage through a wall, as long as the wall is less than 5 feet thick. You could also shape a stone door or its frame to seal the door shut. The object you create can have up to two hinges and a latch, but finer mechanical detail isn't possible.

#### Stoneskin

_4th-Circle Primordial (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (diamond dust worth 100 gp, which the spell consumes)
**Duration:** Concentration, up to 1 hour

This spell turns the flesh of a willing creature you touch as hard as stone. Until the spell ends, the target has resistance to nonmagical bludgeoning, piercing, and slashing damage.

#### Storm Of Vengeance

_9th-Circle Divine and Primordial (Conjuration)_

**Casting Time:** 1 action
**Range:** Sight
**Components:** V, S
**Duration:** Concentration, up to 1 minute

A churning storm cloud forms, centered on a point you can see and spreading to a radius of 360 feet. Lightning flashes in the area, thunder booms, and strong winds roar. Each creature under the cloud (no more than 5,000 feet beneath the cloud) when it appears must make a CON save. On a failed save, a creature takes 2d6 thunder damage and becomes deafened for 5 minutes.

Each round you maintain concentration on this spell, the storm produces additional effects on your turn.

Round 2. Acidic rain falls from the cloud. Each creature and object under the cloud takes 1d6 acid damage.

Round 3. You call six bolts of lightning from the cloud to strike six creatures or objects of your choice beneath the cloud. A given creature or object can't be struck by more than one bolt. A struck creature must make a DEX save.

The creature takes 10d6 lightning damage on a failed save, or half as much damage on a successful one.

Round 4. Hailstones rain down from the cloud. Each creature under the cloud takes 2d6 bludgeoning damage.

Rounds 5-10. Gusts and freezing rain assail the area under the cloud. The area becomes difficult terrain and is heavily obscured. Each creature there takes 1d6 cold damage. Ranged weapon attacks in the area are impossible. If a creature starts its turn in the storm's area and is concentrating on a spell, the creature must make a successful CON save against your spell save DC or lose concentration. Finally, gusts of strong wind (ranging from 20 to 50 miles per hour) automatically disperse fog, mists, and similar phenomena in the area, whether mundane or magical.

#### Suggestion

_2nd-Circle Arcane, Divine, and Wyrd (Enchantment)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, M (a snake's tongue and either a bit of honeycomb or a drop of sweet oil)
**Duration:** Concentration, up to 8 hours You suggest a course of activity (limited to a sentence or two) and magically influence a creature you can see within range that can hear and understand you. Creatures that can't be charmed are immune to this effect. The suggestion must be worded in such a manner as to make the course of action sound reasonable. Asking the creature to stab itself, immolate itself, or do some other obviously harmful act ends the spell.

The target must make a WIS save. On a failed save, it pursues the course of action you described to the best of its ability. The suggested course of action can continue for the entire duration. If the suggested activity can be completed in a shorter time, the spell ends when the subject finishes what it was asked to do.

You can also specify conditions that will trigger a special activity during the duration. For example, you might suggest that a knight give her warhorse to the first beggar she meets. If the condition isn't met before the spell expires, the activity isn't performed.

If you or any of your companions damage the target, the spell ends.

#### Sunbeam

_6th-Circle Divine and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** Self (60-foot line)
**Components:** V, S, M (a magnifying glass)
**Duration:** Concentration, up to 1 minute

A beam of brilliant light flashes out from your hand in a 5-foot-wide, 60-foot-long line. Each creature in the line must make a CON save. On a failure, a creature takes 6d8 radiant damage and is blinded until your next turn. On a success, it takes half as much damage and isn't blinded by this spell. Undead have disadvantage on this save.

You can create a new line of radiance as your action on each turn until the spell ends.

For the duration, a mote of brilliant radiance shines in your hand. It sheds sunlight in a 30-foot radius and dim light for an additional 30 feet.

#### Sunburst

_8th-Circle Divine and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 150 feet (60-foot-radius sphere) **Components:** V, S, M (fire and a piece of sunstone)
**Duration:** Instantaneous

Brilliant sunlight flashes in a 60-foot-radius sphere centered on a point you choose within range. Each creature in that light must make a CON save. On a failed save, a creature takes 12d6 radiant damage and is blinded for 1 minute. On a successful save, it takes half as much damage and isn't blinded by this spell. Undead have disadvantage on this save.

A creature blinded by this spell makes another CON save at the end of each of its turns. On a successful save, it is no longer blinded.

This spell dispels any darkness in its area that was created by a spell.

### T

#### Telekinesis

_5th-Circle Arcane and Wyrd (Transmutation)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** Concentration, up to 10 minutes

You gain the ability to move or manipulate creatures or objects by thought. When you cast the spell, and as your action each round for the duration, you can exert your will on one creature or object that you can see within range, causing the appropriate effect below. You can affect the same target round after round, or choose a new one at any time. If you switch targets, the prior target is no longer affected by the spell.

Creature. You can try to move a Huge or smaller creature. Make an ability check with your spellcasting ability contested by the creature's STR check. If you win the contest, you move the creature up to 30 feet in any direction, including upward but not beyond the range of this spell. Until the end of your next turn, the creature is restrained in your telekinetic grip. A creature lifted upward is suspended in mid-air.

On subsequent rounds, you can use your action to attempt to maintain your telekinetic grip on the creature by repeating the contest.

Object. You can try to move an object that weighs up to 1,000 pounds. If the object isn't being worn or carried, you automatically move it up to 30 feet in any direction, but not beyond the range of this spell.

If the object is worn or carried by a creature, you must make an ability check with your spellcasting ability contested by that creature's STR check. If you succeed, you pull the object away from that creature and can move it up to 30 feet in any direction but not beyond the range of this spell.

You can exert fine control on objects with your telekinetic grip, such as manipulating a simple tool, opening a door or a container, stowing or retrieving an item from an open container, or pouring the contents from a vial.

#### Telepathic Bond

_5th-Circle Arcane and Wyrd (Divination)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (pieces of eggshell from two different kinds of creatures)
**Duration:** 1 hour

You forge a telepathic link among up to eight willing creatures of your choice within range, psychically linking each creature to all the others for the duration. Creatures with an INT of 3 (-4) or lower aren't affected by this spell. Until the spell ends, the targets can communicate telepathically through the bond whether or not they have a common language. The communication is possible over any distance, though it can't extend to other planes of existence.

#### Teleport

_7th-Circle Arcane (Conjuration)_

**Casting Time:** 1 action
**Range:** 10 feet
**Components:** V
**Duration:** Instantaneous

This spell instantly transports you and up to eight willing creatures of your choice that you can see within range, or a single object that you can see within range, to a destination you select. If you target an object, it must be able to fit entirely inside a 10-foot cube, and it can't be held or carried by an unwilling creature.

The destination you choose must be known to you, and it must be on the same plane of existence as you. Your familiarity with the destination determines whether you arrive there successfully. The GM rolls d100 and consults the **Destination Accuracy** table.

**Familiarity.** "Permanent circle" means a permanent teleportation circle whose sigil sequence you know.

"Associated object" means that you possess an object taken from the desired destination within the last six months, such as a book from a wizard's library, bed linen from a royal suite, or a chunk of marble from a lich's secret tomb.

"Very familiar" is a place you have been very often, a place you have carefully studied, or a place you can see when you cast the spell.

"Seen casually" is a place you have seen more than once but with which you aren't very familiar.

"Viewed once" is a place you have seen once, possibly using magic.

"Description" is a place whose location and appearance you know through someone else's description, perhaps from a map.

"False destination" is a place that doesn't exist. Perhaps you tried to scry an enemy's sanctum but instead viewed an illusion, or you are attempting to teleport to a familiar location that no longer exists.

**On Target.** You and your group (or the target object) appear where you want to.

**Off Target.** You and your group (or the target object) appear a random distance away from the destination in a random direction. Distance off target is 1d10 × 1d10 percent of the distance that was to be traveled. For example, if you tried to travel 120 miles, landed off target, and rolled a 5 and 3 on the two d10s, then you would be off target by 15 percent, or 18 miles. The GM determines the direction off target randomly by rolling a d8 and designating 1 as north, 2 as northeast, 3 as east, and so on around the points of the compass. If you were teleporting to a coastal city and wound up 18 miles out at sea, you could be in trouble.

**Similar Area.** You and your group (or the target object) wind up in a different area that's visually or thematically similar to the target area. If you are heading for your home laboratory, for example, you might wind up in another wizard's laboratory or in an alchemical supply shop that has many of the same tools and implements as your laboratory. Generally, you appear in the closest similar place, but since the spell has no range limit, you could conceivably wind up anywhere on the plane.

**Mishap.** The spell's unpredictable magic results in a difficult journey. Each teleporting creature (or the target object) takes 3d10 force damage, and the GM rerolls on the table to see where you wind up (multiple mishaps can occur, dealing damage each time).

##### Table: Teleport Destination Accuracy

| FAMILIARITY       | MISHAP | SIMILAR AREA | OFF TARGET | ON TARGET |
| ----------------- | ------ | ------------ | ---------- | --------- |
| Permanent circle  | -      | -            | -          | 01-100    |
| Associated object | -      | -            | -          | 01-100    |
| Very familiar     | 01-05  | 06-013       | 14-24      | 25-100    |
| Seen casually     | 01-33  | 34-043       | 44-53      | 54-100    |
| Viewed once       | 01-43  | 44-053       | 54-73      | 74-100    |
| Description       | 01-43  | 44-053       | 54-73      | 74-100    |
| False destination | 01-50  | 51-100       | -          | -         |

#### Thaumaturgy

_Divine and Wyrd Cantrip (Transmutation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V
**Duration:** Up to 1 minute

You manifest a minor wonder, a sign of supernatural power, within range. You create one of the following magical effects within range:

- Your voice booms up to three times as loud as normal for 1 minute.
- You cause flames to flicker, brighten, dim, or change color for 1 minute.
- You cause harmless tremors in the ground for 1 minute.
- You create an instantaneous sound that originates from a point of your choice within range, such as a rumble of thunder, the cry of a raven, or ominous whispers.
- You instantaneously cause an unlocked door or window to fly open or slam shut.
- You alter the appearance of your eyes for 1 minute.

If you cast this spell multiple times, you can have up to three of its 1-minute effects active at a time, and you can dismiss such an effect as an action.

#### Thunderwave

_1st-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** Self (15-foot cube)
**Components:** V, S
**Duration:** Instantaneous

A wave of thunderous force sweeps out from you. Each creature in a 15-foot cube originating from you must make a CON save. On a failed save, a creature takes 2d8 thunder damage and is pushed 10 feet away from you. On a successful save, the creature takes half as much damage and isn't pushed.

In addition, unsecured objects that are completely within the area of effect are automatically pushed 10 feet away from you by the spell's effect, and the spell emits a thunderous boom audible out to 300 feet.

_At Higher Circles._ When you cast this spell using a spell slot of 2nd circle or higher, the damage increases by 1d8 for each slot above 1st.

#### Time Stop

_9th-Circle Arcane (Transmutation)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V
**Duration:** Instantaneous

You briefly stop the flow of time for everyone but yourself. No time passes for other creatures while you take 1d4 + 1 turns in a row, during which you can use actions and move as normal.

This spell ends if one of the actions you use during this period, or any effects that you create during this period, affects a creature other than you or an object being worn or
carried by someone other than you. In addition, the spell
ends if you move to a place more than 1,000 feet from the
location where you cast it.

#### Tongues

_3rd-Circle Arcane and Divine (Divination)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a small clay model of a ziggurat)
**Duration:** 1 hour

This spell grants the creature you touch the ability to understand any spoken language it hears. Moreover, when the target speaks, any creature that knows at least one language and can hear the target understands what it says.

#### Transmogrification

_7th-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S, M (flesh from a Fiend, a feather from a Celestial, or a scale from a Dragon worth 50 gp)
**Duration:** 1 minute

You transform your body to grant yourself benefits of monstrous forms. When you cast this spell, choose one of the listed transformations that your form first assumes.

While the spell is active, you can use a bonus action to exchange your current transformation for a different option you haven't already used during this casting of the spell. Once you assume your third form, you can't shift into a different listed form for the duration, but you can use a bonus action to end the spell early and assume your original form. The spell also ends early if you are incapacitated or if you die.

Wings. You sprout wings from your shoulders and gain a flying speed of 60 feet. The wings can be batlike or feathered.

Breath Weapon. You gain a breath weapon of one of these types of your choice: acid, cold, fire, lightning, or poison.

While active, you can use an action to unleash your breath weapon in a 15-foot line that is 5 feet wide. Each creature in the line must make a DEX save, taking 8d8 damage of the chosen type on a failure, or half as much damage on a success. You can use the breath weapon up to three times, and it expires after the third use.

Limbs. Two appendages resembling tentacles, insectoid legs, pincers, or something similar sprout from your body (they don't replace your existing limbs). When they first appear, choose if these appendages deal bludgeoning, piercing, or slashing damage. While active, you can use an action to make a melee weapon attack with each appendage (two attacks total) against a target or targets within 10 feet of you. You are considered proficient with the use of the appendages as weapons, and you use your spellcasting modifier to calculate your bonus to hit with them. On a successful hit, an appendage deals 2d12 + your spellcasting modifier damage of the chosen type.

Radiating Light. You emit light in a 10-foot radius. The light can come from a halo, ghostly flames, your eyes, or a similar source you choose. When it first appears, you choose whether the light deals necrotic, fire, or radiant damage. A creature other than you that enters the light for the first time on its turn or starts its turn in the light must make a CON save, taking 2d10 damage of the chosen type on a failure or half as much damage on a success. A creature can take this damage only once per turn.

Regeneration. While this feature is active, you can choose to recover 10 HP at the start of your turn. You can use this ability up to three times, and it expires after the third use.

Overwhelming Might. When you hit a target with a weapon attack, the target takes the attack's standard damage plus an extra 2d8 force damage and must succeed on a STR save or be knocked prone.

Frightening Presence. As an action, choose any number of creatures within 30 feet of you that can see you. Each creature must succeed on a WIS save or become frightened of you for 1 minute. A creature frightened in this way can repeat the save at the end of each of its turns, ending the effect on itself on a success. If a creature's save is successful or the effect ends for it, the creature is immune to this feature for the next 24 hours. You can use this ability up to three times, and it expires after the third use.

#### Transport Via Plants

_6th-Circle Primordial (Conjuration)_

**Casting Time:** 1 action
**Range:** 10 feet
**Components:** V, S
**Duration:** 1 round

This spell creates a magical link between a Large or larger nonmagical plant within range and another plant, at any distance, on the same plane of existence. Creatures of the Plant type can't be targeted by this spell. You must have seen or touched the destination plant at least once before.

For the duration, any creature can step into the target plant and exit from the destination plant by using 5 feet of movement.

#### Tree Stride

_5th-Circle Primordial (Conjuration)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 1 minute

You gain the ability to enter a tree and move from inside it to inside another tree of the same kind within 500 feet.

Both trees must be living and at least the same size as you. You must use 5 feet of movement to enter a tree. You instantly know the location of all other trees of the same kind within 500 feet and, as part of the move used to enter the tree, can either pass into one of those trees or step out of the tree you're in. You appear in a space of your choice within 5 feet of the destination tree using another 5 feet of movement. If you have no movement left, you appear within 5 feet of the tree you entered.

You can use this transportation ability once per round for the duration. You must end each turn outside a tree.

#### True Polymorph

_9th-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a drop of mercury, a dollop of gum arabic, and a wisp of smoke)
**Duration:** Concentration, up to 1 hour

Choose one creature or nonmagical object that you can see within range. You transform the creature into a different creature, the creature into an object, or the object into a creature (the object must be neither worn nor carried by another creature). The transformation lasts for the duration or until the target drops to 0 HP or dies.

If you concentrate on this spell for the full duration, the transformation lasts until it is dispelled.

This spell has no effect on a creature with the Shapechanger tag or a creature with 0 HP. An unwilling creature can make a WIS save, and if it succeeds, it isn't affected by this spell.

Creature into Creature. If you turn a creature into another kind of creature, the new form can be any kind you choose whose challenge rating is equal to or less than the target's (or its level, if the target doesn't have a challenge rating). The target's game statistics, including mental ability scores, are replaced by the statistics of the new form.

It retains its personality.

The target assumes the hit points of its new form, and when it reverts to its normal form, the creature returns to the number of hit points it had before it transformed. If it reverts as a result of dropping to 0 HP, any excess damage carries over to its normal form. As long as the excess damage doesn't reduce the creature's normal form to 0 HP, it isn't knocked unconscious.

The creature is limited in the actions it can perform by the nature of its new form, and it can't speak, cast spells, or take any other action that requires hands or speech unless its new form is capable of such actions.

The target's gear melds into the new form. The creature can't activate, use, wield, or otherwise benefit from any of its equipment.

Object into Creature. You can turn an object into any kind of creature, as long as the creature's size is no larger than the object's size and the creature's challenge rating is 9 or lower. The creature is friendly to you and your companions. It acts on each of your turns. You decide what action it takes and how it moves. The GM has the creature's statistics and resolves all of its actions and movement.

If the spell becomes permanent, you no longer control the creature. It might remain friendly to you, depending on how you have treated it.

Creature into Object. If you turn a creature into an object, it transforms along with whatever it is wearing and carrying into that form. The creature's statistics become those of the object, and the creature has no memory of time spent in this form after the spell ends and it returns to its normal form.

#### True Seeing

_6th-Circle Arcane, Divine, and Wyrd (Divination)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (ointment made from powdered mushrooms and saffron worth 25 gp, which the spell consumes)
**Duration:** 1 hour

You touch a willing creature to grant it the ability to see things as they actually are. For the duration, that creature has truesight to a range of 120 feet.

_At Higher Circles._ When you cast this spell using a spell slot of 7th circle or higher, you can target one additional creature for each slot above 6th.

### V

#### Vampiric Touch

_3rd-Circle Arcane, Divine, and Wyrd (Necromancy)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V, S
**Duration:** Concentration, up to 1 minute

The touch of your shadow-wreathed hand can siphon life force from others to heal your wounds. Make a melee spell attack against a creature within your reach. On a hit, the target takes 3d6 necrotic damage, and you regain hit points equal to half the amount of necrotic damage dealt. Until the spell ends, you can make the attack again on each of your turns as an action.

_At Higher Circles._ When you cast this spell using a spell slot of 4th circle or higher, the damage increases by 1d6 for each slot above 3rd.

#### Vicious Mockery

_Arcane and Wyrd Cantrip (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V
**Duration:** Instantaneous

You unleash a string of insults laced with subtle enchantments at a creature you can see within range. If the target can hear you (though it need not understand you), it must succeed on a WIS save or take 1d4 psychic damage and have disadvantage on the next attack roll it makes before the end of its next turn.

This spell's damage increases by 1d4 when you reach 5th level (2d4), 11th level (3d4), and 17th level (4d4).

### W

#### Wall Of Fire

_4th-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (a small piece of phosphorus)
**Duration:** Concentration, up to 1 minute

You create a wall of fire on a solid surface within range. You can make the wall in a line up to 60 feet long, 20 feet high, and 1 foot thick or in a circle up to 20 feet in diameter, 20 feet high, and 1 foot thick. The wall is opaque and lasts for the duration.

When the wall appears, each creature within its area must make a DEX save. A creature takes 5d8 fire damage on a failed save, or half as much damage on a successful one.

One side of the wall, selected by you when you cast this spell, deals 5d8 fire damage to each creature that ends its turn within 10 feet of that side or inside the wall. A creature takes the same damage when it enters the wall for the first time on a turn or ends its turn there. The other side of the wall deals no damage.

_At Higher Circles._ When you cast this spell using a spell slot of 5th circle or higher, the damage increases by 1d8 for each slot above 4th.

#### Wall Of Force

_5th-Circle Arcane and Wyrd (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (a pinch of powder made by crushing a clear gemstone)
**Duration:** Concentration, up to 10 minutes

An invisible wall of force springs into existence at a point you choose within range. The wall appears in any orientation you choose as a horizontal or vertical barrier or at an angle. It can be free floating or resting on a solid surface. You can form it into a hemispherical dome or a sphere with a radius of up to 10 feet, or you can shape a flat surface made up of ten 10-foot-by-10-foot panels. Each panel must be contiguous with another panel. In any form, the wall is 1/4 inch thick. It lasts for the duration. If the wall cuts through a creature's space when it appears, the creature is pushed to one side of the wall (your choice).

Nothing can physically pass through the wall. It is immune to all damage and can't be dispelled by the dispel magic spell. However, a disintegrate spell destroys the wall instantly. The wall also extends into the Ethereal Plane, blocking ethereal travel through the wall.

#### Wall Of Ice

_6th-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (a small piece of quartz)
**Duration:** Concentration, up to 10 minutes

You create a wall of ice on a solid surface within range. You can form it into a hemispherical dome or a sphere with a radius of up to 10 feet, or you can shape a flat surface made up of ten 10-foot-square panels. Each panel must be contiguous with another panel. In any form, the wall is 1 foot thick and lasts for the duration.

If the wall cuts through a creature's space when it appears, the creature within its area is pushed to one side of the wall (your choice) and must make a DEX save. On a failure, the creature takes 10d6 cold damage or half as much damage on a success.

The wall is an object that can be damaged and thus breached. It has AC 12 and 30 HP per 10-foot section, and it is vulnerable to fire damage. Reducing a 10-foot section of wall to 0 HP destroys it and leaves behind a sheet of frigid air in the space the wall occupied. A creature moving through the sheet of frigid air for the first time on a turn must make a CON save. That creature takes 5d6 cold damage on a failed save, or half as much damage on a successful one.

_At Higher Circles._ When you cast this spell using a spell slot of 7th circle or higher, the damage the wall deals when it appears increases by 2d6, and the damage from passing through the sheet of frigid air increases by 1d6, for each slot above 6th.

#### Wall Of Stone

_5th-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (a small block of granite)
**Duration:** Concentration, up to 10 minutes

A nonmagical wall of solid stone springs into existence at a point you choose within range. The wall is 6 inches thick and is composed of ten 10-foot-by-10-foot panels. Each panel must be contiguous with at least one other panel.

Alternatively, you can create 10-foot-by-20-foot panels that are only 3 inches thick.

If the wall cuts through a creature's space when it appears, the creature is pushed to one side of the wall (your choice).

If a creature would be surrounded on all sides by the wall (or the wall and another solid surface), that creature can make a DEX save. On a success, it can use its reaction to move up to its speed so that it is no longer enclosed by the wall.

The wall can have any shape you desire, though it can't occupy the same space as a creature or object. The wall doesn't need to be vertical or rest on any firm foundation.

It must, however, merge with and be solidly supported by existing stone. Thus, you can use this spell to bridge a chasm or create a ramp.

If you create a span greater than 20 feet in length, you must halve the size of each panel to create supports.

You can crudely shape the wall to create crenellations, battlements, and so on.

The wall is an object made of stone that can be damaged and thus breached. Each panel has AC 15 and 30 HP per inch of thickness. Reducing a panel to 0 HP destroys it and might cause connected panels to collapse at the GM's discretion.

If you maintain your concentration on this spell for its whole duration, the wall becomes permanent and can't be dispelled. Otherwise, the wall disappears when the spell ends.

#### Wall Of Thorns

_6th-Circle Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (a handful of thorns)
**Duration:** Concentration, up to 10 minutes

You create a wall of tough, pliable, tangled brush bristling with needle-sharp thorns. The wall appears within range on a solid surface and lasts for the duration. You choose to make the wall up to 60 feet long, 10 feet high, and 5 feet thick or a circle that has a 20-foot diameter and is up to 20 feet high and 5 feet thick. The wall blocks line of sight.

When the wall appears, each creature within its area must make a DEX save. On a failure, a creature takes 7d8 piercing damage or half as much damage on a success.

A creature can move through the wall, albeit slowly and painfully. For every 1 foot a creature moves through the wall, it must spend 4 feet of movement. Furthermore, the first time a creature enters the wall on a turn or ends its turn there, the creature must make a DEX save. It takes 7d8 slashing damage on a failed save, or half as much damage on a successful one.

_At Higher Circles._ When you cast this spell using a spell slot of 7th circle or higher, both types of damage increase by 1d8 for each slot above 6th.

#### Warding Bond

_2nd-Circle Divine (Abjuration)_

**Casting Time:** 1 action
**Range:** Touch
**Components:** V, S, M (a pair of platinum rings worth at least 50 gp each, which you and the target must wear for the duration)
**Duration:** 1 hour

This spell wards a willing creature you touch and creates a mystic connection between you and the target until the spell ends. While the target is within 60 feet of you, it gains a +1 bonus to AC and saves, and it has resistance to all damage. However, each time it takes damage, you take the same amount of damage.

The spell ends if you drop to 0 HP or if you and the target become separated by more than 60 feet. It also ends if the spell is cast again on either of the connected creatures. You can also dismiss the spell as an action.

#### Water Breathing

_3rd-Circle Arcane and Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (a short reed or a piece of straw)
**Duration:** 24 hours

This spell grants up to ten willing creatures you can see within range the ability to breathe underwater until the spell ends. Affected creatures also retain their normal mode of respiration.

#### Web

_2nd-Circle Arcane (Conjuration)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S, M (a bit of spiderweb)
**Duration:** Concentration, up to 1 hour

You conjure a mass of thick, sticky webbing at a point of your choice within range. The webs fill a 20-foot cube from that point for the duration. The webs are difficult terrain and lightly obscure their area. If the webs aren't anchored between two solid masses (such as walls or trees) or layered across a floor, wall, or ceiling, the conjured web collapses on itself, and the spell ends at the start of your next turn.

Webs layered over a flat surface have a depth of 5 feet.

Each creature that starts its turn in the webs or that enters them during its turn must make a DEX save. On a failed save, the creature is restrained as long as it remains in the webs or until it breaks free. A creature restrained by the webs can use its action to make a STR check against your spell save DC. If it succeeds, it is no longer restrained.

The webs are flammable. Any 5-foot cube of webs exposed to fire burns away in 1 round, dealing 2d4 fire damage to any creature that starts its turn in the fire.

#### Weird

_9th-Circle Arcane and Wyrd (Illusion)_

**Casting Time:** 1 action
**Range:** 120 feet (30-foot-radius sphere)
**Components:** V, S
**Duration:** Concentration, up to 1 minute

Drawing on the deepest fears of a group of creatures, you create illusory creatures in their minds visible only to them.

Each creature in a 30-foot-radius sphere centered on a point of your choice within range must make a WIS save. On a failed save, a creature becomes frightened of you for the duration. The illusion calls on the creature's deepest fears, manifesting its worst nightmares as an implacable threat.

At the end of each of the frightened creature's turns, it must succeed on a WIS save or take 4d10 psychic damage. On a successful save, the spell ends for that creature.

#### Wind Walk

_6th-Circle Primordial (Transmutation)_

**Casting Time:** 1 action
**Range:** 30 feet
**Components:** V, S, M (fire and rainwater)
**Duration:** 8 hours

You and up to ten willing creatures you can see within range assume a gaseous form for the duration, appearing as wisps of cloud. While in this cloud form, a creature has a flying speed of 300 feet and has resistance to damage from nonmagical attacks. The only actions a creature can take in this form are the Dash action or to revert to its normal form.

Reverting takes 1 minute, during which time a creature is incapacitated and can't move. Until the spell ends, a creature can revert to cloud form, which also requires the 1-minute transformation.

If a creature is in cloud form and flying when the effect ends, the creature descends 60 feet per round for 1 minute until it lands, which it does safely. If it can't land after 1 minute, the creature falls the remaining distance.

#### Wind Wall

_3rd-Circle Arcane and Primordial (Evocation)_

**Casting Time:** 1 action
**Range:** 120 feet
**Components:** V, S, M (a tiny fan and a feather)
**Duration:** Concentration, up to 1 minute

A wall of strong wind rises from the ground at a point you choose within range. You can make the wall up to 50 feet long, 15 feet high, and 1 foot thick. You can shape the wall in any way you choose so long as it makes one continuous path along the ground. The wall lasts for the duration.

When the wall appears, each creature within its area must make a STR save. A creature takes 3d8 bludgeoning damage on a failed save, or half as much damage on a success.

The strong wind keeps fog, smoke, and other gasses at bay. Small or smaller flying creatures or objects can't pass through the wall. Loose, lightweight materials brought into the wall fly upward. Arrows, bolts, and other ordinary projectiles launched at targets behind the wall are deflected upward and automatically miss. (Boulders hurled by giants or siege engines, and similar projectiles, are unaffected.) Creatures in gaseous form can't pass through it.

#### Wish

_9th-Circle Arcane and Wyrd (Conjuration)_

**Casting Time:** 1 action
**Range:** Self
**Components:** V
**Duration:** Instantaneous

Wish is the mightiest spell a mortal creature can cast. By simply speaking aloud, you can alter the very foundations of reality in accord with your desires. The basic use of this spell is to duplicate any other spell of 8th circle or lower.

You don't need to meet any requirements in that spell, including costly components. The spell simply takes effect.

Alternatively, you can create one of the following effects of your choice:

- You create one object of up to 25,000 gp in value that isn't a magic item. The object can be no more than 300 feet in any dimension, and it appears in an unoccupied space you can see on the ground.
- You allow up to twenty creatures that you can see to regain all hit points, and you end all effects on them described in the greater restoration spell.
- You grant up to ten creatures that you can see resistance to a damage type you choose.
- You grant up to ten creatures you can see immunity to a single spell or other magical effect for 8 hours.

For instance, you could make yourself and all your companions immune to a lich's Life Drain attack.

- You undo a single recent event by forcing a reroll of any roll made within the last round (including your last turn). Reality reshapes itself to accommodate the new result. For example, a wish spell could undo an opponent's successful save, a foe's critical hit, or a friend's failed save. You can force the reroll to be made with advantage or disadvantage, and you can choose whether to use the reroll or the original roll.

You might be able to achieve something beyond the scope of the above examples. State your wish to the GM as precisely as possible. The GM has great latitude in ruling what occurs in such an instance; the greater the wish, the greater the likelihood that something goes wrong. This spell might simply fail, the effect you desire might only be partly achieved, or you might suffer some unforeseen consequence as a result of how you worded the wish. For example, wishing that a villain were dead might propel you forward in time to a period when that villain is no longer alive, effectively removing you from the game. Similarly, wishing for a legendary magic item or artifact might instantly transport you to the presence of the item's current owner.

The stress of casting this spell to produce any effect other than duplicating another spell weakens you. After enduring that stress, each time you cast a spell until you finish a long rest, you take 1d10 necrotic damage per circle of that spell.

This damage can't be reduced or prevented in any way. In addition, your STR score drops to 3, if it isn't 3 or lower already, for 2d4 days. For each of those days that you spend resting and doing nothing more than light activity, your remaining recovery time decreases by 2 days. Finally, there is a 33 percent chance that you are unable to cast wish ever again if you suffer this stress.

#### Word Of Recall

_6th-Circle Divine (Conjuration)_

**Casting Time:** 1 action
**Range:** 5 feet
**Components:** V
**Duration:** Instantaneous

You and up to five willing creatures within 5 feet of you instantly teleport to a previously designated sanctuary.

You and creatures that teleport with you appear in an unoccupied space nearest to the spot you designated when you prepared your sanctuary. If you cast this spell without first preparing a sanctuary, the spell has no effect.

You must designate a sanctuary by casting this spell within a location, such as a temple, dedicated to or strongly linked to your deity. If you attempt to cast the spell in this manner in an area that isn't dedicated to your deity, the spell has no effect.

### Z

#### Zone Of Truth

_2nd-Circle Divine (Enchantment)_

**Casting Time:** 1 action
**Range:** 60 feet
**Components:** V, S
**Duration:** 10 minutes

You create a magical zone that guards against deception in a 15-foot-radius sphere centered on a point of your choice within range. Until the spell ends, a creature that enters the spell's area for the first time on a turn or starts its turn there must make a CHA save. On a failed save, a creature can't speak a deliberate lie while in the radius. You know whether each creature succeeds or fails on its save.

An affected creature is aware of the spell and can thus avoid answering questions to which it would normally respond with a lie. Such a creature can be evasive in its answers as long as it remains within the boundaries of the truth.

## Ritual Descriptions

### Alarm

_1st-Circle Arcane Ritual (Abjuration)_

**Casting Time:** 1 minute
**Range:** 30 feet
**Components:** V, S, M (silver hand bell worth at least 10 gp)
**Duration:** 8 hours

You set an alarm against unwanted intrusion. Choose a door, a window, or an area within range that is no larger than a 20-foot cube. Until the spell ends, an alarm alerts you when a Tiny or larger creature touches or enters the warded area. When you cast the spell, you can designate creatures that won't set off the alarm. You also choose whether the alarm is mental or audible.

A mental alarm alerts you with a ping in your mind if you are within 1 mile of the warded area. This ping awakens you if you are sleeping.

An audible alarm produces the sound of a hand bell for 10 seconds within 60 feet.

If you perform this ritual a second time before the duration of the first alarm spell has ended, the first alarm immediately ends.

### Animal Messenger

_2nd-Circle Primordial Ritual (Enchantment)_

**Casting Time:** 1 minute
**Range:** 30 feet
**Components:** V, S, M (a morsel of food)
**Duration:** 24 hours

Choose a Tiny Beast you can see within range, such as a squirrel, blue jay, or bat. Specify a location, which you must have visited, and a recipient who matches a general description, such as "a person dressed in the uniform of the town guard" or "a red-haired dwarf wearing a pointed hat." Then speak a message of up to twenty-five words. The Beast travels for the duration of the spell toward the specified location, covering about 50 miles per 24 hours for a flying messenger or 25 miles for other animals.

When the messenger arrives, it delivers your message to the creature that you described, replicating the sound of your voice. Then the spell ends, and the Beast makes its way back to where you cast the spell. The messenger speaks only to a creature matching the description you gave. If the messenger doesn't reach its destination before the spell ends, the message is lost, and the Beast makes its way back to where you cast this spell.

If you attempt to cast this spell again while the first casting is still active, the second casting fails.

_At Higher Circles._ As you unlock higher circles, this ritual grows in potency. Once you have access to 3rd circle spell slots or higher, the duration of the spell increases by 48 hours for each circle you have slots for above 2nd.

### Animate Dead

_3rd-Circle Arcane and Divine Ritual (Necromancy)_

**Casting Time:** 1 minute
**Range:** 10 feet
**Components:** V, S, M (a bloodstone worth at least 10 gp, which the spell consumes)
**Duration:** Instantaneous

This spell creates an Undead servant. Choose a pile of bones or a corpse of a Medium or Small Humanoid within range. Your spell imbues the target with a foul mimicry of life, raising it as an Undead creature. The target becomes a skeleton if you chose bones or a zombie if you chose a corpse.

On each of your turns, you can use a bonus action to mentally command any creature you made with this spell if the creature is within 60 feet of you (if you control multiple creatures, you can command any or all of them at the same time, issuing the same command to each one). You decide what action the creature takes and where it moves during its next turn, or you can issue a general command, such as to guard a particular chamber or corridor.

If you issue no commands, the creature only defends itself against hostile creatures. Once given an order, the creature continues to follow it until its task is complete.

The creature is under your control for 24 hours, after which it stops obeying any command you've given it. To maintain control of the creature for another 24 hours, you must cast this spell on the creature again before the current 24-hour period ends. This use of the spell reasserts your control over a creature you have animated with this spell, rather than animating a new one.

You can't have more than 4 creatures created by this spell active at one time. If you attempt to cast this spell again while the maximum number of servants created by the first casting are still active, the servant that has been active the longest is immediately destroyed.

_At Higher Circles._ As you unlock higher circles, this ritual grows in potency. Once you have access to 4th circle spell slots or higher, the maximum number of Undead creatures you can have active at one time increases. You can animate a maximum of two additional Undead creatures for each slot level above 3rd. Each creature must come from a different corpse or pile of bones.

### Antipathy/sympathy

_8th-Circle Arcane, Divine, Primordial, and Wyrd Ritual_ (Enchantment)

**Casting Time:** 1 hour
**Range:** 60 feet
**Components:** V, S, M (either a lump of alum soaked in vinegar for the antipathy effect or a drop of honey for the sympathy effect)
**Duration:** 10 days

This spell attracts or repels creatures of your choice. You target something within range, either a Huge or smaller object or creature or an area that is no larger than a 200foot cube. Then specify a kind of intelligent creature, such as red dragons, goblins, or vampires. You invest the target with an aura that either attracts or repels the specified creatures for the duration. Choose antipathy or sympathy as the aura's effect.

Antipathy. The enchantment causes creatures of the kind you designated to feel an intense urge to leave the area and avoid the target. When such a creature can see the target or comes within 60 feet of it, the creature must succeed on a WIS save or become frightened. The creature remains frightened while it can see the target or is within 60 feet of it. While frightened by the target, the creature must use its movement to move to the nearest safe spot from which it can't see the target. If the creature moves more than 60 feet from the target and can't see it, the creature is no longer frightened, but the creature becomes frightened again if it regains sight of the target or moves within 60 feet of it.

Sympathy. The enchantment causes the specified creatures to feel an intense urge to approach the target while within 60 feet of it or able to see it. When such a creature can see the target or comes within 60 feet of it, the creature must succeed on a WIS save or use its movement on each of its turns to enter the area or move within reach of the target. When the creature has done so, it can't willingly move away from the target.

Ending the Effect. If an affected creature ends its turn while not within 60 feet of the target or able to see it, the creature makes a WIS save. On a success, the creature is no longer affected by the target and recognizes the feeling of repugnance or attraction as magical. In addition, a creature affected by the spell is allowed another WIS save every 24 hours while the spell persists. If the target damages or otherwise harms an affected creature, the affected creature can make a WIS save to end the effect.

A creature that saves against this effect is immune to it for 1 minute, after which it can be affected again.

If you attempt to cast this spell again while the effects of the first casting are still active, the effects of the first casting immediately end.

### Arcane Lock

_2nd-Circle Arcane Ritual (Abjuration)_

**Casting Time:** 1 minute
**Range:** Touch
**Components:** V, S, M (gold dust worth at least 25 gp, which the spell consumes)
**Duration:** Until dispelled

You touch a closed door, window, gate, chest, or other entryway, and it becomes locked for the duration. You and the creatures you designate when you cast this spell can open the object normally. You can also set a password that, when spoken within 5 feet of the object, suppresses this spell for 1 minute. Otherwise, it is impassable until it is broken, or the spell is dispelled or suppressed. Casting knock on the object suppresses arcane lock for 10 minutes.

While affected by this spell, the object is more difficult to break or force open; the DC to break it or pick any locks on it increases by 10.

### Arcanist's Magic Aura

_2nd-Circle Arcane Ritual (Illusion)_

**Casting Time:** 1 minute
**Range:** Touch
**Components:** V, S, M (a small square of silk and burning incense worth at least 10 gp, which the spell consumes)
**Duration:** 24 hours

You place an illusion on a creature or an object you touch so that divination spells reveal false information about it.

The target can be a willing creature or an object that isn't being carried or worn by another creature.

When you cast the spell, choose one or both of the following effects. The effect lasts for the duration. If you cast this spell on the same creature or object every day for 30 days, placing the same effect on it each time, the illusion lasts until it is dispelled.

False Aura. You change the way the target appears to spells and magical effects, such as detect magic, that detect magical auras. You can make a nonmagical object appear magical, a magical object appear nonmagical, or change the object's magical aura so that it appears to belong to a specific school of magic that you choose. When you use this effect on an object, you can make the false magic apparent to any creature that handles the item.

Mask. You change the way the target appears to spells and magical effects that detect creature types, such as a paladin's Divine Sense or the trigger of a symbol spell. You choose a creature type, and other spells and magical effects treat the target as if it were a creature of that type.

### Astral Projection

_9th-Circle Arcane and Wyrd Ritual (Necromancy)_

**Casting Time:** 1 hour
**Range:** 10 feet
**Components:** V, S, M (for each creature you affect with this spell, you must provide one jacinth worth at least 1,000 gp and one ornately carved bar of silver worth at least 100 gp, all of which the spell consumes)
**Duration:** Special

You and up to eight willing creatures within range project your astral bodies into the Astral Plane (the spell fails and the casting is wasted if you are already on that plane). The material body you leave behind is unconscious and in a state of suspended animation; it doesn't need food or air and doesn't age.

Your astral body resembles your mortal form in almost every way, replicating your game statistics and possessions.

The principal difference is the addition of a silvery cord that extends from between your shoulder blades and trails behind you, fading to invisibility after 1 foot. This cord is your tether to your material body. As long as the tether remains intact, you can find your way home. If the cord is cut - something that can happen only when an effect specifically states that it does - your soul and body are separated, killing you instantly.

Your astral form can freely travel through the Astral Plane and can pass through portals there leading to any other plane. If you enter a new plane or return to the plane you were on when casting this spell, your body and possessions are transported along the silver cord, allowing you to re-enter your body as you enter the new plane. Your astral form is a separate incarnation. Any damage or other effects that apply to it have no effect on your physical body, nor do they persist when you return to it.

The spell ends for you and your companions when you use your action to dismiss it. When the spell ends, the affected creature returns to its physical body, and it awakens.

The spell might also end early for you or one of your companions. A successful dispel magic spell used against an astral or physical body ends the spell for that creature. If a creature's original body or its astral form drops to 0 HP, the spell ends for that creature. If the spell ends and the silver cord is intact, the cord pulls the creature's astral form back to its body, ending its state of suspended animation.

If you are returned to your body prematurely, your companions remain in their astral forms and must find their own way back to their bodies, usually by dropping to 0 HP.

### Augury

_2nd-Circle Divine and Wyrd Ritual (Divination)_

**Casting Time:** 1 minute
**Range:** Self
**Components:** V, S, M (specially marked sticks, bones, or similar tokens worth at least 25 gp)
**Duration:** Instantaneous

By casting gem-inlaid sticks, rolling dragon bones, laying out ornate cards, or employing some other divining tool, you receive an omen from an otherworldly entity about the results of a specific course of action that you plan to take within the next 30 minutes. The GM chooses from the following possible omens:

- Weal, for good results
- Woe, for bad results
- Weal and woe, for both good and bad results
- Nothing, for results that aren't especially good or bad The spell doesn't take into account any possible circumstances that might change the outcome, such as the casting of additional spells or the loss or gain of a companion.

If you cast the spell two or more times before completing your next long rest, there is a cumulative 25 percent chance for each casting after the first that you get a random reading. The GM makes this roll in secret.

### Awaken

_5th-Circle Primordial Ritual (Transmutation)_

**Casting Time:** 8 hours
**Range:** Touch
**Components:** V, S, M (an agate worth at least 1,000 gp, which the spell consumes)
**Duration:** Instantaneous

After spending the casting time tracing magical pathways within a precious gemstone, you touch a Huge or smaller Beast or Plant. The target must have no INT or an INT of 3 (-4) or lower to be affected by this spell.

The target gains INT of 10 (+0) and the ability to speak one language you know. If the target is a Plant, it gains mobility, can move its limbs, roots, vines, creepers, and so forth, and gains senses similar to a human's. Your GM chooses statistics appropriate for the awakened Plant, such as the statistics for the awakened shrub or the awakened tree.

The awakened Beast or Plant is charmed by you for 30 days or until you or your companions do anything harmful to it.

When the charmed condition ends, the awakened creature chooses whether to remain friendly to you based on how you treated it while it was charmed.

### Clairvoyance

_3rd-Circle Arcane, Divine, and Wyrd Ritual (Divination)_

**Casting Time:** 10 minutes
**Range:** 1 mile
**Components:** V, S, M (a focus worth at least 100 gp, either a jeweled horn for hearing or a glass eye for seeing)
**Duration:** Concentration, up to 10 minutes

You create an invisible sensor within range in a location familiar to you (a place you have visited or seen before) or in an obvious location that is unfamiliar to you (such as behind a door, around a corner, or in a grove of trees). The sensor remains in place for the duration, and it can't be attacked or otherwise interacted with.

When you cast the spell, you choose seeing or hearing. You can use the chosen sense through the sensor as if you were in its space. As your action, you can switch between seeing and hearing.

A creature that can see the sensor (such as a creature benefiting from see invisibility or truesight) sees a luminous, intangible orb about the size of your fist.

### Clone

_8th-Circle Arcane Ritual (Necromancy)_

**Casting Time:** 1 hour
**Range:** Touch
**Components:** V, S, M (a diamond worth at least 1,000 gp; at least 1 cubic inch of flesh of the creature that is to be cloned, which the spell consumes; and a vessel worth at least 2,000 gp that has a sealable lid and is large enough to hold a Medium creature, such as a huge urn, coffin, mud-filled cyst in the ground, or crystal container filled with salt water)
**Duration:** Instantaneous

This spell grows an inert duplicate of a living creature as a safeguard against death. This clone forms inside a sealed vessel and grows to full size and maturity after 120 days; you can also choose to have the clone be a younger version of the same creature. It remains inert and endures indefinitely, as long as its vessel remains undisturbed.

At any time after the clone matures, if the original creature dies, its soul transfers to the clone, provided that the soul is free and willing to return. The clone is physically identical to the original and has the same personality, memories, and abilities, but none of the original's equipment. The original creature's physical remains, if they still exist, become inert and can't thereafter be restored to life, since the creature's soul is elsewhere.

If you attempt to cast this spell to create a clone of a creature that already has a clone created by this spell, the spell fails.

### Commune With Nature

_5th-Circle Primordial Ritual (Divination)_

**Casting Time:** 1 minute
**Range:** Self
**Components:** V, S, M (a forked stick, a bowl of purified water, and a polished stone or bone of an animal native to where you are)
**Duration:** Instantaneous

You must be outdoors to cast this spell. When you do so, the spell gives you knowledge of the land within 3 miles of you. In caves and other natural underground settings, the radius is limited to 300 feet. The spell doesn't function where nature has been replaced by construction, such as in dungeons and towns.

You instantly know up to three facts of your choice about any of the following subjects as they relate to the area:

- Terrain and bodies of water
- Prevalent plants, minerals, animals, or peoples

- Powerful Celestials, Fey, Fiends, Elementals, or Undead
- Influence from other planes of existence
- Buildings

For example, you could determine the location of powerful Undead in the area, the location of major sources of safe drinking water, and the location of any nearby towns.

Once you perform this ritual, you can't do so again until 24 hours have passed.

### Contact Other Plane

_5th-Circle Arcane and Wyrd Ritual (Divination)_

**Casting Time:** 10 minutes
**Range:** Self
**Components:** V, M (incense or a sacrificial offering appropriate for the entity contacted worth 25 gp, which the spell consumes)
**Duration:** 1 minute

You mentally contact a demigod, the spirit of a long-dead sage, or some entity from another plane. Contacting this extraplanar being can strain or even break your mind. When you cast this spell, make a DC 15 INT save. On a failure, you take 6d6 psychic damage and become incapacitated until you finish a long rest. While incapacitated in this way, you can't take actions, can't understand what other creatures say, can't read, and speak only in gibberish. A greater restoration spell cast on you ends this effect.

On a successful save, you can ask the entity up to five questions. You must ask your questions before the spell ends. The GM answers each question with one word, such as "yes," "no," "maybe," "never," "irrelevant," or "unclear" (if the entity doesn't know the answer to the question). If a one-word answer would be misleading, the GM might instead offer a short phrase as an answer.

If you cast the spell two or more times before finishing your next long rest, there is a cumulative 25 percent chance for each casting that you get no answer. The GM makes this roll in secret. If you receive no answer, you can't attempt to cast this spell again until 24 hours have passed.

### Contingency

_6th-Circle Arcane Ritual (Evocation)_

**Casting Time:** 10 minutes
**Range:** Self
**Components:** V, S, M (a statuette of yourself carved from ivory and decorated with gems worth at least 1,500 gp)
**Duration:** 10 days

Choose a spell of 5th circle or lower that you can cast, that has a casting time of 1 action, and that can target you. You cast that spell - called the contingent spell - as part of casting contingency, expending a spell slot for the contingent spell, but the contingent spell doesn't come into effect.

Instead, it takes effect when a certain circumstance occurs.

You describe that circumstance when you cast the two spells. For example, a contingency cast with water breathing might stipulate that water breathing comes into effect when you are engulfed in water or a similar liquid.

The contingent spell takes effect immediately after the circumstance is met for the first time, whether or not you want it to, and then contingency ends.

The contingent spell takes effect only on you, even if it can normally target others. You can use only one contingency spell at a time. If you cast this spell again, the effect of another contingency spell on you ends.

Also, contingency ends on you if its material component is ever not on your person.

### Control Weather

_8th-Circle Divine and Primordial Ritual (Transmutation)_

**Casting Time:** 10 minutes
**Range:** Self (5-mile radius)
**Components:** V, S, M (burning incense and bits of earth and wood mixed in water)
**Duration:** Concentration, up to 8 hours

You take control of the weather within 5 miles of you for the duration. You must be outdoors to cast this spell.

Moving to a place where you don't have a clear path to the sky ends the spell early.

When you cast the spell, you change the current weather conditions, which are determined by the GM based on the climate and season. You can change precipitation, temperature, and wind. It takes 1d4 × 10 minutes for the new conditions to take effect.

Once they do, you can change the conditions again. When the spell ends, the weather gradually returns to normal.

When you change the weather conditions, find a current condition on the following tables and change its stage by one, up or down. When changing the wind, you can change its direction.

#### Table: Weather Precipitation

| STAGE | CONDITION                |
| ----: | ------------------------ |
|     1 | Clear                    |
|     2 | Overcast or ground fog   |
|     3 | Rain, hail, or snow      |
|     4 | Torrential precipitation |

#### Table: Weather Temperature

| STAGE | CONDITION    |
| ----: | ------------ |
|     1 | Extreme heat |
|     2 | Hot          |
|     3 | Warm         |
|     4 | Cool         |
|     5 | Cold         |
|     6 | Extreme cold |

#### Table: Weather Wind

| STAGE | CONDITION     |
| ----: | ------------- |
|     1 | Calm          |
|     2 | Moderate wind |
|     3 | Strong wind   |
|     4 | Gale winds    |

### Create Familiar

_1st-Circle Arcane Ritual (Transmutation)_

**Casting Time:** 1 hour
**Range:** 5 feet
**Components:** V, S, M (a life-sized statue, puppet, stuffed animal, or other suitable vessel worth at least 10 gp, which the spell consumes)
**Duration:** Instantaneous

As part of this ritual, you imbue your chosen vessel with a spark of your own life force to create an arcane familiar.

This familiar assumes an animal form you choose from the following options: **bat**, **cat**, **crab**, **frog (toad)**, **hawk**, **lizard**, **octopus**, **owl**, **poisonous snake**, **fish (quipper)**, **rat**, **raven**, **seahorse**, **spider**, or **weasel**. Upon completion of the ritual, your familiar appears in an unoccupied space within 5 feet of you. The familiar has the statistics of the chosen form, though it is considered a Construct rather than a Beast for any relevant spells or effects.

**Bound in Blood.** When your familiar first appears, your hit point maximum decreases by one. If you permanently dismiss your familiar or it is otherwise permanently destroyed, your hit point maximum returns to normal. This reduction can't be offset by any means as long as your familiar lives.

**Communicating with Your Familiar.** While your familiar is on the same plane or realm of existence as you, it can magically convey what it sees or senses to you, and you can communicate with it telepathically.

**Controlling Your Familiar.** Your familiar acts independently of you, but it always obeys your commands. In combat, it rolls its own initiative and acts on its own turn. A familiar can't attack, but it can take other actions as normal.

When you cast a spell with a range of touch, your familiar can deliver the spell as if it had cast the spell. Your familiar must be within 100 feet of you to do so, and it must use its reaction to deliver the spell when you cast it. If the spell requires an attack roll, you use your spell attack modifier for the roll.

As an action, you can touch your familiar to reincorporate it into your body. When you do so, it melds into your skin, where it awaits your summons. While it is incorporated, you can use an action to expel it from your body, causing it to appear in an unoccupied space within 5 feet of you.

**Destroying Your Familiar.** If a familiar drops to 0 HP, its body is instantly destroyed. If you still live, your familiar regrows a new body in 1 hour, regaining all its hit points and becoming active again. The new body appears in an unoccupied space within 5 feet of you. If you die, your familiar is permanently destroyed, and the ritual must be performed again to create a new familiar. At any time, you can use an action to permanently dismiss your familiar, which instantly destroys it.

You can have only one familiar at a time. If you attempt to cast this spell while your current familiar still lives, the ritual fails.

### Create Undead

_6th-Circle Arcane and Divine Ritual (Necromancy)_

**Casting Time:** 1 minute
**Range:** 10 feet
**Components:** V, S, M (one pot filled with grave dirt, one pot filled with brackish water, and one 150 gp black onyx stone for each corpse, which the spell consumes)
**Duration:** Instantaneous

You can cast this spell only at night. Choose up to three corpses of Medium or Small Humanoids within range.

Each corpse becomes a ghoul under your control (the GM has statistics for these creatures).

As a bonus action on each of your turns, you can mentally command any creature you animated with this spell if the creature is within 120 feet of you (if you control multiple creatures, you can command any or all of them at the same time, issuing the same command to each one). You decide what action the creature will take and where it will move during its next turn, or you can issue a general command, such as to guard a particular chamber or corridor. If you issue no commands, the creature only defends itself against hostile creatures. Once given an order, the creatures continues to follow it until its task is complete.

The creature is under your control for 24 hours, after which it stops obeying any command you have given it. To maintain control of the creatures for another 24 hours, you must cast this spell on the creature before the current 24-hour period ends. This use of the spell reasserts your control over up to three creatures you have animated with this spell, rather than animating new ones.

If you attempt to cast this spell again while Undead created by the first casting are still active, the Undead created from the first casting are no longer under your control and immediately become hostile toward you.

_At Higher Circles._ As you unlock higher circles, this ritual grows in potency. Once you have access to 6th-circle spell slots, you can animate or reassert control over four ghouls.

Once you have access to 8th-circle spell slots, you can animate or reassert control over five ghouls or two ghasts or wights. Once you have access to 9th-circle spell slots, you can animate or reassert control over six ghouls, three ghasts or wights, or two mummies.

### Creation

_5th-Circle Arcane Ritual (Illusion)_

**Casting Time:** 1 minute
**Range:** 30 feet
**Components:** V, S, M (a tiny piece of matter of the same type of the item you plan to create)
**Duration:** Special

You pull wisps of shadow from the Shadow Realm to create a nonliving object or vegetable matter within range: soft goods, rope, wood, or something similar. You can also use this spell to create mineral objects such as stone, crystal, or metal. The object created must be no larger than a 5-foot cube, and the object must be of a form and material that you have seen before.

The duration depends on the object's material. If it is composed of multiple materials, use the shortest duration.

Using any material created by this spell as another spell's material component causes that spell to fail. If you attempt to cast this spell a second time while material created by the first casting still exists, the material created by the first casting is destroyed.

_At Higher Circles._ As you unlock higher circles, this ritual grows in potency. Once you have access to 6th-circle spell slots, the cube increases by 5 feet for each slot you have access to above 5th.

#### Table: Creation Materials

| MATERIAL         | DURATION | MATERIAL              | DURATION   |
| ---------------- | -------- | --------------------- | ---------- |
| Vegetable matter | 1 day    | Gems                  | 10 minutes |
| Stone or crystal | 12 hours | Adamantine or mithral | 1 minute   |
| Precious metals  | 1 hour   |                       |            |

### Detect Poison And Disease

_1st-Circle Divine and Primordial Ritual (Divination)_

**Casting Time:** 1 minute
**Range:** Self
**Components:** V, S, M (a dried snake rattle)
**Duration:** Concentration, up to 10 minutes

For the duration, you can sense the presence and location of poisons and diseases within 30 feet of you. This spell also detects the presence of creatures affected by an ongoing poison or disease, creatures that deal poison damage, and creatures that can infect other creatures with a disease, such as ghouls and mummies. You also identify the kind of poison, creature, or disease in each case.

The spell can penetrate most barriers, but it is blocked by 1 foot of stone, 1 inch of common metal, a thin sheet of lead, or 3 feet of wood or dirt.

### Divination

_4th-Circle Divine Ritual (Divination)_

**Casting Time:** 10 minutes
**Range:** Self
**Components:** V, S, M (incense or a sacrificial offering appropriate for your religion worth 25 gp, which the spell consumes)
**Duration:** 1 minute

Your magic and an offering put you in contact with your deity or divine proxy. When you cast this spell, you can use it in one of the following ways:

- **Read the Future.** You ask a single question concerning a specific goal, event, or activity to occur within 7 days. The GM offers a truthful reply. The reply might be a short phrase, a cryptic rhyme, or an omen. The spell doesn't take into account any possible circumstances that might change the outcome, such as the casting of additional spells or the loss or gain of a companion.

- **Read the Present.** You ask up to three questions that can be answered with a yes or no. You must ask your questions before the spell ends. You receive a correct answer for each question. Divine beings aren't necessarily omniscient, so you might receive "unclear" as an answer if a question pertains to information that lies beyond the deity's knowledge or pertains to future events that have not yet transpired. In a case where a one-word answer could be misleading or contrary to the deity's interests, the GM might offer a short phrase as an answer instead to provide needed clarification.

If you cast the spell two or more times before finishing your next long rest, there is a cumulative 25 percent chance for each casting that you get no answer. The GM makes this roll in secret. If you receive no answer, you can't attempt to cast this spell again until 24 hours have passed.

### Dream

_5th-Circle Arcane and Wyrd Ritual (Illusion)_

**Casting Time:** 1 minute
**Range:** Special
**Components:** V, S, M (a handful of sand, a dab of ink, and a writing quill plucked from a sleeping bird)
**Duration:** 8 hours

This spell shapes a creature's dreams. Choose a creature known to you as the target of this spell. The target must be on the same plane of existence as you. Creatures that don't sleep, such as elves, can't be contacted by this spell. You or a willing creature you touch enters a trance state, acting as a messenger. While in the trance, the messenger is aware of its surroundings but can't take actions or move.

If the target is asleep, the messenger appears in the target's dreams and can converse with the target as long as it remains asleep, through the duration of the spell. The messenger can also shape the environment of the dream, creating landscapes, objects, and other images. The messenger can emerge from the trance at any time, ending the effect of the spell early. The target recalls the dream perfectly upon waking. If the target is awake when you cast the spell, the messenger knows it and can either end the trance (and the spell) or wait for the target to fall asleep, at which point the messenger appears in the target's dreams.

You can make the messenger appear monstrous and terrifying to the target. If you do, the messenger can deliver a message of no more than ten words and then the target must make a WIS save. On a failed save, echoes of the phantasmal monstrosity spawn a nightmare that lasts the duration of the target's sleep and prevents the target from gaining any benefit from that rest. In addition, when the target wakes up, it takes 3d6 psychic damage.

If you have a body part, lock of hair, clipping from a nail, or similar portion of the target's body, the target makes its save with disadvantage.

Once you cast this spell, you can't do so again until you complete a long rest.

### Fabricate

_4th-Circle Arcane Ritual (Transmutation)_

**Casting Time:** 10 minutes
**Range:** 120 feet
**Components:** V, S
**Duration:** Instantaneous

You convert raw materials into products of the same material. For example, you can fabricate a wooden bridge from a clump of trees, a rope from a patch of hemp, and clothes from flax or wool.

Choose raw materials that you can see within range. You can fabricate a Large or smaller object (contained within a 10-foot cube, or eight connected 5-foot cubes), given a sufficient quantity of raw material. If you are working with metal, stone, or another mineral substance, however, the fabricated object can be no larger than Medium (contained within a single 5-foot cube). The quality of objects made by the spell is commensurate with the quality of the raw materials.

Creatures or magic items can't be created or transmuted by this spell. You also can't use it to create items that ordinarily require a high degree of craftsmanship, such as jewelry, weapons, glass, or armor, unless you have proficiency with the type of artisan's tools used to craft such objects.

Once you cast this spell, you can't do so again until you complete a long rest.

### Find Familiar

_1st-Circle Wyrd Ritual (Conjuration)_

**Casting Time:** 1 hour
**Range:** 10 feet
**Components:** V, S, M (charcoal, incense, and herbs collectively worth 10 gp, which the spell consumes)
**Duration:** Instantaneous

You gain the service of a familiar, a spirit that takes one of the following Beast forms you choose: bat, cat, crab, frog (toad), hawk, lizard, octopus, owl, poisonous snake, fish (quipper), rat, raven, seahorse, spider, or weasel.

Upon completion of the ritual, your familiar appears in an unoccupied space within 10 feet of you. The familiar has the statistics of the chosen form, though it is considered a Celestial, Fey, or Fiend (your choice) rather than a Beast for any relevant spells or effects.

Communicating with Your Familiar. While your familiar is on the same plane or realm of existence as you, it can magically convey what it sees or senses to you, and you can communicate with it telepathically.

Controlling Your Familiar. Your familiar acts independently of you, but it always obeys your commands.

In combat, it rolls its own initiative and acts on its own turn. A familiar can't attack, but it can take other actions as normal.

When you cast a spell with a range of touch, your familiar can deliver the spell as if it had cast the spell. Your familiar must be within 100 feet of you to do so, and it must use its reaction to deliver the spell when you cast it. If the spell requires an attack roll, you use your spell attack modifier for the roll.

As an action, you can temporarily dismiss your familiar.

It disappears into a pocket dimension where it awaits your summons. As an action while it is temporarily dismissed, you can cause it to reappear in any unoccupied space within 30 feet of you.

Destroying Your Familiar. If a familiar drops to 0 HP, it disappears, leaving behind no physical form. It reappears after you cast this spell again. Alternatively, you can use an action to dismiss your familiar forever. When you do so, the next time you cast this spell, a different familiar of your choosing is summoned.

You can't have more than one familiar at a time. If you cast this spell while you already have a familiar, you instead cause it to adopt a new form. Choose a form from the familiars list. Your familiar transforms into the chosen creature.

### Find Steed

_2nd-Circle Divine and Primordial Ritual (Conjuration)_

**Casting Time:** 10 minutes
**Range:** 30 feet
**Components:** V, S
**Duration:** Instantaneous

You summon a spirit that assumes the form of an unusually intelligent, strong, and loyal steed, creating a long-lasting bond with it. Appearing in an unoccupied space within range, the steed takes a form that you choose: warhorse, pony, camel, elk, or mastiff. (Your GM might allow other animals to be summoned as steeds.) The steed has the statistics of its chosen form, though it is a Celestial, Fey, or Fiend (your choice) instead of its normal type. However, if the form has an INT of 5 (-3) or lower, your steed's INT becomes 6 (-2), and it gains the ability to understand one language of your choice that you speak.

Your steed serves you as a mount, both in combat and out. You have an instinctive bond that allows you to fight together as a seamless unit. While mounted on your steed, you can make any spell you cast that targets only you also target your steed.

When the steed drops to 0 HP, it disappears, leaving no physical form. You can also dismiss your steed at any time as an action, causing it to disappear. In either case, casting this spell again summons the same steed, restored to its hit point maximum.

While your steed is within 1 mile of you, you can communicate with it telepathically. You can't have more than one steed bonded by this spell at a time. As an action, you can release the steed from its bond at any time, causing it to disappear.

### Find The Path

_6th-Circle Primordial Ritual (Divination)_

**Casting Time:** 1 minute
**Range:** Self
**Components:** V, S, M (a set of divinatory tools - such as bones, ivory sticks, cards, teeth, or carved runes - worth 100 gp and an object from the location you wish to find)
**Duration:** Concentration, up to 1 day

This spell allows you to find the shortest, most direct physical route to a specific fixed location that you are familiar with on the same plane of existence. If you name a destination on another plane of existence, a destination that moves (such as a mobile fortress), or a destination that isn't specific (such as "a green dragon's lair"), the spell fails.

For the duration, as long as you are on the same plane of existence as the destination, you know how far it is and in what direction it lies. While you are traveling there, when you are presented with a choice of paths along the way, you automatically determine which path is the shortest and most direct route (but not necessarily the safest route) to the destination.

### Forbiddance

_6th-Circle Divine Ritual (Abjuration)_

**Casting Time:** 10 minutes
**Range:** Touch
**Components:** V, S, M (a sprinkling of holy water, rare incense, and powdered ruby worth at least 1,000 gp)
**Duration:** 1 day

You create a ward against magical travel that protects up to 40,000 square feet of floor space to a height of 30 feet above the floor. For the duration, creatures can't teleport into the area or use portals, such as those created by the gate spell, to enter the area. The spell proofs the area against planar travel and therefore prevents creatures from accessing the area by way of the Astral Plane, Ethereal Plane, Shadow Realm, Summerlands, or the plane shift spell.

In addition, the spell damages certain types of creatures that you choose when you cast it. Choose one or more of the following: Celestials, Elementals, Fey, Fiends, Undead, and creatures with the Outsider tag. When a chosen creature enters the spell's area for the first time on a turn or starts its turn there, the creature takes 5d10 radiant or necrotic damage (your choice when you cast this spell).

When you cast this spell, you can designate a password. A creature that speaks the password as it enters the area takes no damage from the spell.

The spell's area can't overlap with the area of another forbiddance spell. If you cast forbiddance every day for 30 days in the same location, the spell lasts until it is dispelled, and the material components are consumed on the last casting.

### Foresight

_9th-Circle Arcane and Divine Ritual (Divination)_

**Casting Time:** 1 minute
**Range:** Touch
**Components:** V, S, M (a gilded hourglass worth at least 500 gp, which the spell consumes)
**Duration:** 8 hours

You touch a willing creature and bestow a limited ability to see into the immediate future. For the duration, the target can't be surprised and has advantage on attack rolls, ability checks, and saves. In addition, other creatures have disadvantage on attack rolls against the target for the duration.

This spell immediately ends if you cast it again before its duration ends.

Once you target a creature with this spell, the same creature can't gain the benefits of this spell until 7 days have passed.

### Geas

_5th-Circle Arcane, Divine, and Wyrd Ritual (Enchantment)_

**Casting Time:** 1 minute
**Range:** 60 feet
**Components:** V, M (a set of silver manacles worth 50 gp, which the spell consumes)
**Duration:** 30 days

You place a magical command on a creature that you can see within range, forcing it to carry out some service or refrain from some action or course of activity as you decide. If the creature can understand you, it must succeed on a WIS save or become charmed by you for the duration.

While the creature is charmed by you, it takes 5d10 psychic damage each time it acts in a manner directly counter to your instructions, but no more than once each day. A creature that can't understand you is unaffected by the spell.

You can issue any command you choose. However, should you issue a command that would result in certain death, the spell ends.

You can end the spell early by using an action to dismiss it.

A remove curse, greater restoration, or wish spell also ends it.

_At Higher Circles._ As you unlock higher circles, this ritual grows in potency. Once you have access to 7th-circle spell slots, the duration of this spell is 1 year. Once you have access to 9th-circle spell slots, the spell lasts until it is ended by one of the spells mentioned above.

### Glyph Of Warding

_3rd-Circle Arcane Ritual (Abjuration)_

**Casting Time:** 1 hour
**Range:** Touch
**Components:** V, S, M (incense and powdered diamond worth at least 200 gp, which the spell consumes)
**Duration:** Until dispelled or triggered

When you cast this spell, you inscribe a glyph that harms other creatures, either upon a surface (such as a table or a section of floor or wall) or within an object that can be closed (such as a book, a scroll, or a treasure chest) to conceal the glyph. If you choose a surface, the glyph can cover an area of the surface no larger than 10 feet in diameter. If you choose an object, that object must remain in its place; if the object is moved more than 10 feet from where you cast this spell, the glyph is broken, and the spell ends without being triggered.

The glyph is nearly invisible and requires a successful INT (Investigation) check against your spell save DC to be found.

You decide what triggers the glyph when you cast the spell. For glyphs inscribed on a surface, the most typical triggers include touching or standing on the glyph, removing another object covering the glyph, approaching within a certain distance of the glyph, or manipulating the object on which the glyph is inscribed. For glyphs inscribed within an object, the most common triggers include opening that object, approaching within a certain distance of the object, or seeing or reading the glyph. Once a glyph is triggered, this spell ends.

You can further refine the trigger so the spell activates only under certain circumstances or according to physical characteristics (such as height or weight) or creature kind (for example, the ward could be set to affect Aberrations or drow). You can also set conditions for creatures that don't trigger the glyph, such as those who say a certain password.

When you inscribe the glyph, choose explosive runes or a spell glyph.

Explosive Runes. When triggered, the glyph erupts with magical energy in a 20-foot-radius sphere centered on the glyph. The sphere spreads around corners. Each creature in the area must make a DEX save. On a failure, a creature takes 5d8 acid, cold, fire, lightning, or thunder damage (your choice when you create the glyph), or half as much damage on a success.

Spell Glyph. You can store a known spell of 3rd circle or lower in the glyph by casting it as part of creating the glyph. The spell must target a single creature or an area to be stored. The spell being stored has no immediate effect when cast in this way. When the glyph is triggered, the stored spell is cast. If the spell has a target, it targets the creature that triggered the glyph. If the spell affects an area, the area is centered on that creature. If the spell summons hostile creatures or creates harmful objects or traps, they appear as close as possible to the intruder and attack it. If the spell requires concentration, it lasts until the end of its full duration.

_At Higher Circles._ As you unlock higher circles, this ritual grows in potency. Once you have access to 4th-circle spell slots, the damage of an explosive runes glyph increases by 1d8 for each slot you have access to above 3rd. If you create a spell glyph, you can store any spell of up to the same circle as the highest circle you have access to.

### Guards And Wards

_6th-Circle Arcane Ritual (Abjuration)_

**Casting Time:** 10 minutes
**Range:** Touch
**Components:** V, S, M (burning incense, a small measure of brimstone and oil, a knotted string, and a silver rod worth at least 10 gp)
**Duration:** 24 hours

You create a ward that protects up to 2,500 square feet of floor space (an area 50 feet square, or one hundred 5-foot squares or twenty-five 10-foot squares). The warded area can be up to 20 feet tall and shaped as you desire. You can ward several stories of a stronghold by dividing the area among them, as long as you can walk into each contiguous area while you are casting the spell.

When you cast this spell, you can specify individuals that are unaffected by any or all of the effects that you choose.

You can also specify a password that, when spoken aloud, makes the speaker immune to these effects.

Guards and wards creates the following effects within the warded area.

Corridors. Fog fills all the warded corridors, making them heavily obscured. In addition, at each intersection or branching passage offering a choice of direction, there is a 50 percent chance that a creature other than you will believe it is going in the opposite direction from the one it chooses.

Doors. All doors in the warded area are magically locked as if sealed by an arcane lock spell. In addition, you can cover up to ten doors with an illusion (equivalent to the illusory object function of the minor illusion spell) to make them appear as plain sections of wall.

Stairs. Webs fill all stairs in the warded area from top to bottom, as the web spell. These strands regrow in 10 minutes if they are burned or torn away while guards and wards lasts.

Other Spell Effect. You can place your choice of one of the following magical effects within the warded area:

- Place dancing lights in four corridors. You can designate a simple program that the lights repeat as long as guards and wards lasts.
- Place magic mouth in two locations.
- Place stinking cloud in two locations. The vapors appear in the places you designate; they return within 10 minutes if dispersed by wind while guards and wards lasts.
- Place a constant gust of wind in one corridor or room.
- Place a suggestion in one location. You select an area of up to 5 feet square, and any creature that enters or passes through the area receives the suggestion mentally.

The whole warded area radiates magic. A dispel magic cast on a specific effect, if successful, removes only that effect.

You can create a permanently guarded and warded area by casting this spell there every day for one year.

### Hallow

_5th-Circle Divine Ritual (Abjuration)_

**Casting Time:** 24 hours
**Range:** Touch
**Components:** V, S, M (herbs, oils, and incense worth at least 1,000 gp, which the spell consumes)
**Duration:** Until dispelled

You touch a point and infuse an area around it with holy (or unholy) power. The area can have a radius up to 60 feet, and the spell fails if the radius includes an area already under the effect of a hallow spell. The affected area is subject to the following effects.

First, Celestials, Elementals, Fey, Fiends, Undead, and creatures with the Outsider tag can't enter the area, nor can such creatures charm, frighten, or possess creatures within it. Any creature charmed, frightened, or possessed by such a creature is no longer charmed, frightened, or possessed upon entering the area. You can exclude one or more of those types of creatures from this effect.

Second, you can bind an extra effect to the area. Choose an effect from the following list, or choose an effect offered by the GM. Some of these effects apply to creatures in the area; you can designate whether the effect applies to all creatures, creatures that follow a specific deity or leader, or creatures of a specific sort, such as orcs or trolls. When a creature that would be affected enters the spell's area for the first time on a turn or starts its turn there, it can make a CHA save. On a success, the creature ignores the extra effect until it leaves the area.

**Courage.** Affected creatures can't be frightened while in the area.

**Darkness.** Darkness fills the area. Normal light, as well as magical light created by spells of a lower circle than the slot you used to cast this spell, can't illuminate the area.

**Daylight.** Bright light fills the area. Magical darkness created by spells of a lower circle than the slot you used to cast this spell can't extinguish the light.

**Energy Protection.** Affected creatures in the area have resistance to one damage type of your choice except for bludgeoning, piercing, or slashing.

**Energy Vulnerability.** Affected creatures in the area have vulnerability to one damage type of your choice except for bludgeoning, piercing, or slashing.

**Everlasting Rest.** Dead bodies interred in the area can't be turned into Undead.

**Extradimensional Interference.** Affected creatures can't move or travel using teleportation or by extradimensional or interplanar means.

**Fear.** Affected creatures are frightened while in the area.

**Silence.** No sound can emanate from within the area, and no sound can reach into it.

**Tongues.** Affected creatures can communicate with any other creature in the area, even if they don't share a common language.

### Hallucinatory Terrain

_4th-Circle Arcane and Wyrd Ritual (Illusion)_

**Casting Time:** 10 minutes
**Range:** 300 feet
**Components:** V, S, M (a stone, a twig, and a bit of green plant)
**Duration:** 24 hours

You make natural terrain in a 150-foot cube in range look, sound, and smell like some other sort of natural terrain.

Thus, open fields or a road can be made to resemble a swamp, hill, crevasse, or some other difficult or impassable terrain. A pond can be made to seem like a grassy meadow, a precipice like a gentle slope, or a rock-strewn gully like a wide and smooth road. Manufactured structures, equipment, and creatures within the area aren't changed in appearance.

The tactile characteristics of the terrain are unchanged, so creatures entering the area are likely to see through the illusion. If the difference isn't obvious by touch, a creature carefully examining the illusion can attempt an INT (Investigation) check against your spell save DC to disbelieve it. A creature who discerns the illusion for what it is sees it as a vague image superimposed on the terrain.

### Heroes' Feast

_6th-Circle Divine and Primordial Ritual (Conjuration)_

**Casting Time:** 10 minutes
**Range:** 30 feet
**Components:** V, S, M (a gem-encrusted bowl worth at least 1,000 gp, which the spell consumes)
**Duration:** Instantaneous

You bring forth a great feast, including magnificent food and drink. The feast takes 1 hour to consume and disappears at the end of that time, and the beneficial effects don't set in until this hour is over. Up to twelve other creatures can partake of the feast.

A creature that partakes of the feast gains several benefits.

The creature is cured of all diseases and poison, becomes immune to poison and being frightened, and makes all WIS saves with advantage. Its hit point maximum also increases by 2d10, and it gains the same number of hit points. These benefits last for 24 hours.

You must complete a long rest before you can cast this spell again.

### Identify

_1st-Circle Arcane Ritual (Divination)_

**Casting Time:** 1 minute
**Range:** Touch
**Components:** V, S, M (a pearl worth at least 100 gp and an owl feather)
**Duration:** Instantaneous

You choose one object that you must touch throughout the casting of the spell. If it is a magic item or some other magic-imbued object, you learn its properties and how to use them, whether it requires attunement to use, and how many charges it has, if any. You learn whether any spells are affecting the item and what they are. If the item was created by a spell, you learn which spell created it.

If you instead touch a creature throughout the casting, you learn what spells, if any, are currently affecting it.

### Illusory Script

_1st-Circle Arcane and Wyrd Ritual (Illusion)_

**Casting Time:** 1 minute
**Range:** Touch
**Components:** V, S, M (a lead-based ink worth at least 10 gp, which the spell consumes)
**Duration:** 10 days

You write on parchment, paper, or some other suitable writing material and imbue it with a potent illusion that lasts for the duration.

To you and any creatures you designate when you cast the spell, the writing appears normal, written in your hand, and conveys whatever meaning you intended when you wrote the text. To all others, the writing appears as if it were written in an unknown or magical script that is unintelligible. Alternatively, you can cause the writing to appear to be an entirely different message, written in a different hand and language, though the language must be one you know.

If the spell is dispelled, the original script and the illusion both disappear.

A creature with truesight can read the hidden message.

### Imprisonment

_9th-Circle Arcane and Wyrd Ritual (Abjuration)_

**Casting Time:** 1 minute
**Range:** 30 feet
**Components:** V, S, M (a vellum depiction or a carved statuette in the likeness of the target and a special component that varies according to the version of the spell you choose worth at least 500 gp per hit die of the target)
**Duration:** Until dispelled

You create a magical restraint to hold a creature that you can see within range. The target must succeed on a WIS save or be bound by the spell; if it succeeds, it is immune to this spell if you cast it again. While affected by this spell, the creature doesn't need to breathe, eat, or drink, and it doesn't age.

Divination spells can't locate or perceive the target.

When you cast the spell, you choose one of the following forms of imprisonment.

Burial. The target is entombed far beneath the earth in a sphere of magical force that is just large enough to contain the target. Nothing can pass through the sphere, nor can any creature teleport or use planar travel to get into or out of it.

The special component for this version of the spell is a small mithral orb.

Chaining. Heavy chains, firmly rooted in the ground, hold the target in place. The target is restrained until the spell ends, and it can't move or be moved by any means until then.

The special component for this version of the spell is a fine chain of precious metal.

Hedged Prison. The spell transports the target into a tiny demiplane that is warded against teleportation and planar travel. The demiplane can be a labyrinth, a cage, a tower, or any similar confined structure or area of your choice.

The special component for this version of the spell is a miniature representation of the prison made from jade.

Minimus Containment. The target shrinks to a height of 1 inch and is imprisoned inside a gemstone or similar object. Light can pass through the gemstone normally (allowing the target to see out and other creatures to see in), but nothing else can pass through, even by means of teleportation or planar travel. The gemstone can't be cut or broken while the spell remains in effect.

The special component for this version of the spell is a large, transparent gemstone such as a corundum, diamond, or ruby.

Slumber. The target falls asleep and can't be awoken.

The special component for this version of the spell consists of rare soporific herbs.

Ending the Spell. During the casting of the spell, in any of its versions, you can specify a condition that will cause the spell to end and release the target. The condition can be as specific or as elaborate as you choose, but the GM must agree that the condition is reasonable and has a likelihood of coming to pass.

The conditions can be based on a creature's name, identity, or deity but otherwise must be based on observable actions or qualities and not based on intangibles such as level, CR, class, or hit points.

A dispel magic spell can end the spell only if it is cast as a 9th-circle spell, targeting either the prison or the special component used to create it.

You can use a particular special component to create only one prison at a time. If you cast the spell again using the same component, the target of the first casting is immediately freed from its binding.

### Instant Summons

_6th-Circle Arcane Ritual (Conjuration)_

**Casting Time:** 1 minute
**Range:** Touch
**Components:** V, S, M (a sapphire worth 1,000 gp)
**Duration:** Until dispelled

You touch an item weighing 10 pounds or less whose longest dimension is 6 feet or less. The spell leaves an invisible mark on its surface and invisibly inscribes the name of the item on the sapphire you use as the material component. Each time you cast this spell, you must use a different sapphire.

At any time thereafter, you can use your action to speak the item's name and crush the sapphire, destroying it. The item instantly appears in your hand regardless of physical or planar distances, and the spell ends.

If another creature is holding or carrying the item, crushing the sapphire doesn't transport the item to you, but instead you learn who the creature possessing the item is and roughly where that creature is located at that moment.

Dispel magic or a similar effect successfully applied to the sapphire ends this spell's effect.

### Locate

_2nd-Circle Arcane, Divine, Primordial, and Wyrd Ritual_ (Divination)

**Casting Time:** 1 minute
**Range:** Self (1 mile)
**Components:** V, S, M (a figurine of a bloodhound worth at least 25 gp, which the spell consumes)
**Duration:** Concentration, up to 10 minutes

Describe or name a particular kind of object (such as a certain kind of apparel, jewelry, tool, or weapon) or particular kind of creature (such as a human or a unicorn).

If a suitable target is within range of the spell, you sense the direction to the nearest creature or object within the spell's range. If the target is moving, you know the direction of its movement.

This spell can't locate a creature or object if it in is a different form, such as being under the effects of a polymorph spell, or if the target is shielded by an effect that blocks divination magic, like the nondetection spell.

You can only have a single casting of locate active on yourself at one time. If you cast this spell a second time, the first casting immediately ends.

_At Higher Circles._ As you unlock higher circles, this ritual grows in potency. Once you have access to 4th-circle spell slots, you can use this spell to locate a specific creature or object that is familiar to you. In addition, the duration of this spell increases to concentration, up to 1 hour.

### Magic Circle

_3rd-Circle Arcane, Divine, and Wyrd Ritual (Abjuration)_

**Casting Time:** 1 minute
**Range:** 10 feet
**Components:** V, S, M (holy water or powdered silver and iron worth at least 100 gp, which the spell consumes)
**Duration:** 1 hour

You create a 10-foot-radius, 20-foot-tall cylinder of magical energy centered on a point on the ground that you can see within range. Glowing runes appear wherever the cylinder intersects with the floor or other surface.

Choose one or more of the following types of creatures: Celestials, Elementals, Fey, Fiends, or Undead. The circle affects a creature of the chosen type in the following ways:

- The creature can't willingly enter the cylinder by nonmagical means. If the creature tries to use teleportation or interplanar travel to do so, it must first succeed on a CHA save.

- The creature has disadvantage on attack rolls against targets within the cylinder.
- Targets within the cylinder can't be charmed, frightened, or possessed by the creature.

When you cast this spell, you can elect to cause its magic to operate in the reverse direction, preventing a creature of the specified type from leaving the cylinder and protecting targets outside it.

_At Higher Circles._ As you unlock higher circles, this ritual grows in potency. Once you have access to 4th-circle spell slots, the duration increases by 1 hour for each slot you have access to above 3rd.

### Magic Jar

_6th-Circle Wyrd Ritual (Necromancy)_

**Casting Time:** 1 minute
**Range:** Self
**Components:** V, S, M (a gem, crystal, or ornamental container worth at least 500 gp)
**Duration:** Until dispelled

Your body falls into a catatonic state as your soul leaves it and enters the container you used for the spell's material component. While your soul inhabits the container, you are aware of your surroundings as if you were in the container's space. You can't move or use reactions. The only action you can take is to project your soul up to 100 feet out of the container, either returning to your living body (and ending the spell) or attempting to possess a humanoid's body.

You can attempt to possess any Humanoid within 100 feet of you that you can see (creatures warded by a protection from evil and good or magic circle spell can't be possessed).

The target must make a CHA save. On a failure, your soul moves into the target's body, and the target's soul becomes trapped in the container. On a success, the target resists your efforts to possess it, and you can't attempt to possess it again for 24 hours.

Once you possess a creature's body, you control it. Your game statistics are replaced by the statistics of the creature, though you retain your personality and your INT, WIS, and CHA scores. You retain the benefit of your own class features. If the target has any class levels, you can't use any of its class features.

Meanwhile, the possessed creature's soul can perceive from the container using its own senses, but it can't move or take actions at all.

While possessing a body, you can use your action to return from the host body to the container if it is within 100 feet of you, returning the host creature's soul to its body. If the host body dies while you're in it, the creature dies, and you must make a CHA save against your own spellcasting DC.

On a success, you return to the container if it is within 100 feet of you. Otherwise, you die.

If the container is destroyed or the spell ends, your soul immediately returns to your body. If your body is more than 100 feet away from you or if your body is dead when you attempt to return to it, you die. If another creature's soul is in the container when it is destroyed, the creature's soul returns to its body if the body is alive and within 100 feet. Otherwise, that creature dies.

When the spell ends, the container is destroyed.

### Magic Mouth

_2nd-Circle Arcane and Wyrd Ritual (Illusion)_

**Casting Time:** 10 minutes
**Range:** 30 feet
**Components:** V, S, M (a small bit of honeycomb and jade dust worth at least 10 gp, which the spell consumes)
**Duration:** Until dispelled

You implant a message within an object in range, a message that is uttered when a trigger condition is met. Choose an object that you can see and that isn't being worn or carried by another creature. Then speak the message, which must be twenty-five words or fewer, though it can be delivered over as long as 10 minutes. Finally, determine the circumstance that will trigger the spell to deliver your message.

When that circumstance occurs, a magical mouth appears on the object and recites the message in your voice and at the same volume you spoke. If the object you chose has a mouth or something that looks like a mouth (for example, the mouth of a statue), the magical mouth appears there so that the words appear to come from the object's mouth.

When you cast this spell, you can have the spell end after it delivers its message, or it can remain and repeat its message when the trigger occurs.

The triggering circumstance can be as general or as detailed as you like, though it must be based on visual or audible conditions that occur within 30 feet of the object.

For example, you could instruct the mouth to speak when any creature moves within 30 feet of the object or when a silver bell rings within 30 feet of it.

### Magnificent Mansion

_7th-Circle Arcane and Wyrd Ritual (Conjuration)_

**Casting Time:** 10 minutes
**Range:** 300 feet
**Components:** V, S, M (a miniature portal carved from ivory, a small piece of polished marble, and a tiny silver spoon, each item worth at least 5 gp)
**Duration:** 24 hours

You conjure an extradimensional dwelling in range that lasts for the duration. You choose where its one entrance is located. The entrance shimmers faintly and is 5 feet wide and 10 feet tall. You and any creature you designate when you cast the spell can enter the extradimensional dwelling as long as the portal remains open. You can open or close the portal if you are within 30 feet of it. While closed, the portal is invisible. Beyond the portal is a magnificent foyer with numerous chambers beyond. The atmosphere is clean, fresh, and warm.

You can create any floor plan you like, but the space can't exceed 50 cubes, each cube being 10 feet on each side.

The place is furnished and decorated as you choose. It contains sufficient food to serve a nine-course banquet for up to one hundred people. A staff of one hundred neartransparent servants attends all who enter. You decide the visual appearance of these servants and their attire. They are completely obedient to your orders. Each servant can perform any task a normal human servant could perform, but they can't attack or take any action that would directly harm another creature. Thus, the servants can fetch things, clean, mend, fold clothes, light fires, serve food, pour wine, and so on. The servants can go anywhere in the mansion but can't leave it. Furnishings and other objects created by this spell dissipate into smoke if removed from the mansion. When the spell ends, any creatures inside the extradimensional space are expelled into the open spaces nearest to the entrance.

### Metamorphosis

_9th-Circle Primordial Ritual (Transmutation)_

**Casting Time:** 10 minutes
**Range:** Touch
**Components:** V, S, M (raw silk worth 1,000 gp, which the spell consumes)
**Duration:** Instantaneous

You touch a willing creature and transform it in one of the following four ways (the target must agree with the option you choose):

- If the creature is Humanoid, you can change its lineage to any other lineage you choose. It loses any traits and abilities associated with its former lineage and gains any traits and abilities of the new lineage.
- You can lower one of its ability scores by 2 (modifier decreases by -1) and increase a different ability score by 2 (modifier increases by +1), to a maximum of 20.
- You give the creature birdlike or batlike wings. It gains a flying speed of 30 feet. Alternatively, you can remove its wings, which takes away an existing flying speed.

You might be able to achieve a different effect of a similar kind with the permission of your GM.

A creature can be affected by this spell only once a year.

If the spell is cast on it again before a year has passed, the casting fails.

### Mirage Arcane

_7th-Circle Arcane and Wyrd Ritual (Illusion)_

**Casting Time:** 10 minutes
**Range:** Sight
**Components:** V, S
**Duration:** 10 days

You make terrain in an area up to 1 mile square look, sound, smell, and even feel like some other sort of terrain. The terrain's general shape remains the same, however. Open fields or a road could be made to resemble a swamp, hill, crevasse, or some other difficult or impassable terrain. A pond can be made to seem like a grassy meadow, a precipice like a gentle slope, or a rock-strewn gully like a wide and smooth road.

Similarly, you can alter the appearance of structures in the area or add them where none are present. The spell doesn't disguise, conceal, or add creatures.

The illusion includes audible, visual, tactile, and olfactory elements, so it can turn clear ground into difficult terrain (or vice versa) or otherwise impede movement through the area.

Any piece of the illusory terrain (such as a rock or stick) that is removed from the spell's area disappears immediately.

Creatures with truesight can see through the illusion to the terrain's true form; however, all other elements of the illusion remain, so while the creature is aware of the illusion's presence, the creature can still physically interact with the illusion.

### Oculus Blossoms

_7th-Circle Primordial Ritual (Divination)_

**Casting Time:** 1 minute
**Range:** 60 feet
**Components:** V, S, M (a seed or bulb carved with the image of an eye)
**Duration:** 24 hours

You cause up to five Tiny magical flowers to sprout in spaces you can see within range. The spaces you select must contain an area suitable for supporting a living plant, such as a patch of open ground, a pot of dirt, or similar. The flowers that appear are always of a type native to the area and at a glance are indistinguishable from nonmagical flowers.

Until the spell ends, you can use an action to see and hear through any of the flowers as if you were standing in their space. You can do so no matter how far away you are from the flowers as long as you and the flowers are on the same plane of existence. While perceiving through a flower, you can use a bonus action to switch your senses to a different flower or end the effect.

Creatures that can see invisible things via spells like see invisibility or features like truesight see a luminous, intangible eye in place of a blossom when they look at a flower created by this spell.

If you attempt to cast this spell a second time while flowers from the first casting are still active, the flowers from the first casting are immediately destroyed.

_At Higher Circles._ As you unlock higher circles, this ritual grows in potency. Once you have access to 8th-circle spell slots, the duration increases to 7 days. Once you have access to 9th-circle spell slots, the duration is 30 days.

### Phantom Steed

_3rd-Circle Wyrd Ritual (Illusion)_

**Casting Time:** 1 minute
**Range:** 30 feet
**Components:** V, S, M (an apple made of gold worth 5 gp)
**Duration:** 1 hour

A Large, quasi-real, horse-like creature appears on the ground in an unoccupied space of your choice within range. You decide the creature's appearance, but it is equipped with a saddle, bit, and bridle. Any of the equipment created by the spell vanishes in a puff of smoke if it is ever more than 10 feet away from the steed.

For the duration, you or a creature you choose can ride the steed. The creature uses the statistics for a riding horse, except it has a speed of 100 feet and can travel 10 miles in an hour, or 13 miles at a fast pace. When the spell ends, the steed gradually fades, giving the rider 1 minute to dismount. The spell ends if you use an action to dismiss it, if the steed takes any damage, or if you use this spell to summon a different steed.

### Planar Ally

_6th-Circle Divine and Wyrd Ritual (Conjuration)_

**Casting Time:** 10 minutes
**Range:** 60 feet
**Components:** V, S
**Duration:** Instantaneous

You beseech an otherworldly entity for aid. The being must be known to you: a god, a demon prince, or some other being of cosmic power. That entity sends a Celestial, an Elemental, or a Fiend loyal to it to aid you, making the creature appear in an unoccupied space within range. If you know a specific creature's name, you can speak that name when you cast this spell to request that creature, though you might get a different creature anyway (GM's choice).

When the creature appears, it is under no compulsion to behave in any particular way. You can ask the creature to perform a service in exchange for payment, but it isn't obliged to do so. The requested task could range from simple ("fly us across the chasm," or "help us fight a battle") to complex ("spy on our enemies," or "protect us during our foray into the dungeon"). You must be able to communicate with the creature to bargain for its services.

Payment can take a variety of forms. A Celestial might require a sizable donation of gold or magic items to an allied temple, while a Fiend might demand a living sacrifice or a gift of treasure. Some creatures might exchange their service for a quest undertaken by you.

As a rule of thumb, a task that can be measured in minutes requires a payment worth 100 gp per minute. A task measured in hours requires 1,000 gp per hour. And a task measured in days (up to 10 days) requires 10,000 gp per day. The GM can adjust these payments based on the circumstances under which you cast the spell. If the task is aligned with the creature's ethos, the payment might be halved or even waived. Nonhazardous tasks typically require only half the suggested payment, while especially dangerous tasks might require a greater gift.

Creatures rarely accept tasks that would cause them harm.

After the creature completes the task or when the agreed-upon duration of service expires, the creature returns to its home plane after reporting back to you (if appropriate to the task and if possible). If you are unable to agree on a price for the creature's service, the creature immediately returns to its home plane.

You can't have more than one ally at any one time.

Once you cast this spell, you can't beseech the same entity with another casting of this spell until 7 days have passed.

### Planar Binding

_5th-Circle Arcane, Divine, and Wyrd Ritual (Abjuration)_

**Casting Time:** 1 hour
**Range:** 60 feet
**Components:** V, S, M (a jewel worth at least 1,000 gp, which the spell consumes)
**Duration:** 24 hours

You attempt to bind a Celestial, an Elemental, a Fey, or a Fiend into your service. The creature must be within range for the entire casting of the spell. Typically, the creature is first summoned into the center of an inverted magic circle in order to keep it trapped while this spell is cast.

At the completion of the casting, the target must make a CHA save. On a failed save, it is bound to serve you for the duration. If the creature was summoned or created by another spell, that spell's duration is extended to match the duration of this spell.

A bound creature must follow your instructions to the best of its ability. You might command the creature to accompany you on an adventure, to guard a location, or to deliver a message. The creature obeys the letter of your instructions, but if the creature is hostile to you, it strives to twist your words to achieve its own objectives. If the creature carries out your instructions completely before the spell ends, it travels to you to report this fact if you are on the same plane of existence. If you are on a different plane of existence, it returns to the place where you bound it and remains there until the spell ends.

_At Higher Circles._ As you unlock higher circles, this ritual grows in potency. Once you have access to 6th-circle spell slots, the duration increases to 10 days. Once you have access to 7th-circle spell slots the duration is 30 days. Once you have access to 8th-circle spell slots, the duration is 180 days. Once you have access to 9th-circle spell slots, the duration is 1 year.

### Prayer Of Healing

_2nd-Circle Divine Ritual (Necromancy)_

**Casting Time:** 10 minutes
**Range:** 30 feet
**Components:** V
**Duration:** Instantaneous

Up to six creatures of your choice that you can see within range each regain hit points equal to 2d8 + your spellcasting ability modifier. This spell has no effect on Constructs or Undead.

Once you cast this spell, you can't do so again until you complete a long rest.

_At Higher Circles._ As you unlock higher circles, this ritual grows in potency. Once you have access to 3rd-circle spell slots or higher, the healing increases by 1d8 for each slot above 2nd.

### Private Sanctum

_4th-Circle Arcane and Divine Ritual (Abjuration)_

**Casting Time:** 10 minutes
**Range:** 120 feet
**Components:** V, S, M (a thin sheet of lead, a piece of opaque glass, a wad of cloth, and powdered chrysolite)
**Duration:** 24 hours

You make an area within range magically secure. The area is a cube that can be as small as 5 feet to as large as 100 feet on each side. The spell lasts for the duration or until you use an action to dismiss it.

When you cast the spell, you decide what sort of security the spell provides, choosing any or all of the following properties:

- Sounds can't pass through the barrier at the edge of the warded area.
- The barrier of the warded area appears dark and foggy, preventing vision (including darkvision) through it.
- Sensors created by divination spells can't appear inside the protected area or pass through the barrier at its perimeter.
- Creatures in the area can't be targeted by divination spells.
- Nothing can teleport into or out of the warded area.
- Planar travel is blocked within the warded area.

Casting this spell on the same spot every day for a year makes this effect permanent.

If you attempt to cast this spell a second time while the first casting is active, the effects of the first spell immediately end.

_At Higher Circles._ When you cast this spell using a spell slot of 5th circle or higher, you can increase the size of the cube by 100 feet for each slot you have access to above 4th. Thus, you could protect a cube that can be up to 200 feet on one side once you have access to 5th-circle spell slots.

### Purify Food And Drink

_1st-Circle Divine and Primordial Ritual (Transmutation)_

**Casting Time:** 1 minute
**Range:** 10 feet
**Components:** V, S
**Duration:** Instantaneous

All nonmagical food and drink within a 5-foot-radius sphere centered on a point of your choice within range is purified and rendered free of poison and disease.

### Raise Dead

_5th-Circle Divine Ritual (Necromancy)_

**Casting Time:** 1 hour
**Range:** Touch
**Components:** V, S, M (a diamond worth at least 500 gp, which the spell consumes)
**Duration:** Instantaneous

You return a dead creature you touch to life, provided that it has been dead no longer than 10 days. If the creature's soul is both willing and at liberty to rejoin the body, the creature returns to life with 1 HP.

This spell also neutralizes any poisons and cures nonmagical diseases that affected the creature at the time it died. This spell doesn't, however, remove magical diseases, curses, or similar effects; if these aren't first removed prior to casting the spell, they take effect when the creature returns to life. The spell can't return an Undead creature to life. This spell closes all mortal wounds, but it doesn't restore missing body parts. If the creature is lacking body parts or organs integral for its survival - its head, for instance - the spell automatically fails.

Coming back from the dead is an ordeal. The target takes a -4 penalty to all attack rolls, saves, and ability checks.

Every time the target finishes a long rest, the penalty is reduced by 1 until it disappears.

### Regenerate

_7th-Circle Divine and Primordial Ritual (Transmutation)_

**Casting Time:** 1 minute
**Range:** Touch
**Components:** V, S, M (a prayer wheel or an intact sleeve of snakeskin and holy water)
**Duration:** 1 hour

You touch a creature and stimulate its natural healing ability. The target regains 4d8 + 15 hit points. For the duration of the spell, the target regains 1 HP at the start of each of its turns (10 HP each minute).

The target's severed body members (fingers, legs, tails, and so on), if any, are restored after 2 minutes. If you have the severed part and hold it to the stump, the spell instantaneously causes the limb to knit to the stump.

Once you cast this spell, you can't do so again until you complete a long rest.

### Reincarnate

_5th-Circle Primordial Ritual (Transmutation)_

**Casting Time:** 1 hour
**Range:** Touch
**Components:** V, S, M (rare oils and unguents worth at least 1,000 gp, which the spell consumes)
**Duration:** Instantaneous

You touch a dead Humanoid or a piece of a dead Humanoid. Provided that the creature has been dead no longer than 10 days, the spell forms a new adult body for it and then calls the soul to enter that body. If the target's soul isn't free or willing to do so, the spell fails.

The magic fashions a new body for the creature to inhabit, which likely causes the creature's lineage to change. The GM rolls a d100 and consults the Reincarnation Bodies table to determine what form the creature takes when restored to life, or the GM chooses a form.

The reincarnated creature recalls its former life and experiences. It retains the capabilities it had in its original form, except it exchanges its original lineage for the new one and changes its lineage traits accordingly.

#### Table: Reincarnation Bodies

| d100  | LINEAGE             |
| ----- | ------------------- |
| 01-04 | Beastkin, Avian     |
| 05-08 | Beastkin, Agile     |
| 09-10 | Beastkin, Aquatic   |
| 11-13 | Beastkin, Sturdy    |
| 14-24 | Dwarf               |
| 25-36 | Elf                 |
| 37-76 | Human               |
| 77-81 | Orc                 |
| 82-93 | Smallfolk, Gnome    |
| 94-00 | Smallfolk, Halfling |

### Resurrection

_7th-Circle Divine Ritual (Necromancy)_

**Casting Time:** 1 hour
**Range:** Touch
**Components:** V, S, M (a diamond worth at least 1,000 gp, which the spell consumes)
**Duration:** Instantaneous

You touch a dead creature that has been dead for no more than a century, that didn't die of old age, and that isn't Undead. If its soul is free and willing, the target returns to life with all its hit points.

This spell neutralizes any poisons and cures normal diseases afflicting the creature when it died. It doesn't, however, remove magical diseases, curses, and the like; if such effects aren't removed prior to casting the spell, they afflict the target on its return to life.

This spell closes all mortal wounds and restores any missing body parts.

Coming back from the dead is an ordeal. The target takes a -4 penalty to all attack rolls, saves, and ability checks.

Every time the target finishes a long rest, the penalty is reduced by 1 until it disappears.

Casting this spell to restore life to a creature that has been dead for one year or longer taxes you greatly. Until you finish a long rest, you can't cast spells again, and you have disadvantage on all attack rolls, ability checks, and saves.

### Scrying

_5th-Circle Arcane and Divine Ritual (Divination)_

**Casting Time:** 10 minutes
**Range:** Self
**Components:** V, S, M (a focus worth at least 1,000 gp such as a crystal ball, a silver mirror, or a font filled with holy water)
**Duration:** Concentration, up to 10 minutes

You can see and hear a particular creature you choose that is on the same plane of existence as you. The target must make a WIS save, the DC for which is modified by how well you know the target and the sort of physical connection you have to it. If a target knows you're casting this spell, it can fail the save voluntarily if it wants to be observed.

On a successful save, the target isn't affected, and you can't use this spell against it again for 24 hours.

On a failed save, the spell creates an invisible sensor within 10 feet of the target. You can see and hear through the sensor as if you were there. The sensor moves with the target, remaining within 10 feet of it for the duration. A creature that can see invisible objects sees the sensor as a luminous orb about the size of your fist.

Instead of targeting a creature, you can choose a location you have seen before as the target of this spell. When you do, the sensor appears at that location and doesn't move.

#### Tables: Scrying Wisdom Save Modifer

| KNOWLEDGE                                 | SAVE DC MODIFIER |
| ----------------------------------------- | ---------------: |
| Secondhand (you have heard of the target) |               +5 |
| Firsthand (you have met the target)       |               +0 |
| Familiar (you know the target well)       |               -5 |

| CONNECTION                                        | SAVE DC MODIFIER |
| ------------------------------------------------- | ---------------: |
| Likeness or picture                               |               -2 |
| Possession or garment                             |               -4 |
| Body part, lock of hair, bit of nail, or the like |              -10 |

### Secret Chest

_4th-Circle Arcane and Wyrd Ritual (Abjuration)_

**Casting Time:** 1 minute
**Range:** Touch
**Components:** V, S, M (an exquisite chest, 3 feet by 2 feet by 2 feet, constructed from rare materials worth at least 5,000 gp and a Tiny replica made from the same materials worth at least 50 gp)
**Duration:** Instantaneous

You hide a chest and all its contents on the Ethereal Plane.

You must touch the chest and the miniature replica that serves as a material component for the spell. The chest can contain up to 12 cubic feet of nonliving material (3 feet by 2 feet by 2 feet).

While the chest remains on the Ethereal Plane, you can use an action and touch the replica to recall the chest. It appears in an unoccupied space on the ground within 5 feet of you.

You can send the chest back to the Ethereal Plane by using an action and touching both the chest and the replica.

After 60 days, there is a cumulative 5 percent chance per day that the spell's effect ends. This effect ends if you cast this spell again, if the smaller replica chest is destroyed, or if you choose to end the spell as an action. If the spell ends and the larger chest is on the Ethereal Plane, it is irretrievably lost.

If you attempt to cast this spell while a chest from a previous casting is still active, the spell fails.

### Simulacrum

_7th-Circle Arcane Ritual (Illusion)_

**Casting Time:** 12 hours
**Range:** Touch
**Components:** V, S, M (snow or ice in quantities sufficient to make a life-size copy of the duplicated creature; some hair, fingernail clippings, or other piece of that creature's body placed inside the snow or ice; and powdered ruby worth 1,500 gp sprinkled over the duplicate, which the spell consumes)
**Duration:** Until dispelled

You shape an illusory duplicate of one Beast or Humanoid that is within range for the entire casting time of the spell.

The duplicate is a creature, partially real and formed from ice or snow, and it can take actions and otherwise be affected as a normal creature. It appears to be the same as the original, but it has half the creature's hit point maximum and is formed without any equipment. Otherwise, the illusion uses all the statistics of the creature it duplicates.

The simulacrum is friendly to you and creatures you designate. It obeys your spoken commands, moving and acting in accordance with your wishes and acting on your turn in combat. The simulacrum lacks the ability to learn or become more powerful, so it never increases its level or other abilities, nor can it regain expended spell slots.

If the simulacrum is damaged, you can repair it in an alchemical laboratory using rare herbs and minerals worth 100 gp per hit point it regains. The simulacrum lasts until it drops to 0 HP, at which point it reverts to snow and melts instantly.

If you cast this spell again, any currently active duplicates you created with this spell are instantly destroyed.

### Song Of The Forest

_4th-Circle Primordial Ritual (Transmutation)_

**Casting Time:** 10 minutes
**Range:** Self
**Components:** V, S, M (a dried leaf, crumpled and released)
**Duration:** Concentration, up to 10 minutes

You attune your senses to the natural world so that you can detect every sound that occurs within 60 feet of you. You can clearly picture the source of each sound in your mind.

While the spell is active, you have tremorsense to a range of 10 feet, darkvision to a range of 30 feet, and you have advantage on WIS (Perception) checks.

Once you cast this spell, you can't do so again until you complete a long rest.

### Speak With Dead

_3rd-Circle Divine and Wyrd Ritual (Necromancy)_

**Casting Time:** 1 minute
**Range:** 10 feet
**Components:** V, S, M (burning incense)
**Duration:** 10 minutes

You grant the semblance of life and intelligence to a corpse of your choice within range, allowing it to answer the questions you pose. The corpse must still have a mouth and can't be Undead. The spell fails if the corpse was the target of this spell within the last 10 days.

Until the spell ends, you can ask the corpse up to five questions. The corpse knows only what it knew in life, including the languages it knew. Answers are usually brief, cryptic, or repetitive, and the corpse is under no compulsion to offer a truthful answer if you are hostile to it or it recognizes you as an enemy. This spell doesn't return the creature's soul to its body, only its animating spirit.

Thus, the corpse can't learn new information, doesn't comprehend anything that has happened since it died, and can't speculate about future events.

Once you target a particular corpse with this spell, you can never cast this ritual on that particular corpse again.

### Symbol

_7th-Circle Arcane Ritual (Abjuration)_

**Casting Time:** 1 minute
**Range:** Touch
**Components:** V, S, M (mercury, phosphorus, and powdered diamond and opal with a total value of at least 1,000 gp, which the spell consumes)
**Duration:** Until dispelled or triggered

When you cast this spell, you inscribe a harmful glyph either on a surface (such as a section of floor, a wall, or a table) or within an object that can be closed to conceal the glyph (such as a book, a scroll, or a treasure chest). If you choose a surface, the glyph can cover an area of the surface no larger than 10 feet in diameter. If you choose an object, that object must remain in its place; if the object is moved more than 10 feet from where you cast this spell, the glyph is broken, and the spell ends without being triggered.

The glyph is nearly invisible, requiring an INT (Investigation) check against your spell save DC to find it.

You decide what triggers the glyph when you cast the spell. For glyphs inscribed on a surface, the most typical triggers include touching or stepping on the glyph, removing another object covering it, approaching within a certain distance of it, or manipulating the object that holds it. For glyphs inscribed within an object, the most common triggers are opening the object, approaching within a certain distance of it, or seeing or reading the glyph.

You can further refine the trigger so the spell is activated only under certain circumstances or according to a creature's physical characteristics (such as height or weight), or physical kind (for example, the ward could be set to affect hags or shapechangers). You can also specify creatures that don't trigger the glyph, such as those who say a certain password.

When you inscribe the glyph, choose one of the following options for its effect. Once triggered, the glyph glows, filling a 60-foot-radius sphere with dim light for 10 minutes, after which time the spell ends. Each creature in the sphere when the glyph activates is targeted by its effect, as is a creature that enters the sphere for the first time on a turn or ends its turn there.

**Death.** Each target must make a CON save, taking 10d10 necrotic damage on a failed save, or half as much damage on a successful save.

**Discord.** Each target must make a CON save. On a failed save, a target bickers and argues with other creatures for 1 minute. During this time, it is incapable of meaningful communication and has disadvantage on attack rolls and ability checks.

**Fear.** Each target must make a WIS save, becoming frightened for 1 minute on a failed save. While frightened, the target drops whatever it is holding and must move at least 30 feet away from the glyph on each of its turns, if able.

**Hopelessness.** Each target must make a CHA save.

On a failed save, the target is consumed with despair for 1 minute. During this time, it can't attack or target any creature with harmful abilities, spells, or other magical effects.

Overwhelm. Each target must make an INT save. On a failed save, the target is driven incapacitated for 1 minute.

While incapacitated the target can't take actions, can't understand what other creatures say, can't read, and speaks only in gibberish. The GM controls its movement, which is erratic.

**Pain.** Each target must make a CON save, becoming incapacitated with excruciating pain for 1 minute on a failed save.

**Sleep.** Each target must make a WIS save, falling unconscious for 10 minutes on a failed save. A creature awakens if it takes damage or if someone uses an action to shake or slap it awake.

**Stunning.** Each target must make a WIS save, becoming stunned for 1 minute on a failed save.

### Teleportation Circle

_5th-Circle Arcane Ritual (Conjuration)_

**Casting Time:** 1 minute
**Range:** 10 feet
**Components:** V, M (rare chalks and inks infused with precious gems worth 50 gp, which the spell consumes)
**Duration:** 1 round

As you cast the spell, you draw a 10-foot-diameter circle on the ground inscribed with sigils that link your location to a permanent teleportation circle of your choice whose sigil sequence you know and that is on the same plane of existence as you. A shimmering portal opens within the circle you drew and remains open until the end of your next turn. Any creature that enters the portal instantly appears within 5 feet of the destination circle or in the nearest unoccupied space if that space is occupied.

Many major temples, guilds, and other important places have permanent teleportation circles inscribed somewhere within their confines. Each such circle includes a unique sigil sequence - a string of magical runes arranged in a particular pattern. When you first gain the ability to cast this spell, you learn the sigil sequences for two destinations on the Material Plane, determined by the GM. You can learn additional sigil sequences during your adventures.

You can commit a new sigil sequence to memory after studying it for 1 minute.

You can create a permanent teleportation circle by casting this spell in the same location every day for one year. You need not use the circle to teleport when you cast the spell in this way.

### Tiny Hut

_3rd-Circle Arcane Ritual (Evocation)_

**Casting Time:** 10 minutes
**Range:** Self (10-foot-radius dome)
**Components:** V, S, M (a small crystal bead)
**Duration:** 8 hours

A 10-foot-radius, immobile dome of force springs into existence around and above you and remains stationary for the duration. The spell ends if you leave its area.

Nine creatures of Medium size or smaller can fit inside the dome with you. The spell fails if its area includes a larger creature or more than nine creatures. Creatures and objects within the dome when you cast this spell can move through it freely. All other creatures and objects are barred from passing through it. Spells and other magical effects can't extend through the dome or be cast through it. The atmosphere inside the space is comfortable and dry, regardless of the weather outside.

Until the spell ends, you can command the interior to become dimly lit or dark. The dome is an opaque color of your choice from the outside, but it is transparent from the inside.

### True Resurrection

_9th-Circle Divine Ritual (Necromancy)_

**Casting Time:** 1 hour
**Range:** Touch
**Components:** V, S, M (a sprinkle of holy water and diamonds worth at least 25,000 gp, which the spell consumes)
**Duration:** Instantaneous

You touch a creature that has been dead for no longer than 200 years and that died for any reason except old age. If the creature's soul is free and willing, the creature is restored to life with all its hit points.

This spell closes all wounds, neutralizes any poison, cures all diseases, and lifts any curses affecting the creature when it died. The spell replaces damaged or missing organs and limbs.

The spell can even provide a new body if the original no longer exists, in which case you must speak the creature's name. The creature then appears in an unoccupied space you choose within 10 feet of you.

### Unseen Servant

_1st-Circle Arcane and Wyrd Ritual (Conjuration)_

**Casting Time:** 1 minute
**Range:** 60 feet
**Components:** V, S, M (a piece of string and a bit of wood)
**Duration:** 1 hour

This spell creates an invisible, mindless, shapeless force that performs simple tasks at your command until the spell ends. The servant springs into existence in an unoccupied space on the ground within range. It has AC 10, 1 HP, a STR of 3 (-4), and it can't attack. If it drops to 0 HP, the spell ends.

Once on each of your turns as a bonus action, you can mentally command the servant to move up to 15 feet and interact with an object. The servant can perform simple tasks that a human servant could do, such as fetching things, cleaning, mending, folding clothes, lighting fires, serving food, and pouring wine. Once you give the command, the servant performs the task to the best of its ability until it completes the task, then waits for your next command.

If you command the servant to perform a task that would move it more than 60 feet away from you, the spell ends.

If you cast this spell again while a servant created by the first casting is still active, the servant created from the first casting is immediately destroyed.

### Water Walk

_3rd-Circle Primordial Ritual (Transmutation)_

**Casting Time:** 10 minutes
**Range:** 30 feet
**Components:** V, S, M (a piece of cork)
**Duration:** 1 hour

This spell grants the ability to move across any liquid surface - water, acid, mud, snow, quicksand, or lava - as if it were harmless solid ground (creatures crossing molten lava can still take damage from the heat). Up to ten willing creatures you can see within range gain this ability for the duration.

If you target a creature submerged in a liquid, the spell carries the target to the surface of the liquid at a rate of 60 feet per round.
